/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.audioloader.cache;

import de.maxhenkel.audioplayer.AudioPlayerMod;
import de.maxhenkel.audioplayer.audioloader.cache.CachedAudio;
import de.maxhenkel.audioplayer.audioloader.cache.LruCache;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;

public class AudioCache {
    private final Map<UUID, CachedAudio> audioCache;

    public AudioCache() {
        this.audioCache = Collections.synchronizedMap(new LruCache(AudioPlayerMod.SERVER_CONFIG.cacheSize.get()));
    }

    public CachedAudio getAudio(UUID audioId) throws Exception {
        CachedAudio cachedAudio = this.audioCache.get(audioId);
        if (cachedAudio != null) {
            return cachedAudio;
        }
        cachedAudio = CachedAudio.load(audioId);
        this.audioCache.put(audioId, cachedAudio);
        return cachedAudio;
    }

    public void invalidate(UUID audioId) {
        this.audioCache.remove(audioId);
    }

    public void clear() {
        this.audioCache.clear();
    }
}

