/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.command;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.annotations.Min;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.audioplayer.audioplayback.PlayerManager;
import de.maxhenkel.audioplayer.lang.Lang;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

@Command(value={"audioplayer"})
@RequiresPermission(value="audioplayer.play_command")
public class PlayCommands {
    @Command(value={"play"})
    public void play(CommandContext<class_2168> context, @Name(value="sound") UUID sound, @Name(value="location") class_243 location, @Name(value="range") @Min(value="0") float range) throws CommandSyntaxException {
        @Nullable class_3222 player = ((class_2168)context.getSource()).method_44023();
        PlayerManager.instance().playLocational(((class_2168)context.getSource()).method_9225(), location, sound, player, range, null, null);
        ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.play_successful", sound), false);
    }

    @Command(value={"stop"})
    private static int stop(CommandContext<class_2168> context, @Name(value="audioId") UUID audioId) {
        int count = PlayerManager.instance().stopAll(audioId);
        if (count > 0) {
            ((class_2168)context.getSource()).method_9226(() -> Lang.translatable("audioplayer.stop_streams_successful", count), false);
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)Lang.translatable("audioplayer.no_audio_file_id_found", audioId));
        }
        return count;
    }
}

