/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.config;

import de.maxhenkel.audioplayer.AudioPlayerMod;
import de.maxhenkel.audioplayer.configbuilder.ConfigBuilder;
import de.maxhenkel.audioplayer.configbuilder.MigratableConfig;
import de.maxhenkel.audioplayer.configbuilder.entry.ConfigEntry;

public class ServerConfig {
    private static final int CONFIG_VERSION = 1;
    public ConfigEntry<Integer> configVersion;
    public final ConfigEntry<String> filebinUrl;
    public final ConfigEntry<Long> maxUploadSize;
    public final ConfigEntry<Integer> goatHornCooldown;
    public final ConfigEntry<Integer> audioLoaderThreads;
    public final ConfigEntry<Float> musicDiscRange;
    public final ConfigEntry<Float> noteBlockRange;
    public final ConfigEntry<Float> goatHornRange;
    public final ConfigEntry<Float> maxGoatHornRange;
    public final ConfigEntry<Float> maxNoteBlockRange;
    public final ConfigEntry<Float> maxMusicDiscRange;
    public final ConfigEntry<Boolean> allowWavUpload;
    public final ConfigEntry<Boolean> allowMp3Upload;
    public final ConfigEntry<Float> maxUploadDuration;
    public final ConfigEntry<Float> maxMusicDiscDuration;
    public final ConfigEntry<Float> maxNoteBlockDuration;
    public final ConfigEntry<Float> maxGoatHornDuration;
    public final ConfigEntry<Integer> cacheSize;
    public final ConfigEntry<Boolean> runWebServer;

    public ServerConfig(ConfigBuilder builder) {
        this.configVersion = builder.integerEntry("config_version", (Integer)1, "The config version - Used for migration", "WARNING: DO NOT CHANGE THIS VALUE");
        this.filebinUrl = builder.stringEntry("filebin_url", "https://filebin.net/", "The URL of the Filebin service that the mod should use");
        this.maxUploadSize = builder.longEntry("max_upload_size", (Long)20000000L, 1L, (Long)Integer.MAX_VALUE, "The maximum allowed size of an uploaded file in bytes");
        this.goatHornCooldown = builder.integerEntry("goat_horn_cooldown", (Integer)140, 1, (Integer)Short.MAX_VALUE, "The cooldown of goat horns with custom audio in ticks");
        this.audioLoaderThreads = builder.integerEntry("audio_loader_threads", (Integer)2, 1, Integer.MAX_VALUE, "The number of threads to use for loading audio");
        this.musicDiscRange = builder.floatEntry("music_disc_range", Float.valueOf(65.0f), Float.valueOf(1.0f), Float.valueOf(2.1474836E9f), "The default range of music discs with custom audio in blocks");
        this.noteBlockRange = builder.floatEntry("note_block_range", Float.valueOf(16.0f), Float.valueOf(1.0f), Float.valueOf(2.1474836E9f), "The default range of note blocks with custom audio in blocks");
        this.goatHornRange = builder.floatEntry("goat_horn_range", Float.valueOf(256.0f), Float.valueOf(1.0f), Float.valueOf(2.1474836E9f), "The default range of goat horns with custom audio in blocks");
        this.maxMusicDiscRange = builder.floatEntry("max_music_disc_range", Float.valueOf(256.0f), Float.valueOf(1.0f), Float.valueOf(2.1474836E9f), "The maximum allowed range of a music disc with custom audio in blocks");
        this.maxNoteBlockRange = builder.floatEntry("max_note_block_range", Float.valueOf(256.0f), Float.valueOf(1.0f), Float.valueOf(2.1474836E9f), "The maximum allowed range of a note block with custom audio in blocks");
        this.maxGoatHornRange = builder.floatEntry("max_goat_horn_range", Float.valueOf(512.0f), Float.valueOf(1.0f), Float.valueOf(2.1474836E9f), "The maximum allowed range of a goat horn with custom audio in blocks");
        this.allowWavUpload = builder.booleanEntry("allow_wav_upload", true, "Whether users should be able to upload .wav files", "Note that .wav files are not compressed and can be very large", "Playing .wav files may result in more RAM and storage usage");
        this.allowMp3Upload = builder.booleanEntry("allow_mp3_upload", true, "Whether users should be able to upload .mp3 files", "Note that .mp3 files require Simple Voice Chats mp3 decoder", "Playing .mp3 files can be slightly more CPU intensive");
        this.maxUploadDuration = builder.floatEntry("max_import_duration", Float.valueOf(300.0f), Float.valueOf(1.0f), Float.valueOf(Float.MAX_VALUE), "The maximum allowed duration of a custom audio file in seconds");
        this.maxMusicDiscDuration = builder.floatEntry("max_music_disc_duration", Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(Float.MAX_VALUE), "The maximum allowed duration of a custom music disc in seconds", "Use -1 to disable the limit");
        this.maxNoteBlockDuration = builder.floatEntry("max_note_block_duration", Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(Float.MAX_VALUE), "The maximum allowed duration of a note block with custom audio in seconds", "Use -1 to disable the limit");
        this.maxGoatHornDuration = builder.floatEntry("max_goat_horn_duration", Float.valueOf(-1.0f), Float.valueOf(-1.0f), Float.valueOf(Float.MAX_VALUE), "The maximum allowed duration of a custom goat horn in seconds", "Use -1 to disable the limit");
        this.cacheSize = builder.integerEntry("audio_cache_size", (Integer)128, 0, Integer.MAX_VALUE, "The maximum amount of audio files that are cached in memory", "Setting this to 0 will disable the cache", "A higher value will result in less disk reads, but more RAM usage");
        this.runWebServer = builder.booleanEntry("run_web_server", false, "If the mod should run a webserver for uploads", "You can configure the webserver in the webserver.properties config", "The webserver.properties will only be generated if this option is set to true", "NOTE: This option is experimental and subject to change");
    }

    public static void migrate(MigratableConfig migratableConfig) {
        String configVersionString = migratableConfig.get("config_version");
        int configVersion = 0;
        if (configVersionString != null) {
            try {
                configVersion = Integer.parseInt(configVersionString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (configVersion == 0) {
            ServerConfig.migrateFrom0To1(migratableConfig);
            configVersion = 1;
        }
    }

    private static void migrateFrom0To1(MigratableConfig migratableConfig) {
        AudioPlayerMod.LOGGER.info("Migrating config from version 0 to 1");
        migratableConfig.set("config_version", "1");
        migratableConfig.set("max_music_disc_duration", "-1");
        migratableConfig.set("max_note_block_duration", "-1");
        migratableConfig.set("max_goat_horn_duration", "-1");
    }
}

