/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.utils.upgrade;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.maxhenkel.audioplayer.AudioPlayerMod;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@Deprecated
public class FileNameManager {
    private final Path file;
    private final Gson gson;
    private Map<UUID, String> fileNames;

    public FileNameManager(Path file) {
        this.file = file;
        this.gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
        this.fileNames = new HashMap<UUID, String>();
        this.load();
    }

    public void load() {
        if (!Files.exists(this.file, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.file);){
            Type fileNameMapType = new TypeToken<Map<UUID, String>>(this){}.getType();
            this.fileNames = (Map)this.gson.fromJson((Reader)reader, fileNameMapType);
        }
        catch (Exception e) {
            AudioPlayerMod.LOGGER.error("Failed to load file name mappings", (Throwable)e);
        }
        if (this.fileNames == null) {
            this.fileNames = new HashMap<UUID, String>();
        }
    }

    public Map<UUID, String> getFileNames() {
        return this.fileNames;
    }
}

