/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.audioloader.importer;

import de.maxhenkel.audioplayer.api.importer.AudioImportInfo;
import de.maxhenkel.audioplayer.api.importer.AudioImporter;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_3222;

public class UrlImporter
implements AudioImporter {
    public static final String USER_AGENT = "AudioPlayer";
    private final UUID soundId = UUID.randomUUID();
    private final String urlString;
    private URL url;

    public UrlImporter(String url) {
        this.urlString = url;
    }

    @Override
    public AudioImportInfo onPreprocess(@Nullable class_3222 player) throws Exception {
        this.url = new URI(this.urlString).toURL();
        return new AudioImportInfo(this.soundId, UrlImporter.getFileNameFromUrl(this.url.toString()));
    }

    @Nullable
    public static String getFileNameFromUrl(String url) {
        String name = url.substring(url.lastIndexOf(47) + 1).trim();
        if (name.isEmpty()) {
            return null;
        }
        return name;
    }

    @Override
    public byte[] onProcess(@Nullable class_3222 player) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.connect();
        try (InputStream is = connection.getInputStream();){
            byte[] byArray = is.readAllBytes();
            return byArray;
        }
    }

    @Override
    public void onPostprocess(@Nullable class_3222 player) throws Exception {
    }

    @Override
    public String getHandlerName() {
        return "url";
    }
}

