package gay.rooot.tradeoffer.client.mixins;

import gay.rooot.tradeoffer.TradeOfferMeow;
import net.minecraft.class_1661;
import net.minecraft.class_1728;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_465;
import net.minecraft.class_492;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static gay.rooot.tradeoffer.TradeOfferMeow.TRADE_OFFER_TEXT;

@Mixin(class_492.class)
public abstract class MerchantScreenMixin extends class_465<class_1728> {

    @Unique
    private boolean isTradingRightMeow = false;

    public MerchantScreenMixin(class_1728 handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Inject(at = @At("HEAD"), method = "render")
    public void render(final class_332 context, final int mouseX, final int mouseY, final float delta, final CallbackInfo ci) {
        if (this.field_2797.field_7761.size() < 3) {
            isTradingRightMeow = false;
            return;
        }

        class_1799 stack = this.field_2797.field_7761.get(2).method_7677();
        isTradingRightMeow = !stack.method_7960() && !stack.method_7909().method_7876().equals("block.minecraft.air");
    }

    @Inject(at = @At("HEAD"), method = "drawLevelInfo", cancellable = true)
    public void drawLevelInfo(final class_332 context, final int x, final int y, final class_1914 tradeOffer, final CallbackInfo ci) {
        if (isTradingRightMeow) ci.cancel();
    }

    @Redirect(at = @At(value = "INVOKE", target = "Lnet/minecraft/text/Text;translatable(Ljava/lang/String;[Ljava/lang/Object;)Lnet/minecraft/text/MutableText;"), method = "drawForeground")
    public class_5250 drawForeground_translatable(final String key, final Object[] args) {
        return isTradingRightMeow ? TRADE_OFFER_TEXT : class_2561.method_43469(key, args);
    }

    @Redirect(at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawText(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;IIIZ)V", ordinal = 0), method = "drawForeground")
    public void drawText_translatable(final class_332 ctx, final class_327 textRenderer, final class_2561 text, final int x, final int y, int color, final boolean shadow) {
        if (color == 0xff404040 && isTradingRightMeow) {
            color = 0xffffffff;
        }

        ctx.method_51439(textRenderer, text, x, y, color, shadow);
    }

    @Inject(at = @At("HEAD"), method = "drawForeground")
    public void drawForeground(final class_332 context, final int mouseX, final int mouseY, final CallbackInfo ci) {
        if (isTradingRightMeow) {
            TradeOfferMeow.hotDemonTwinksInHell(context, this.field_22793, this.field_2792);
        }
    }
}
