/*
 * Decompiled with CFR 0.152.
 */
package com.example.diamondbank;

import com.example.diamondbank.DiamondBankPlugin;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class BankDataManager {
    private final DiamondBankPlugin plugin;

    public BankDataManager(DiamondBankPlugin plugin) {
        this.plugin = plugin;
    }

    public Map<UUID, Double> loadPlayerBalances() {
        HashMap<UUID, Double> balances = new HashMap<UUID, Double>();
        FileConfiguration cfg = this.plugin.getConfig();
        ConfigurationSection section = cfg.getConfigurationSection("players");
        if (section == null) {
            return balances;
        }
        for (String key : section.getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(key);
                double bal = section.getDouble(key + ".balance", 0.0);
                balances.put(uuid, bal);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return balances;
    }

    public void savePlayerBalances(Map<UUID, Double> balances) {
        FileConfiguration cfg = this.plugin.getConfig();
        cfg.set("players", null);
        for (Map.Entry<UUID, Double> entry : balances.entrySet()) {
            String key = entry.getKey().toString();
            cfg.set("players." + key + ".balance", (Object)entry.getValue());
        }
        this.plugin.saveConfig();
    }

    public Set<Location> loadBankChests() {
        HashSet<Location> set = new HashSet<Location>();
        FileConfiguration cfg = this.plugin.getConfig();
        List raw = cfg.getStringList("bank-chests");
        if (raw == null) {
            return set;
        }
        for (String s : raw) {
            World w;
            String[] parts = s.split(";");
            if (parts.length != 4 || (w = Bukkit.getWorld((String)parts[0])) == null) continue;
            try {
                int x = Integer.parseInt(parts[1]);
                int y = Integer.parseInt(parts[2]);
                int z = Integer.parseInt(parts[3]);
                set.add(new Location(w, (double)x, (double)y, (double)z));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return set;
    }

    public void saveBankChests(Set<Location> chests) {
        FileConfiguration cfg = this.plugin.getConfig();
        ArrayList<CallSite> lines = new ArrayList<CallSite>();
        for (Location loc : chests) {
            if (loc.getWorld() == null) continue;
            String line = loc.getWorld().getName() + ";" + loc.getBlockX() + ";" + loc.getBlockY() + ";" + loc.getBlockZ();
            lines.add((CallSite)((Object)line));
        }
        cfg.set("bank-chests", lines);
        this.plugin.saveConfig();
    }
}

