/*
 * Decompiled with CFR 0.152.
 */
package com.example.diamondbank;

import com.example.diamondbank.BankDataManager;
import com.example.diamondbank.DiamondBankPlugin;
import com.example.diamondbank.ScoreboardHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;

public class BankManager {
    private final DiamondBankPlugin plugin;
    private final BankDataManager dataManager;
    private final Map<UUID, Double> balances = new HashMap<UUID, Double>();
    private final Set<Location> bankChests = new HashSet<Location>();
    private ScoreboardHandler scoreboardHandler;

    public BankManager(DiamondBankPlugin plugin, BankDataManager dataManager) {
        this.plugin = plugin;
        this.dataManager = dataManager;
        this.balances.putAll(dataManager.loadPlayerBalances());
        this.bankChests.addAll(dataManager.loadBankChests());
    }

    public void setScoreboardHandler(ScoreboardHandler scoreboardHandler) {
        this.scoreboardHandler = scoreboardHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAccountCount() {
        BankManager bankManager = this;
        synchronized (bankManager) {
            return this.balances.size();
        }
    }

    public synchronized double getBalance(UUID playerId) {
        return this.balances.getOrDefault(playerId, 0.0);
    }

    public synchronized boolean has(UUID playerId, double amount) {
        return amount >= 0.0 && this.getBalance(playerId) >= amount;
    }

    public synchronized void deposit(UUID playerId, double amount) {
        if (amount <= 0.0) {
            return;
        }
        double current = this.balances.getOrDefault(playerId, 0.0);
        double newBal = current + amount;
        this.balances.put(playerId, newBal);
        this.dataManager.savePlayerBalances(this.balances);
        if (this.scoreboardHandler != null) {
            this.scoreboardHandler.updateAllPlayers();
        }
    }

    public synchronized boolean withdraw(UUID playerId, double amount) {
        if (amount <= 0.0) {
            return false;
        }
        double current = this.balances.getOrDefault(playerId, 0.0);
        if (current < amount) {
            return false;
        }
        double newBal = current - amount;
        this.balances.put(playerId, newBal);
        this.dataManager.savePlayerBalances(this.balances);
        if (this.scoreboardHandler != null) {
            this.scoreboardHandler.updateAllPlayers();
        }
        return true;
    }

    public synchronized void addBankChest(Location location) {
        this.bankChests.add(location);
        this.dataManager.saveBankChests(this.bankChests);
    }

    public synchronized void removeBankChest(Location location) {
        this.bankChests.remove(location);
        this.dataManager.saveBankChests(this.bankChests);
    }

    public synchronized boolean isBankChest(Location location) {
        return this.bankChests.contains(location);
    }

    public synchronized Set<Location> getBankChests() {
        return Collections.unmodifiableSet(new HashSet<Location>(this.bankChests));
    }

    public synchronized Map<UUID, Double> getAllBalances() {
        return new HashMap<UUID, Double>(this.balances);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll() {
        BankManager bankManager = this;
        synchronized (bankManager) {
            this.dataManager.savePlayerBalances(this.balances);
            this.dataManager.saveBankChests(this.bankChests);
        }
    }
}

