/*
 * Decompiled with CFR 0.152.
 */
package com.example.diamondbank;

import com.example.diamondbank.BankDataManager;
import com.example.diamondbank.BankManager;
import com.example.diamondbank.ScoreboardHandler;
import com.example.diamondbank.commands.BalanceCommand;
import com.example.diamondbank.commands.CurrencyCommand;
import com.example.diamondbank.commands.GiveBankChestCommand;
import com.example.diamondbank.commands.WithdrawCommand;
import com.example.diamondbank.economy.DiamondBankEconomy;
import com.example.diamondbank.listeners.BankChestListener;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public class DiamondBankPlugin
extends JavaPlugin {
    private static DiamondBankPlugin instance;
    private BankDataManager dataManager;
    private BankManager bankManager;
    private ScoreboardHandler scoreboardHandler;
    private DiamondBankEconomy economyProvider;
    private NamespacedKey bankChestKey;
    private NamespacedKey hopperOwnerKey;
    private Material currencyItem;
    private Material currencyBlock;
    private int currencyBlockMultiplier;
    private String currencyNameSingular;
    private String currencyNamePlural;

    public static DiamondBankPlugin getInstance() {
        return instance;
    }

    public NamespacedKey getBankChestKey() {
        return this.bankChestKey;
    }

    public NamespacedKey getHopperOwnerKey() {
        return this.hopperOwnerKey;
    }

    public BankManager getBankManager() {
        return this.bankManager;
    }

    public ScoreboardHandler getScoreboardHandler() {
        return this.scoreboardHandler;
    }

    public void onEnable() {
        instance = this;
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().severe("Vault not found! Disabling SimpleBanking.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.saveDefaultConfig();
        this.loadCurrencyConfig();
        this.bankChestKey = new NamespacedKey((Plugin)this, "bank_chest");
        this.hopperOwnerKey = new NamespacedKey((Plugin)this, "hopper_owner");
        this.dataManager = new BankDataManager(this);
        this.bankManager = new BankManager(this, this.dataManager);
        this.scoreboardHandler = new ScoreboardHandler(this, this.bankManager);
        this.bankManager.setScoreboardHandler(this.scoreboardHandler);
        this.scoreboardHandler.init();
        this.getCommand("givebankchest").setExecutor((CommandExecutor)new GiveBankChestCommand(this, this.bankManager));
        this.getCommand("withdraw").setExecutor((CommandExecutor)new WithdrawCommand(this.bankManager));
        this.getCommand("balance").setExecutor((CommandExecutor)new BalanceCommand(this.bankManager));
        CurrencyCommand currencyCmd = new CurrencyCommand(this, this.bankManager);
        this.getCommand("currency").setExecutor((CommandExecutor)currencyCmd);
        this.getCommand("currency").setTabCompleter((TabCompleter)currencyCmd);
        this.getServer().getPluginManager().registerEvents((Listener)new BankChestListener(this, this.bankManager, this.scoreboardHandler), (Plugin)this);
        this.registerEconomyProvider();
        Bukkit.getOnlinePlayers().forEach(this.scoreboardHandler::applyToPlayer);
        this.getLogger().info("SimpleBanking enabled. Loaded " + this.bankManager.getAccountCount() + " player accounts.");
    }

    public void onDisable() {
        this.bankManager.saveAll();
        if (this.economyProvider != null) {
            this.getServer().getServicesManager().unregister(Economy.class, (Object)this.economyProvider);
        }
        this.getLogger().info("SimpleBanking disabled. Saved " + this.bankManager.getAccountCount() + " player accounts.");
    }

    private void registerEconomyProvider() {
        RegisteredServiceProvider existing = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (existing != null) {
            this.getLogger().warning("Another Economy provider is already registered: " + ((Economy)existing.getProvider()).getName() + ". SimpleBanking economy will still be registered at highest priority.");
        }
        this.economyProvider = new DiamondBankEconomy(this, this.bankManager);
        this.getServer().getServicesManager().register(Economy.class, (Object)this.economyProvider, (Plugin)this, ServicePriority.Highest);
        this.getLogger().info("Registered SimpleBanking as Vault provider (per-player balances).");
    }

    private void loadCurrencyConfig() {
        FileConfiguration cfg = this.getConfig();
        String itemName = cfg.getString("currency.item", "DIAMOND");
        String blockName = cfg.getString("currency.block", "DIAMOND_BLOCK");
        int mult = cfg.getInt("currency.block_multiplier", 9);
        String singular = cfg.getString("currency.name_singular", "Diamond");
        String plural = cfg.getString("currency.name_plural", "Diamonds");
        Material item = this.parseMaterial(itemName, Material.DIAMOND);
        Material block = this.parseMaterial(blockName, Material.DIAMOND_BLOCK);
        this.currencyItem = item;
        this.currencyBlock = block;
        this.currencyBlockMultiplier = Math.max(1, mult);
        this.currencyNameSingular = singular;
        this.currencyNamePlural = plural;
    }

    private Material parseMaterial(String name, Material fallback) {
        try {
            if (name == null || name.isEmpty()) {
                return fallback;
            }
            return Material.valueOf((String)name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning("Invalid material '" + name + "', falling back to " + fallback.name());
            return fallback;
        }
    }

    public Material getCurrencyItem() {
        return this.currencyItem;
    }

    public Material getCurrencyBlock() {
        return this.currencyBlock;
    }

    public int getCurrencyBlockMultiplier() {
        return this.currencyBlockMultiplier;
    }

    public String getCurrencyNameSingular() {
        return this.currencyNameSingular;
    }

    public String getCurrencyNamePlural() {
        return this.currencyNamePlural;
    }

    public void updateCurrency(Material item, Material block, int mult, String singular, String plural) {
        this.currencyItem = item;
        this.currencyBlock = block;
        this.currencyBlockMultiplier = Math.max(1, mult);
        this.currencyNameSingular = singular;
        this.currencyNamePlural = plural;
        this.getConfig().set("currency.item", (Object)(item != null ? item.name() : null));
        this.getConfig().set("currency.block", (Object)(block != null ? block.name() : null));
        this.getConfig().set("currency.block_multiplier", (Object)this.currencyBlockMultiplier);
        this.getConfig().set("currency.name_singular", (Object)singular);
        this.getConfig().set("currency.name_plural", (Object)plural);
        this.saveConfig();
        if (this.scoreboardHandler != null) {
            this.scoreboardHandler.init();
            this.scoreboardHandler.updateAllPlayers();
        }
    }
}

