/*
 * Decompiled with CFR 0.152.
 */
package com.example.diamondbank;

import com.example.diamondbank.BankManager;
import com.example.diamondbank.DiamondBankPlugin;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class ScoreboardHandler {
    private final DiamondBankPlugin plugin;
    private final BankManager bankManager;
    private Scoreboard scoreboard;
    private Objective tabObjective;
    private Objective belowNameObjective;

    public ScoreboardHandler(DiamondBankPlugin plugin, BankManager bankManager) {
        this.plugin = plugin;
        this.bankManager = bankManager;
    }

    public void init() {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        if (manager == null) {
            this.plugin.getLogger().severe("ScoreboardManager is null! Scoreboard will not work.");
            return;
        }
        this.scoreboard = manager.getNewScoreboard();
        this.tabObjective = this.scoreboard.registerNewObjective("db_tab", "dummy", String.valueOf(ChatColor.AQUA) + this.plugin.getCurrencyNamePlural());
        this.tabObjective.setDisplaySlot(DisplaySlot.PLAYER_LIST);
        this.belowNameObjective = this.scoreboard.registerNewObjective("db_below", "dummy", String.valueOf(ChatColor.AQUA) + this.plugin.getCurrencyNamePlural());
        this.belowNameObjective.setDisplaySlot(DisplaySlot.BELOW_NAME);
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.applyToPlayer(p);
        }
        this.updateAllPlayers();
    }

    public void applyToPlayer(Player player) {
        if (this.scoreboard == null) {
            return;
        }
        player.setScoreboard(this.scoreboard);
        this.updatePlayer(player);
    }

    public void updateAllPlayers() {
        if (this.scoreboard == null) {
            return;
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.updatePlayer(p);
        }
    }

    private void updatePlayer(Player player) {
        if (this.scoreboard == null || this.tabObjective == null || this.belowNameObjective == null) {
            return;
        }
        int balance = (int)Math.round(this.bankManager.getBalance(player.getUniqueId()));
        String entry = player.getName();
        this.tabObjective.getScore(entry).setScore(balance);
        this.belowNameObjective.getScore(entry).setScore(balance);
    }
}

