/*
 * Decompiled with CFR 0.152.
 */
package com.example.diamondbank.commands;

import com.example.diamondbank.BankManager;
import com.example.diamondbank.DiamondBankPlugin;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class BalanceCommand
implements CommandExecutor {
    private final BankManager bankManager;

    public BalanceCommand(BankManager bankManager) {
        this.bankManager = bankManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("diamondbank.balance")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to view balances.");
            return true;
        }
        Map<UUID, Double> all = this.bankManager.getAllBalances();
        ArrayList<Map.Entry<UUID, Double>> list = new ArrayList<Map.Entry<UUID, Double>>();
        for (Map.Entry<UUID, Double> e : all.entrySet()) {
            if (!(e.getValue() > 0.0)) continue;
            list.add(e);
        }
        if (list.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "No players have any diamonds in the bank yet.");
            return true;
        }
        list.sort((a, b) -> Double.compare((Double)b.getValue(), (Double)a.getValue()));
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "==== " + DiamondBankPlugin.getInstance().getCurrencyNamePlural() + " Bank Leaderboard ====");
        int position = 1;
        for (Map.Entry entry : list) {
            UUID uuid = (UUID)entry.getKey();
            double balance = (Double)entry.getValue();
            OfflinePlayer off = Bukkit.getOfflinePlayer((UUID)uuid);
            String name = off.getName();
            if (name == null) {
                name = uuid.toString().substring(0, 8);
            }
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + position + ". " + String.valueOf(ChatColor.WHITE) + name + String.valueOf(ChatColor.DARK_GRAY) + " - " + String.valueOf(ChatColor.AQUA) + (int)Math.round(balance) + String.valueOf(ChatColor.AQUA) + " " + DiamondBankPlugin.getInstance().getCurrencyNamePlural());
            ++position;
        }
        return true;
    }
}

