/*
 * Decompiled with CFR 0.152.
 */
package com.example.diamondbank.commands;

import com.example.diamondbank.BankManager;
import com.example.diamondbank.DiamondBankPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class CurrencyCommand
implements CommandExecutor,
TabCompleter {
    private final DiamondBankPlugin plugin;
    private final BankManager bankManager;

    public CurrencyCommand(DiamondBankPlugin plugin, BankManager bankManager) {
        this.plugin = plugin;
        this.bankManager = bankManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Material item;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can run this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("diamondbank.admin")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to change the currency.");
            return true;
        }
        if (this.bankManager.getAllBalances().values().stream().anyMatch(v -> v != null && v > 0.0)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Currency cannot be changed while any player has a non-empty bank balance. Ask players to withdraw first.");
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /currency <item> [block] [multiplier] [singular] [plural]");
            return true;
        }
        String itemArg = this.stripNamespace(args[0]);
        String blockArg = args.length >= 2 ? this.stripNamespace(args[1]) : null;
        String multArg = args.length >= 3 ? args[2] : null;
        String singularArg = args.length >= 4 ? args[3] : null;
        String pluralArg = args.length >= 5 ? args[4] : null;
        try {
            item = Material.valueOf((String)itemArg.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid item: " + args[0]);
            return true;
        }
        Material block = null;
        if (blockArg != null && !blockArg.isBlank()) {
            try {
                block = Material.valueOf((String)blockArg.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid block: " + args[1]);
                return true;
            }
        }
        int mult = 9;
        if (multArg != null && !multArg.isBlank()) {
            try {
                mult = Integer.parseInt(multArg);
                if (mult <= 0) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Multiplier must be a positive integer.");
                    return true;
                }
            }
            catch (NumberFormatException e) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid multiplier: " + multArg);
                return true;
            }
        }
        String singular = singularArg != null && !singularArg.isBlank() ? singularArg : this.prettify(item.name());
        String plural = pluralArg != null && !pluralArg.isBlank() ? pluralArg : singular + "s";
        this.plugin.updateCurrency(item, block, mult, singular, plural);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Currency updated to: " + singular + " (block: " + (block != null ? block.name() : "none") + ", x" + mult + ")");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> out;
        block8: {
            block7: {
                out = new ArrayList<String>();
                if (!(sender instanceof Player) || !sender.hasPermission("diamondbank.admin")) {
                    return out;
                }
                if (args.length != 1) break block7;
                String prefix = args[0].toLowerCase(Locale.ROOT);
                String typed = prefix.startsWith("minecraft:") ? prefix.substring("minecraft:".length()) : prefix;
                Material[] materialArray = Material.values();
                int n = materialArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Material m = materialArray[n2];
                    if (m.isItem()) {
                        String id = m.name().toLowerCase(Locale.ROOT);
                        if (typed.isEmpty() || id.startsWith(typed)) {
                            out.add("minecraft:" + id);
                        }
                    }
                    ++n2;
                }
                break block8;
            }
            if (args.length != 2) break block8;
            String prefix = args[1].toLowerCase(Locale.ROOT);
            String typed = prefix.startsWith("minecraft:") ? prefix.substring("minecraft:".length()) : prefix;
            Material[] materialArray = Material.values();
            int n = materialArray.length;
            int n3 = 0;
            while (n3 < n) {
                Material m = materialArray[n3];
                if (m.isBlock()) {
                    String id = m.name().toLowerCase(Locale.ROOT);
                    if (typed.isEmpty() || id.startsWith(typed)) {
                        out.add("minecraft:" + id);
                    }
                }
                ++n3;
            }
        }
        return out;
    }

    private String stripNamespace(String name) {
        if (name == null) {
            return null;
        }
        String s = name.trim();
        if (s.toLowerCase(Locale.ROOT).startsWith("minecraft:")) {
            return s.substring("minecraft:".length());
        }
        return s;
    }

    private String prettify(String name) {
        String s = name.toLowerCase(Locale.ROOT).replace('_', ' ');
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }
}

