/*
 * Decompiled with CFR 0.152.
 */
package com.example.diamondbank.commands;

import com.example.diamondbank.BankManager;
import com.example.diamondbank.DiamondBankPlugin;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class WithdrawCommand
implements CommandExecutor {
    private final BankManager bankManager;

    public WithdrawCommand(BankManager bankManager) {
        this.bankManager = bankManager;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int stackSize;
        int amount;
        void player;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can withdraw diamonds.");
            return true;
        }
        Player player2 = (Player)sender;
        if (!player.hasPermission("diamondbank.withdraw")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to withdraw from the bank.");
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /withdraw <amount>");
            return true;
        }
        try {
            amount = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Please enter a valid number.");
            return true;
        }
        if (amount <= 0) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Amount must be greater than zero.");
            return true;
        }
        UUID id = player.getUniqueId();
        if (!this.bankManager.has(id, amount)) {
            double bal = this.bankManager.getBalance(id);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have enough diamonds in your account. Balance: " + (int)bal);
            return true;
        }
        PlayerInventory inv = player.getInventory();
        DiamondBankPlugin plugin = DiamondBankPlugin.getInstance();
        int mult = plugin.getCurrencyBlockMultiplier();
        int amountUnits = amount;
        int blocks = 0;
        int items = amountUnits;
        if (plugin.getCurrencyBlock() != null) {
            blocks = amountUnits / mult;
            items = amountUnits % mult;
        }
        if (!this.hasCapacity(inv, plugin, blocks, items)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have enough inventory space.");
            return true;
        }
        if (!this.bankManager.withdraw(id, amount)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Withdrawal failed. Please try again.");
            return true;
        }
        if (plugin.getCurrencyBlock() != null) {
            int b = blocks;
            while (b > 0) {
                stackSize = Math.min(64, b);
                inv.addItem(new ItemStack[]{new ItemStack(plugin.getCurrencyBlock(), stackSize)});
                b -= stackSize;
            }
        }
        int r = items;
        while (r > 0) {
            stackSize = Math.min(64, r);
            inv.addItem(new ItemStack[]{new ItemStack(plugin.getCurrencyItem(), stackSize)});
            r -= stackSize;
        }
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "You withdrew " + amount + " " + plugin.getCurrencyNamePlural() + " from your account.");
        return true;
    }

    private boolean hasCapacity(PlayerInventory inv, DiamondBankPlugin plugin, int blocks, int items) {
        ItemStack[] contents;
        int empty = 0;
        int blockSpace = 0;
        int itemSpace = 0;
        ItemStack[] itemStackArray = contents = inv.getStorageContents();
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack it = itemStackArray[n2];
            if (it == null || it.getType() == Material.AIR) {
                ++empty;
            } else if (plugin.getCurrencyBlock() != null && it.getType() == plugin.getCurrencyBlock()) {
                blockSpace += 64 - it.getAmount();
            } else if (it.getType() == plugin.getCurrencyItem()) {
                itemSpace += 64 - it.getAmount();
            }
            ++n2;
        }
        int blocksPlaced = Math.min(blockSpace, blocks);
        int blocksRemaining = blocks - blocksPlaced;
        int blockSlotsNeeded = (int)Math.ceil((double)blocksRemaining / 64.0);
        if (blockSlotsNeeded > empty) {
            return false;
        }
        int emptyAfterBlocks = empty - blockSlotsNeeded;
        int itemsPlaced = Math.min(itemSpace, items);
        int itemsRemaining = items - itemsPlaced;
        int itemSlotsNeeded = (int)Math.ceil((double)itemsRemaining / 64.0);
        return itemSlotsNeeded <= emptyAfterBlocks;
    }
}

