/*
 * Decompiled with CFR 0.152.
 */
package com.example.diamondbank.economy;

import com.example.diamondbank.BankManager;
import com.example.diamondbank.DiamondBankPlugin;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class DiamondBankEconomy
implements Economy {
    private final DiamondBankPlugin plugin;
    private final BankManager bankManager;

    public DiamondBankEconomy(DiamondBankPlugin plugin, BankManager bankManager) {
        this.plugin = plugin;
        this.bankManager = bankManager;
    }

    public boolean isEnabled() {
        return this.plugin.isEnabled();
    }

    public String getName() {
        return "SimpleBanking";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return 0;
    }

    public String format(double amount) {
        return String.format("% ,.0f %s", amount, this.plugin.getCurrencyNamePlural());
    }

    public String currencyNamePlural() {
        return this.plugin.getCurrencyNamePlural();
    }

    public String currencyNameSingular() {
        return this.plugin.getCurrencyNameSingular();
    }

    public boolean hasAccount(String playerName) {
        return true;
    }

    public boolean hasAccount(OfflinePlayer player) {
        return true;
    }

    public boolean hasAccount(String playerName, String worldName) {
        return true;
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return true;
    }

    public double getBalance(String playerName) {
        OfflinePlayer p = Bukkit.getOfflinePlayer((String)playerName);
        return this.getBalance(p);
    }

    public double getBalance(OfflinePlayer player) {
        UUID id = player.getUniqueId();
        return this.bankManager.getBalance(id);
    }

    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public boolean has(String playerName, double amount) {
        OfflinePlayer p = Bukkit.getOfflinePlayer((String)playerName);
        return this.has(p, amount);
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.bankManager.has(player.getUniqueId(), amount);
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.has(player, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        return this.withdrawPlayer(Bukkit.getOfflinePlayer((String)playerName), amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        UUID id = player.getUniqueId();
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.bankManager.getBalance(id), EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative amounts.");
        }
        if (!this.bankManager.withdraw(id, amount)) {
            return new EconomyResponse(0.0, this.bankManager.getBalance(id), EconomyResponse.ResponseType.FAILURE, "Insufficient funds.");
        }
        return new EconomyResponse(amount, this.bankManager.getBalance(id), EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        return this.depositPlayer(Bukkit.getOfflinePlayer((String)playerName), amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        UUID id = player.getUniqueId();
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.bankManager.getBalance(id), EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative amounts.");
        }
        this.bankManager.deposit(id, amount);
        return new EconomyResponse(amount, this.bankManager.getBalance(id), EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse createBank(String name, String player) {
        return this.notImplementedBank(name);
    }

    public EconomyResponse createBank(String name, OfflinePlayer player) {
        return this.notImplementedBank(name);
    }

    public EconomyResponse deleteBank(String name) {
        return this.notImplementedBank(name);
    }

    public EconomyResponse bankBalance(String name) {
        return this.notImplementedBank(name);
    }

    public EconomyResponse bankHas(String name, double amount) {
        return this.notImplementedBank(name);
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return this.notImplementedBank(name);
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return this.notImplementedBank(name);
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return this.notImplementedBank(name);
    }

    public EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        return this.notImplementedBank(name);
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return this.notImplementedBank(name);
    }

    public EconomyResponse isBankMember(String name, OfflinePlayer player) {
        return this.notImplementedBank(name);
    }

    public List<String> getBanks() {
        return Collections.emptyList();
    }

    private EconomyResponse notImplementedBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Bank accounts are not supported by DiamondBank.");
    }

    public boolean createPlayerAccount(String playerName) {
        return true;
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        return true;
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return true;
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        return true;
    }
}

