/*
 * Decompiled with CFR 0.152.
 */
package com.example.diamondbank.listeners;

import com.example.diamondbank.BankManager;
import com.example.diamondbank.DiamondBankPlugin;
import com.example.diamondbank.ScoreboardHandler;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Hopper;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class BankChestListener
implements Listener {
    private final DiamondBankPlugin plugin;
    private final BankManager bankManager;
    private final ScoreboardHandler scoreboardHandler;
    private final NamespacedKey bankChestKey;
    private final NamespacedKey hopperOwnerKey;

    public BankChestListener(DiamondBankPlugin plugin, BankManager bankManager, ScoreboardHandler scoreboardHandler) {
        this.plugin = plugin;
        this.bankManager = bankManager;
        this.scoreboardHandler = scoreboardHandler;
        this.bankChestKey = plugin.getBankChestKey();
        this.hopperOwnerKey = plugin.getHopperOwnerKey();
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        BlockState blockState;
        PersistentDataContainer pdc;
        ItemMeta meta;
        ItemStack hand;
        Block block = event.getBlockPlaced();
        Player player = event.getPlayer();
        if (block.getType() == Material.CHEST && (hand = event.getItemInHand()) != null && hand.getType() == Material.CHEST && (meta = hand.getItemMeta()) != null && (pdc = meta.getPersistentDataContainer()).has(this.bankChestKey, PersistentDataType.BYTE) && block.getState() instanceof Chest) {
            this.bankManager.addBankChest(block.getLocation());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "This chest is now a Bank Chest. Everyone deposits here.");
        }
        if (block.getType() == Material.HOPPER && (blockState = block.getState()) instanceof Hopper) {
            Hopper hopper = (Hopper)blockState;
            pdc = hopper.getPersistentDataContainer();
            pdc.set(this.hopperOwnerKey, PersistentDataType.STRING, (Object)player.getUniqueId().toString());
            hopper.update();
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Location loc;
        Block block = event.getBlock();
        BlockState state = block.getState();
        if (state instanceof Chest && this.bankManager.isBankChest(loc = block.getLocation())) {
            if (!event.getPlayer().hasPermission("diamondbank.admin")) {
                event.setCancelled(true);
                event.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "You cannot break a Bank Chest.");
                return;
            }
            this.bankManager.removeBankChest(loc);
            event.getPlayer().sendMessage(String.valueOf(ChatColor.YELLOW) + "Bank Chest removed.");
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.scoreboardHandler.applyToPlayer(event.getPlayer());
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack cursor;
        void player;
        int mult;
        Material blockMat;
        Material itemMat;
        Material m;
        ItemStack current;
        void chest;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player2 = (Player)humanEntity;
        Inventory top = event.getView().getTopInventory();
        InventoryHolder holder = top.getHolder();
        if (!(holder instanceof Chest)) {
            return;
        }
        Chest chest2 = (Chest)holder;
        if (!this.bankManager.isBankChest(chest.getLocation())) {
            return;
        }
        Inventory clickedInv = event.getClickedInventory();
        if (clickedInv == null) {
            return;
        }
        if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY && clickedInv instanceof PlayerInventory && (current = event.getCurrentItem()) != null && current.getAmount() > 0) {
            m = current.getType();
            itemMat = this.plugin.getCurrencyItem();
            blockMat = this.plugin.getCurrencyBlock();
            mult = this.plugin.getCurrencyBlockMultiplier();
            if (m == itemMat || blockMat != null && m == blockMat) {
                int amountUnits = m == itemMat ? current.getAmount() : current.getAmount() * mult;
                this.bankManager.deposit(player.getUniqueId(), amountUnits);
                event.setCurrentItem(null);
                event.setCancelled(true);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Deposited " + amountUnits + " " + this.plugin.getCurrencyNamePlural() + " into your bank account.");
                return;
            }
        }
        if (clickedInv.equals(top) && (cursor = event.getCursor()) != null && cursor.getAmount() > 0) {
            m = cursor.getType();
            itemMat = this.plugin.getCurrencyItem();
            blockMat = this.plugin.getCurrencyBlock();
            mult = this.plugin.getCurrencyBlockMultiplier();
            if (m == itemMat || blockMat != null && m == blockMat) {
                int amountUnits = m == itemMat ? cursor.getAmount() : cursor.getAmount() * mult;
                this.bankManager.deposit(player.getUniqueId(), amountUnits);
                event.setCursor(null);
                event.setCancelled(true);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Deposited " + amountUnits + " " + this.plugin.getCurrencyNamePlural() + " into your bank account.");
            }
        }
    }

    @EventHandler
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        Hopper hopper;
        PersistentDataContainer pdc;
        Inventory destination = event.getDestination();
        InventoryHolder destHolder = destination.getHolder();
        if (!(destHolder instanceof Chest)) {
            return;
        }
        Chest chest = (Chest)destHolder;
        Location chestLoc = ((Chest)destHolder).getLocation();
        if (!this.bankManager.isBankChest(chestLoc)) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || item.getAmount() <= 0) {
            return;
        }
        Material itemMat = this.plugin.getCurrencyItem();
        Material blockMat = this.plugin.getCurrencyBlock();
        int mult = this.plugin.getCurrencyBlockMultiplier();
        Material type = item.getType();
        if (type != itemMat && (blockMat == null || type != blockMat)) {
            return;
        }
        int amountUnits = type == itemMat ? item.getAmount() : item.getAmount() * mult;
        UUID depositor = null;
        Inventory initiator = event.getInitiator();
        InventoryHolder initHolder = initiator.getHolder();
        if (initHolder instanceof Hopper && (pdc = (hopper = (Hopper)initHolder).getPersistentDataContainer()).has(this.hopperOwnerKey, PersistentDataType.STRING)) {
            String uuidStr = (String)pdc.get(this.hopperOwnerKey, PersistentDataType.STRING);
            try {
                depositor = UUID.fromString(uuidStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (depositor == null && chestLoc.getWorld() != null) {
            Player nearest = null;
            double minDist = Double.MAX_VALUE;
            for (Player p : Bukkit.getOnlinePlayers()) {
                double d;
                if (!p.getWorld().equals(chestLoc.getWorld()) || !((d = p.getLocation().distance(chestLoc)) <= 16.0) || !(d < minDist)) continue;
                nearest = p;
                minDist = d;
            }
            if (nearest != null) {
                depositor = nearest.getUniqueId();
            }
        }
        if (depositor == null) {
            return;
        }
        this.bankManager.deposit(depositor, amountUnits);
        this.removeCurrencyFromInventory(event.getSource(), type, item.getAmount());
        event.setCancelled(true);
    }

    private void removeCurrencyFromInventory(Inventory source, Material material, int amountToRemove) {
        int remaining = amountToRemove;
        ItemStack[] contents = source.getContents();
        int i = 0;
        while (i < contents.length) {
            if (remaining <= 0) break;
            ItemStack stack = contents[i];
            if (stack != null && stack.getType() == material) {
                int stackAmount = stack.getAmount();
                if (stackAmount <= remaining) {
                    remaining -= stackAmount;
                    contents[i] = null;
                } else {
                    stack.setAmount(stackAmount - remaining);
                    remaining = 0;
                }
            }
            ++i;
        }
        source.setContents(contents);
    }
}

