/*
 * Decompiled with CFR 0.152.
 */
package CCPCT.TotemUtils.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    public boolean autoTotem = false;
    public int autoTotemDelay = 0;
    public boolean chatfeedback = true;
    public boolean replaceMainHandTotem = false;
    public boolean customSound = true;
    public String customSoundName = "minecraft:item.shield.break";
    public Float customSoundVolume = Float.valueOf(1.0f);
    public boolean totemPopScreen = true;
    public int totemPopScreenColour = 0xFF0000;
    public int totemPopScreenAlpha = 255;
    public int totemPopScreenDuration = 20;
    public int totemPopScreenWidth = 100;
    public int totemCountTime = 0;
    public int totemCountx = 10;
    public int totemCounty = 10;
    public int totemCountColour = 0xFFFFFF;
    public int totemCountAlpha = 255;
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("totemutils-config.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static ModConfig INSTANCE;

    public static ModConfig get() {
        if (INSTANCE == null) {
            ModConfig.load();
        }
        return INSTANCE;
    }

    public static void load() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                INSTANCE = (ModConfig)GSON.fromJson((Reader)Files.newBufferedReader(CONFIG_PATH), ModConfig.class);
            } else {
                INSTANCE = new ModConfig();
                ModConfig.save();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            INSTANCE = new ModConfig();
        }
    }

    public static void save() {
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)ModConfig.get()), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

