/*
 * Decompiled with CFR 0.152.
 */
package CCPCT.TotemUtils.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionChecker {
    private static final String GITHUB_TAGS_URL = "https://api.github.com/repos/CCPCT/Totem-Utils/tags";

    public static String getNewestVersion(String mcVersion) {
        try {
            String json = VersionChecker.fetchTagsJson();
            List<String> tags = VersionChecker.parseTagNames(json);
            return VersionChecker.findNewestModVersion(tags, mcVersion);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String fetchTagsJson() throws Exception {
        String line;
        URL url = URI.create(GITHUB_TAGS_URL).toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/vnd.github.v3+json");
        if (conn.getResponseCode() != 200) {
            throw new RuntimeException("GitHub API returned HTTP " + conn.getResponseCode());
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        StringBuilder jsonText = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            jsonText.append(line);
        }
        reader.close();
        return jsonText.toString();
    }

    private static List<String> parseTagNames(String json) {
        ArrayList<String> tags = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\"name\"\\s*:\\s*\"([^\"]+)\"");
        Matcher matcher = pattern.matcher(json);
        while (matcher.find()) {
            tags.add(matcher.group(1));
        }
        return tags;
    }

    private static String findNewestModVersion(List<String> tags, String mcVersion) {
        String newestModVersion = null;
        for (String tag : tags) {
            String[] parts = tag.split("-");
            if (parts.length < 2) continue;
            String modVersion = parts[0];
            String tagMcVersion = parts[1];
            System.out.println(modVersion + " - " + tagMcVersion);
            if (!tagMcVersion.equals(mcVersion) || newestModVersion != null && VersionChecker.compareVersions(modVersion, newestModVersion) <= 0) continue;
            newestModVersion = modVersion;
        }
        return newestModVersion;
    }

    public static int compareVersions(String v1, String v2) {
        return v1.compareTo(v2);
    }
}

