package CCPCT.TotemUtils.config;

import CCPCT.TotemUtils.client.TotemUtilsClient;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public class configScreen extends class_437 {

    protected configScreen() {
        super(class_2561.method_43470("Totem Utils Config"));
    }

    public static class_437 getConfigScreen(class_437 parent) {
        ModConfig.load();
        ConfigBuilder builder = ConfigBuilder.create()
                .setParentScreen(parent)
                .setTitle(class_2561.method_43470("Totem Utils Config"))
                .setSavingRunnable(ModConfig::save);

        ConfigCategory generalTab = builder.getOrCreateCategory(class_2561.method_43470("General"));
        ConfigCategory soundTab = builder.getOrCreateCategory(class_2561.method_43470("Sound"));
        ConfigCategory screenTab = builder.getOrCreateCategory(class_2561.method_43470("Screen"));
        ConfigCategory countTab = builder.getOrCreateCategory(class_2561.method_43470("Totem Counter"));

        ConfigEntryBuilder entryBuilder = builder.entryBuilder();

        // General settings
        generalTab.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43470("Chat feedback"),ModConfig.get().chatfeedback)
                .setDefaultValue(true)
                .setTooltip(class_2561.method_43470("Send feedback in chat (only u can see), e.g. u popped ur totem"))
                .setSaveConsumer(newValue -> ModConfig.get().chatfeedback = newValue)
                .build());

        generalTab.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43470("Auto Totem"),ModConfig.get().autoTotem)
                .setDefaultValue(false)
                .setTooltip(class_2561.method_43470("Don't use unless server allows"))
                .setSaveConsumer(newValue -> ModConfig.get().autoTotem = newValue)
                .build());

        generalTab.addEntry(entryBuilder.startIntField(class_2561.method_43470("Auto Totem Delay"), ModConfig.get().autoTotemDelay)
                .setTooltip(class_2561.method_43470("how long to wait before autototeming, in ticks"))
                .setDefaultValue(0)
                .setSaveConsumer(newValue -> ModConfig.get().autoTotemDelay = newValue)
                .build());

        generalTab.addEntry(entryBuilder.startStrField(class_2561.method_43470("Replenish totem hotkey"), TotemUtilsClient.swapTotemKey.method_1428())
                .setTooltip(class_2561.method_43470("Recommanded to modify this option in the option menu"))
                .setDefaultValue("key.keyboard.f")
                .setSaveConsumer(newValue -> {
                    try {
                        TotemUtilsClient.swapTotemKey.method_1422(class_3675.method_15981(newValue));
                    } catch (Exception e) {
                        TotemUtilsClient.swapTotemKey.method_1422(class_3675.method_15981("key.keyboard.f"));
                    }
                })
                .build());

        generalTab.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43470("Replenish main hand totem"),ModConfig.get().replenishMainHandTotem)
                .setDefaultValue(false)
                .setTooltip(class_2561.method_43470("Replenish main hand totem if popped or use hotkey, and nothing on mainhand"))
                .setSaveConsumer(newValue -> ModConfig.get().replenishMainHandTotem = newValue)
                .build());

        generalTab.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43470("Replenish other items"),ModConfig.get().replenishGeneralItem)
                .setDefaultValue(false)
                .setTooltip(class_2561.method_43470("also replenish main hand items"))
                .setSaveConsumer(newValue -> ModConfig.get().replenishGeneralItem = newValue)
                .build());

        generalTab.addEntry(entryBuilder.startStrField(class_2561.method_43470("Open config hotkey"), TotemUtilsClient.configScreenKey.method_1428())
                .setTooltip(class_2561.method_43470("Recommanded to modify this option in the option menu"))
                .setDefaultValue("key.keyboard.h")
                .setSaveConsumer(newValue -> {
                    try {
                        TotemUtilsClient.configScreenKey.method_1422(class_3675.method_15981(newValue));
                    } catch (Exception e) {
                        TotemUtilsClient.configScreenKey.method_1422(class_3675.method_15981("key.keyboard.h"));
                    }
                })
                .build());


        // Custom Sound toggle
        soundTab.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43470("Enable Custom Sound"),ModConfig.get().customSound)
                .setDefaultValue(true)
                .setTooltip(class_2561.method_43470("Enable custom sound when your totem pops (other players unaffected)"))
                .setSaveConsumer(newValue -> ModConfig.get().customSound = newValue)
                .build());

        soundTab.addEntry(entryBuilder.startStrField(class_2561.method_43470("Sound Event"), ModConfig.get().customSoundName)
            .setTooltip(class_2561.method_43470("Enter the sound ID (e.g., minecraft:entity.player.levelup)"))
            .setDefaultValue("minecraft:item.shield.break")
            .setSaveConsumer(newValue -> ModConfig.get().customSoundName = newValue)
            .build());

        soundTab.addEntry(entryBuilder.startFloatField(class_2561.method_43470("Volume"), ModConfig.get().customSoundVolume)
            .setTooltip(class_2561.method_43470("Set the volume (1.5 = 150%)"))
            .setMin(0.0f)
            .setMax(10.0f)
            .setDefaultValue(1.0f)
            .setSaveConsumer(newValue -> ModConfig.get().customSoundVolume = newValue)
            .build());

        //screen tab
        screenTab.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43470("Enable Overlay"),ModConfig.get().totemPopScreen)
            .setDefaultValue(false)
            .setTooltip(class_2561.method_43470("Render screen vintage overlay effect when popped totem"))
            .setSaveConsumer(newValue -> ModConfig.get().totemPopScreen = newValue)
            .build());

        screenTab.addEntry(builder.entryBuilder()
                .startColorField(class_2561.method_43470("Color"), ModConfig.get().totemPopScreenColour)
                .setDefaultValue(0xFFFF00)
                .setTooltip(class_2561.method_43470("Colour of overlay effect"))
                .setSaveConsumer(newValue -> ModConfig.get().totemPopScreenColour = newValue)
                .build());

        screenTab.addEntry(entryBuilder.startIntField(class_2561.method_43470("Alpha"), ModConfig.get().totemPopScreenAlpha)
                .setTooltip(class_2561.method_43470("Alpha (non-transparency/Opacity) of overlay"))
                .setDefaultValue(255)
                .setMin(0).setMax(255)
                .setSaveConsumer(newValue -> ModConfig.get().totemPopScreenAlpha = newValue)
                .build());

        screenTab.addEntry(entryBuilder.startIntField(class_2561.method_43470("Duration"), ModConfig.get().totemPopScreenDuration)
                .setTooltip(class_2561.method_43470("Overlay will end if equiped totem or after this value, in seconds"))
                .setDefaultValue(20)
                .setSaveConsumer(newValue -> ModConfig.get().totemPopScreenDuration = newValue)
                .build());

        screenTab.addEntry(entryBuilder.startIntField(class_2561.method_43470("Width"), ModConfig.get().totemPopScreenWidth)
                .setTooltip(class_2561.method_43470("Width of the overlay from border of the screen, in pixels"))
                .setDefaultValue(100)
                .setSaveConsumer(newValue -> ModConfig.get().totemPopScreenWidth = newValue)
                .build());

        //enabled size pos colour
        countTab.addEntry(entryBuilder.startIntField(class_2561.method_43470("Seconds to display"), ModConfig.get().totemCountTime)
                .setTooltip(class_2561.method_43470("-1=always render; 0=disable, positive integer=time to display after pop, in seconds"))
                .setDefaultValue(0)
                .setSaveConsumer(newValue -> ModConfig.get().totemCountTime = newValue)
                .build());

        countTab.addEntry(builder.entryBuilder()
                .startColorField(class_2561.method_43470("Text Color"), ModConfig.get().totemCountColour)
                .setDefaultValue(0x000000)
                .setTooltip(class_2561.method_43470("Colour of totem count text"))
                .setSaveConsumer(newValue -> ModConfig.get().totemCountColour = newValue)
                .build());

        countTab.addEntry(entryBuilder.startIntField(class_2561.method_43470("Alpha"), ModConfig.get().totemCountAlpha)
                .setTooltip(class_2561.method_43470("Alpha (non-transparency/Opacity) of totem count text"))
                .setDefaultValue(255)
                .setMin(0).setMax(255)
                .setSaveConsumer(newValue -> ModConfig.get().totemCountAlpha = newValue)
                .build());

        countTab.addEntry(entryBuilder.startIntField(class_2561.method_43470("X position"), ModConfig.get().totemCountx)
                .setTooltip(class_2561.method_43470("how many pixels from left of screen to start of text"))
                .setDefaultValue(10)
                .setSaveConsumer(newValue -> ModConfig.get().totemCountx = newValue)
                .build());

        countTab.addEntry(entryBuilder.startIntField(class_2561.method_43470("Y position"), ModConfig.get().totemCounty)
                .setTooltip(class_2561.method_43470("how many pixels from top of screen to start of text"))
                .setDefaultValue(10)
                .setSaveConsumer(newValue -> ModConfig.get().totemCounty = newValue)
                .build());

        return builder.build();
    }
}
