package CCPCT.TotemUtils.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import CCPCT.TotemUtils.config.ModConfig;
import CCPCT.TotemUtils.util.Chat;
import CCPCT.TotemUtils.util.Logic;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_757;

@Mixin(class_757.class)
public class onTotemPopMixin {

    @Unique
    public int overlaytickleft = 0;
    @Unique
    public int counttickleft = 0;
    @Unique
    private int autoTotemDelay = -1;

    @Inject(at = @At("TAIL"), method = "tick")
    private void onTick(CallbackInfo ci) {
        // timer
        if (Logic.overlayactive){
            if (overlaytickleft <= 0 || (Logic.totemOnOffhand() && 5<=ModConfig.get().totemPopScreenDuration*20-overlaytickleft)){
                Logic.overlayactive = false;
            } else {
                overlaytickleft--;
            }
        }

        if (ModConfig.get().totemCountTime<0){
            Logic.totemCountActive = true;
            Logic.totemCountValue = Logic.getTotemCount();
        } else if (Logic.totemCountActive){
            if (counttickleft <= 0){
                Logic.totemCountActive = false;
            } else {
                counttickleft--;
            }
        }

        // auto totem trigger
        if (autoTotemDelay == 0 && ModConfig.get().autoTotem) {
            Logic.refillTotem();
        }
        if (autoTotemDelay>=0){
            autoTotemDelay--;
        }

    }

    @Inject(at = @At("TAIL"), method = "showFloatingItem")
    private void onTotemUse(class_1799 floatingItem, CallbackInfo ci) {
        if (!floatingItem.method_31574(class_1802.field_8288))
            return;

        class_757 gameRenderer = (class_757) ((Object) this);
        class_310 client = gameRenderer.method_35772();

        class_1657 player = client.field_1724;
        if (player == null)
            return;

        // auto totem
        if (ModConfig.get().autoTotem) {
            autoTotemDelay = ModConfig.get().autoTotemDelay;
        } else {
            Chat.send("§cPopped!", true);
        }

        // custom sound
        if (ModConfig.get().customSound) {
            Logic.stopTotemSound();
            Logic.playCustomSound();
        }

        // screen overlay
        if (ModConfig.get().totemPopScreen) {
            overlaytickleft = ModConfig.get().totemPopScreenDuration*20;
            Logic.overlayactive = true;
        }

        // totem count
        if (ModConfig.get().totemCountTime>0){
            Logic.totemCountActive = true;
            counttickleft = ModConfig.get().totemCountTime * 20;
        }
    }
}