package CCPCT.TotemUtils.client;

import static CCPCT.TotemUtils.config.ModConfig.load;
import net.fabricmc.api.ClientModInitializer;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;

import CCPCT.TotemUtils.util.*;
import CCPCT.TotemUtils.config.configScreen;

public class TotemUtilsClient implements ClientModInitializer {
    public static class_304 swapTotemKey;
    public static class_304 configScreenKey;
    public static boolean checkedUpdate = false;
    @Override
    public void onInitializeClient() {

        load();
        // Register the keybinding
        swapTotemKey = KeyBindingHelper.registerKeyBinding(new class_304(
                "Swap Totem", // translation key
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_R,       // default key
                "Totem Utils"       // category in controls menu
        ));

        configScreenKey = KeyBindingHelper.registerKeyBinding(new class_304(
                "Config screen", // translation key
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_H,       // default key
                "Totem Utils"       // category in controls menu
        ));

        // Register client tick listener
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (swapTotemKey.method_1434()) {
                // swap totem
                Logic.refillTotem();
            }

            if (configScreenKey.method_1436()) {
                // open config
                class_310.method_1551().method_1507(configScreen.getConfigScreen(class_310.method_1551().field_1755));
            }
        });

        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            if (checkedUpdate) return;
            checkedUpdate = true;
            String[] mcVersion = FabricLoader.getInstance()
                    .getModContainer("totemutils").get()
                    .getMetadata().getVersion().getFriendlyString()
                    .split("-");
            String newestVersion = VersionChecker.getNewestVersion(mcVersion[1]);

            if (newestVersion == null){
                Chat.colour("Failed to check for updates.", "red");
                return;
            }

            if (VersionChecker.compareVersions(newestVersion, mcVersion[0]) > 0) {
                Chat.send("A new version of §6Totem Utils§r is available: " + newestVersion + " for " + mcVersion[1]);
                Chat.send("Links to download:");
                Chat.link("[Github]", "https://github.com/CCPCT/Totem-Utils/releases");
                Chat.link("[Modrinth]", "https://modrinth.com/mod/totemutils");
            } else {
                Chat.send("§6Totem Utils§r is up to date");
            }
        });
    }
}

