/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.genesis.block.custom.cauldron;

import com.mojang.serialization.Codec;
import dev.mariany.genesis.block.GenesisBlocks;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7871;
import net.minecraft.class_7923;

public interface PrimitiveCauldronBehavior {
    public static final Map<String, PrimitiveCauldronBehaviorMap> BEHAVIOR_MAPS = new Object2ObjectArrayMap();
    public static final Codec<PrimitiveCauldronBehaviorMap> CODEC = Codec.stringResolver(PrimitiveCauldronBehaviorMap::name, BEHAVIOR_MAPS::get);
    public static final PrimitiveCauldronBehaviorMap EMPTY_CAULDRON_BEHAVIOR = PrimitiveCauldronBehavior.createMap("empty");

    public static PrimitiveCauldronBehaviorMap createMap(String name) {
        ArrayList<PrimitiveCauldronBehaviorEntry> entries = new ArrayList<PrimitiveCauldronBehaviorEntry>();
        PrimitiveCauldronBehaviorMap primitiveCauldronBehaviorMap = new PrimitiveCauldronBehaviorMap(name, entries);
        BEHAVIOR_MAPS.put(name, primitiveCauldronBehaviorMap);
        return primitiveCauldronBehaviorMap;
    }

    public class_1269 interact(class_2680 var1, class_1937 var2, class_2338 var3, class_1657 var4, class_1268 var5, class_1799 var6);

    public static void registerBehavior() {
        class_7871 registryEntryLookup = class_7923.method_62715((class_2378)class_7923.field_41178);
        class_6885.class_6888 dirtItems = registryEntryLookup.method_46735(class_3489.field_36269);
        class_6885.class_6888 gravelItems = registryEntryLookup.method_46735(ConventionalItemTags.GRAVELS);
        EMPTY_CAULDRON_BEHAVIOR.entries().add(new PrimitiveCauldronBehaviorEntry(class_1856.method_8106((class_6885)dirtItems), PrimitiveCauldronBehavior::tryFillWithDirt));
        EMPTY_CAULDRON_BEHAVIOR.entries().add(new PrimitiveCauldronBehaviorEntry(class_1856.method_8106((class_6885)gravelItems), PrimitiveCauldronBehavior::tryFillWithGravel));
        EMPTY_CAULDRON_BEHAVIOR.entries().add(new PrimitiveCauldronBehaviorEntry(class_1856.method_8101((class_1935)class_2246.field_10114), PrimitiveCauldronBehavior::tryFillWithSoulSand));
        EMPTY_CAULDRON_BEHAVIOR.entries().add(new PrimitiveCauldronBehaviorEntry(class_1856.method_8101((class_1935)class_2246.field_22090), PrimitiveCauldronBehavior::tryFillWithSoulSoil));
    }

    public static class_1269 fillCauldron(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack, class_2680 state, class_3414 soundEvent) {
        if (!world.method_8608()) {
            stack.method_57008(1, (class_1309)player);
            player.method_7281(class_3468.field_15430);
            player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            world.method_8501(pos, state);
            world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            world.method_33596(null, (class_6880)class_5712.field_28733, pos);
        }
        return class_1269.field_5812;
    }

    private static class_1269 tryFillWithDirt(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack) {
        return PrimitiveCauldronBehavior.fillCauldron(world, pos, player, hand, stack, GenesisBlocks.DIRT_TERRACOTTA_CAULDRON.method_9564(), class_3417.field_14609);
    }

    private static class_1269 tryFillWithGravel(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack) {
        return PrimitiveCauldronBehavior.fillCauldron(world, pos, player, hand, stack, GenesisBlocks.GRAVEL_TERRACOTTA_CAULDRON.method_9564(), class_3417.field_14609);
    }

    private static class_1269 tryFillWithSoulSand(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack) {
        return PrimitiveCauldronBehavior.fillCauldron(world, pos, player, hand, stack, GenesisBlocks.SOUL_SAND_TERRACOTTA_CAULDRON.method_9564(), class_3417.field_21951);
    }

    private static class_1269 tryFillWithSoulSoil(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack) {
        return PrimitiveCauldronBehavior.fillCauldron(world, pos, player, hand, stack, GenesisBlocks.SOUL_SOIL_TERRACOTTA_CAULDRON.method_9564(), class_3417.field_21946);
    }

    public record PrimitiveCauldronBehaviorMap(String name, List<PrimitiveCauldronBehaviorEntry> entries) {
    }

    public record PrimitiveCauldronBehaviorEntry(class_1856 ingredient, PrimitiveCauldronBehavior behavior) {
    }
}

