/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.genesis.block.entity.custom;

import dev.mariany.genesis.Genesis;
import dev.mariany.genesis.advancement.criterion.GenesisCriteria;
import dev.mariany.genesis.block.custom.cauldron.FilledPrimitiveCauldronBlock;
import dev.mariany.genesis.block.entity.GenesisBlockEntities;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_8162;
import net.minecraft.class_8170;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class FilledPrimitiveCauldronBlockEntity
extends class_2586 {
    private static final String BRUSHES_NBT_KEY = "brushes";
    private static final int BRUSH_DELAY = 1;
    private static final int MAX_BRUSHES = 10;
    private int brushesCount;
    private long nextBrushTime;
    private class_1799 item = class_1799.field_8037;
    @Nullable
    private final class_5321<class_52> lootTable;

    public FilledPrimitiveCauldronBlockEntity(class_2338 pos, class_2680 state) {
        this(pos, state, FilledPrimitiveCauldronBlockEntity.getLootTableFromState(state));
    }

    public FilledPrimitiveCauldronBlockEntity(class_2338 pos, class_2680 state, @Nullable class_5321<class_52> lootTable) {
        super(GenesisBlockEntities.FILLED_PRIMITIVE_CAULDRON, pos, state);
        this.lootTable = lootTable;
    }

    private static class_5321<class_52> getLootTableFromState(class_2680 state) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof FilledPrimitiveCauldronBlock) {
            FilledPrimitiveCauldronBlock filledPrimitiveCauldronBlock = (FilledPrimitiveCauldronBlock)class_22482;
            return filledPrimitiveCauldronBlock.getLootTable();
        }
        return null;
    }

    public boolean brush(class_3218 world, class_1309 brusher, class_1799 brush) {
        return this.brush(world, brusher, brush, false);
    }

    public boolean brush(class_3218 world, class_1309 brusher, class_1799 brush, boolean sound) {
        boolean finished;
        long worldTime = world.method_8510();
        if (worldTime < this.nextBrushTime) {
            return false;
        }
        class_2680 currentState = this.method_11010();
        class_2248 class_22482 = currentState.method_26204();
        if (class_22482 instanceof FilledPrimitiveCauldronBlock) {
            FilledPrimitiveCauldronBlock filledPrimitiveCauldronBlock = (FilledPrimitiveCauldronBlock)class_22482;
            class_2680 particleBlockState = filledPrimitiveCauldronBlock.getParticleBlock().method_9564();
            this.addBlockBreakParticles(world, this.field_11867, particleBlockState);
        }
        int delay = brush.method_7909() instanceof class_8162 ? 1 : 10;
        this.nextBrushTime = worldTime + (long)delay;
        int previousDustedLevel = this.getDustedLevel();
        boolean bl = finished = ++this.brushesCount >= 10;
        if (finished || sound) {
            this.playSound(finished);
        }
        if (finished) {
            this.finishBrushing(world, brusher, brush);
            return true;
        }
        class_2338 pos = this.method_11016();
        int currentDustedLevel = this.getDustedLevel();
        if (previousDustedLevel != currentDustedLevel) {
            class_2680 updatedState = (class_2680)currentState.method_11657((class_2769)class_2741.field_42836, (Comparable)Integer.valueOf(currentDustedLevel));
            world.method_8652(pos, updatedState, 3);
        }
        return false;
    }

    private void playSound(boolean finished) {
        class_2248 block = this.method_11010().method_26204();
        if (this.field_11863 != null && block instanceof FilledPrimitiveCauldronBlock) {
            FilledPrimitiveCauldronBlock filledPrimitiveCauldronBlock = (FilledPrimitiveCauldronBlock)block;
            class_3414 soundEvent = finished ? filledPrimitiveCauldronBlock.method_49812() : filledPrimitiveCauldronBlock.method_49811();
            this.field_11863.method_45447(null, this.field_11867, soundEvent, class_3419.field_15245);
        }
    }

    private void generateItem(class_3218 world, class_1309 brusher, class_1799 brush) {
        if (this.lootTable != null) {
            class_52 lootTable = world.method_8503().method_58576().method_58295(this.lootTable);
            if (brusher instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)brusher;
                class_174.field_24479.method_27993(serverPlayerEntity, this.lootTable);
            }
            class_8567 lootWorldContext = new class_8567.class_8568(world).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)this.field_11867)).method_51871(brusher.method_7292()).method_51874(class_181.field_1226, (Object)brusher).method_51874(class_181.field_1229, (Object)brush).method_51875(class_173.field_42858);
            ObjectArrayList loot = lootTable.method_51879(lootWorldContext, brusher.method_59922().method_43055());
            this.item = switch (loot.size()) {
                case 0 -> class_1799.field_8037;
                case 1 -> (class_1799)loot.getFirst();
                default -> {
                    Genesis.LOGGER.warn("Expected max 1 loot from loot table {}, but got {}", (Object)this.lootTable.method_29177(), (Object)loot.size());
                    yield (class_1799)loot.getFirst();
                }
            };
            this.method_5431();
        }
    }

    private void finishBrushing(class_3218 world, class_1309 brusher, class_1799 brush) {
        class_2248 baseBlock = class_2246.field_10124;
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof class_8170) {
            class_8170 brushableBlock = (class_8170)class_22482;
            baseBlock = brushableBlock.method_49810();
            if (brushableBlock instanceof FilledPrimitiveCauldronBlock) {
                FilledPrimitiveCauldronBlock filledPrimitiveCauldronBlock = (FilledPrimitiveCauldronBlock)brushableBlock;
                if (brusher instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)brusher;
                    GenesisCriteria.BRUSH_PRIMITIVE_CAULDRON.trigger(serverPlayer, (class_2248)filledPrimitiveCauldronBlock);
                }
            }
        }
        world.method_8652(this.field_11867, baseBlock.method_9564(), 3);
        this.spawnItem(world, brusher, brush);
    }

    private void spawnItem(class_3218 world, class_1309 brusher, class_1799 brush) {
        this.generateItem(world, brusher, brush);
        if (!this.item.method_7960()) {
            double itemEntityWidth = class_1299.field_6052.method_17685();
            double offsetFactor = 1.0 - itemEntityWidth;
            double halfEntityWidth = itemEntityWidth / 2.0;
            double spawnX = (double)this.field_11867.method_10263() + 0.5 * offsetFactor + halfEntityWidth;
            double spawnY = (double)this.field_11867.method_10264() + 0.5 + (double)(class_1299.field_6052.method_17686() / 2.0f);
            double spawnZ = (double)this.field_11867.method_10260() + 0.5 * offsetFactor + halfEntityWidth;
            int stackSize = world.field_9229.method_43048(21) + 10;
            class_1799 splitStack = this.item.method_7971(stackSize);
            class_1542 droppedItem = new class_1542((class_1937)world, spawnX, spawnY, spawnZ, splitStack);
            droppedItem.method_18799(class_243.field_1353);
            world.method_8649((class_1297)droppedItem);
            this.item = class_1799.field_8037;
        }
    }

    private void addBlockBreakParticles(class_3218 world, class_2338 pos, class_2680 state) {
        if (!state.method_26215() && state.method_45475()) {
            world.method_65096((class_2394)new class_2388(class_2398.field_11217, state), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.7, (double)pos.method_10260() + 0.5, 15, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 nbtCompound = super.method_16887(registries);
        nbtCompound.method_10569(BRUSHES_NBT_KEY, this.brushesCount);
        return nbtCompound;
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.brushesCount = view.method_71426(BRUSHES_NBT_KEY, class_5699.field_33441).orElse(0);
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71468(BRUSHES_NBT_KEY, class_5699.field_33441, (Object)this.brushesCount);
    }

    private int getDustedLevel() {
        if (this.brushesCount == 0) {
            return 0;
        }
        if (this.brushesCount < 3) {
            return 1;
        }
        return this.brushesCount < 6 ? 2 : 3;
    }

    public class_1799 getItem() {
        return this.item;
    }
}

