/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.genesis.block.entity.custom;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import dev.mariany.genesis.block.entity.GenesisBlockEntities;
import dev.mariany.genesis.screen.KilnScreenHandler;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1732;
import net.minecraft.class_1737;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_3922;
import net.minecraft.class_3956;
import net.minecraft.class_4770;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.minecraft.class_9875;
import org.jetbrains.annotations.Nullable;

public class KilnBlockEntity
extends class_2624
implements class_1732,
class_1737,
class_1278 {
    private static final Codec<Map<class_5321<class_1860<?>>, Integer>> CODEC = Codec.unboundedMap((Codec)class_1860.field_56667, (Codec)Codec.INT);
    private static final int DEFAULT_COOK_SECONDS = 45;
    private static final int DEFAULT_COOK_TICKS = 900;
    private final class_1863.class_7266<class_9696, ? extends class_1874> matchGetter;
    private final Reference2IntOpenHashMap<class_5321<class_1860<?>>> recipesUsed = new Reference2IntOpenHashMap();
    protected class_2371<class_1799> inventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    int cookingTimeSpent;
    int cookingTotalTime;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> KilnBlockEntity.this.cookingTimeSpent;
                case 1 -> KilnBlockEntity.this.cookingTotalTime;
                case 2 -> {
                    if (KilnBlockEntity.this.isLit()) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    KilnBlockEntity.this.cookingTimeSpent = value;
                    break;
                }
                case 1: {
                    KilnBlockEntity.this.cookingTotalTime = value;
                }
            }
        }

        public int method_17389() {
            return 3;
        }
    };

    public KilnBlockEntity(class_2338 pos, class_2680 state) {
        super(GenesisBlockEntities.KILN, pos, state);
        this.matchGetter = class_1863.method_42302((class_3956)class_3956.field_17546);
    }

    public int method_5439() {
        return this.inventory.size();
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.genesis.kiln");
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> inventory) {
        this.inventory = inventory;
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return new KilnScreenHandler(syncId, playerInventory, (class_1263)this, this.propertyDelegate);
    }

    public void method_5447(int slot, class_1799 stack) {
        class_1937 class_19372;
        class_1799 previousStack = (class_1799)this.inventory.get(slot);
        boolean isSameItemType = !stack.method_7960() && class_1799.method_31577((class_1799)previousStack, (class_1799)stack);
        this.inventory.set(slot, (Object)stack);
        stack.method_58408(this.method_58350(stack));
        if (slot == 0 && !isSameItemType && (class_19372 = this.field_11863) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.cookingTotalTime = KilnBlockEntity.getCookTime(serverWorld, this);
            this.cookingTimeSpent = 0;
            this.method_5431();
        }
    }

    public boolean method_5437(int slot, class_1799 stack) {
        return slot == 0;
    }

    public void method_7683(class_9875 finder) {
        for (class_1799 itemStack : this.inventory) {
            finder.method_61541(itemStack);
        }
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.getRecipesUsedAndDropExperience(serverWorld, class_243.method_24953((class_2382)pos));
        }
    }

    public void method_7662(@Nullable class_8786<?> recipe) {
        if (recipe != null) {
            class_5321 registryKey = recipe.comp_1932();
            this.recipesUsed.addTo((Object)registryKey, 1);
        }
    }

    @Nullable
    public class_8786<?> method_7663() {
        return null;
    }

    public void method_7664(class_1657 player, List<class_1799> ingredients) {
    }

    public void dropExperienceForRecipesUsed(class_3222 player) {
        List<class_8786<?>> usedRecipes = this.getRecipesUsedAndDropExperience(player.method_51469(), player.method_73189());
        player.method_7254(usedRecipes);
        for (class_8786<?> recipeEntry : usedRecipes) {
            if (recipeEntry == null) continue;
            player.method_51283(recipeEntry, this.inventory);
        }
        this.recipesUsed.clear();
    }

    private List<class_8786<?>> getRecipesUsedAndDropExperience(class_3218 world, class_243 pos) {
        ArrayList usedRecipes = Lists.newArrayList();
        for (Reference2IntMap.Entry recipeUsageEntry : this.recipesUsed.reference2IntEntrySet()) {
            world.method_64577().method_8130((class_5321)recipeUsageEntry.getKey()).ifPresent(recipe -> {
                usedRecipes.add(recipe);
                KilnBlockEntity.dropExperience(world, pos, recipeUsageEntry.getIntValue(), ((class_1874)recipe.comp_1933()).method_8171());
            });
        }
        return usedRecipes;
    }

    private static void dropExperience(class_3218 world, class_243 pos, int multiplier, float baseExperience) {
        float totalExperience = (float)multiplier * baseExperience;
        int experienceToDrop = class_3532.method_15375((float)totalExperience);
        float fractionalPart = class_3532.method_22450((float)totalExperience);
        if (fractionalPart != 0.0f && Math.random() < (double)fractionalPart) {
            ++experienceToDrop;
        }
        class_1303.method_31493((class_3218)world, (class_243)pos, (int)experienceToDrop);
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_11368)view, this.inventory);
        this.cookingTimeSpent = view.method_71432("cooking_time_spent", (short)0);
        this.cookingTotalTime = view.method_71432("cooking_total_time", (short)0);
        this.recipesUsed.clear();
        this.recipesUsed.putAll(view.method_71426("RecipesUsed", CODEC).orElse(Map.of()));
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71471("cooking_time_spent", (short)this.cookingTimeSpent);
        view.method_71471("cooking_total_time", (short)this.cookingTotalTime);
        class_1262.method_5426((class_11372)view, this.inventory);
        view.method_71468("RecipesUsed", CODEC, this.recipesUsed);
    }

    public int[] method_5494(class_2350 side) {
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return false;
    }

    private boolean isLit() {
        if (this.field_11863 != null) {
            class_2680 belowState = this.field_11863.method_8320(this.field_11867.method_10074());
            class_2248 belowBlock = belowState.method_26204();
            if (belowBlock instanceof class_4770) {
                return true;
            }
            return belowBlock instanceof class_3922 && (Boolean)belowState.method_61767((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false)) != false;
        }
        return false;
    }

    public static void tick(class_3218 world, class_2338 pos, class_2680 state, KilnBlockEntity kiln) {
        boolean hasInput;
        boolean stateChanged = false;
        class_1799 inputStack = (class_1799)kiln.inventory.getFirst();
        boolean bl = hasInput = !inputStack.method_7960();
        if (kiln.isLit() && hasInput) {
            class_9696 recipeInput = new class_9696(inputStack);
            class_8786 recipeEntry = kiln.matchGetter.method_42303((class_9695)recipeInput, world).orElse(null);
            int maxStackSize = kiln.method_5444();
            if (KilnBlockEntity.canAcceptRecipeOutput(world.method_30349(), (class_8786<? extends class_1874>)recipeEntry, recipeInput, kiln.inventory, maxStackSize)) {
                ++kiln.cookingTimeSpent;
                if (kiln.cookingTimeSpent >= kiln.cookingTotalTime) {
                    kiln.cookingTimeSpent = 0;
                    kiln.cookingTotalTime = KilnBlockEntity.getCookTime(world, kiln);
                    if (KilnBlockEntity.craftRecipe(world.method_30349(), (class_8786<? extends class_1874>)recipeEntry, recipeInput, kiln.inventory, maxStackSize)) {
                        kiln.method_7662(recipeEntry);
                    }
                    stateChanged = true;
                }
            } else {
                kiln.cookingTimeSpent = 0;
            }
        } else if (kiln.cookingTimeSpent > 0) {
            kiln.cookingTimeSpent = class_3532.method_15340((int)(kiln.cookingTimeSpent - 2), (int)0, (int)kiln.cookingTotalTime);
        }
        if (stateChanged) {
            KilnBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    private static boolean canAcceptRecipeOutput(class_5455 dynamicRegistryManager, @Nullable class_8786<? extends class_1874> recipe, class_9696 input, class_2371<class_1799> inventory, int maxCount) {
        class_1799 inputStack = (class_1799)inventory.get(0);
        if (!inputStack.method_7960() && recipe != null) {
            class_1799 itemStack = ((class_1874)recipe.comp_1933()).method_59998(input, (class_7225.class_7874)dynamicRegistryManager);
            if (itemStack.method_7960()) {
                return false;
            }
            class_1799 outputStack = (class_1799)inventory.get(1);
            if (outputStack.method_7960()) {
                return true;
            }
            if (!class_1799.method_31577((class_1799)outputStack, (class_1799)itemStack)) {
                return false;
            }
            return outputStack.method_7947() < maxCount && outputStack.method_7947() < outputStack.method_7914() || outputStack.method_7947() < itemStack.method_7914();
        }
        return false;
    }

    private static boolean craftRecipe(class_5455 dynamicRegistryManager, @Nullable class_8786<? extends class_1874> recipe, class_9696 input, class_2371<class_1799> inventory, int maxCount) {
        if (recipe != null && KilnBlockEntity.canAcceptRecipeOutput(dynamicRegistryManager, recipe, input, inventory, maxCount)) {
            class_1799 inputStack = (class_1799)inventory.get(0);
            class_1799 smeltToStack = ((class_1874)recipe.comp_1933()).method_59998(input, (class_7225.class_7874)dynamicRegistryManager);
            class_1799 outputStack = (class_1799)inventory.get(1);
            if (outputStack.method_7960()) {
                inventory.set(1, (Object)smeltToStack.method_7972());
            } else if (class_1799.method_31577((class_1799)outputStack, (class_1799)smeltToStack)) {
                outputStack.method_7933(1);
            }
            inputStack.method_7934(1);
            return true;
        }
        return false;
    }

    private static int getCookTime(class_3218 world, KilnBlockEntity kiln) {
        class_9696 singleStackRecipeInput = new class_9696(kiln.method_5438(0));
        int cookTime = kiln.matchGetter.method_42303((class_9695)singleStackRecipeInput, world).map(recipe -> ((class_1874)recipe.comp_1933()).method_8167()).orElse(900);
        return Math.max(cookTime, 900);
    }
}

