/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.genesis.client.gui.screen.ingame;

import dev.mariany.genesis.Genesis;
import dev.mariany.genesis.client.gui.screen.recipebook.AssemblyRecipeBookWidget;
import dev.mariany.genesis.client.gui.widget.ToggleableRecipeBookWidget;
import dev.mariany.genesis.item.custom.AssemblyPatternItem;
import dev.mariany.genesis.mixin.accessor.RecipeBookWidgetAccessor;
import dev.mariany.genesis.mixin.accessor.ScreenAccessor;
import dev.mariany.genesis.screen.AssemblyScreenHandler;
import dev.mariany.genesis.screen.slot.AssemblyInputSlot;
import dev.mariany.genesis.screen.slot.AssemblyPatternSlot;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10260;
import net.minecraft.class_10799;
import net.minecraft.class_1661;
import net.minecraft.class_1729;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_507;
import net.minecraft.class_5348;
import net.minecraft.class_8029;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class AssemblyScreen
extends class_10260<AssemblyScreenHandler> {
    private static final class_2960 TEXTURE = Genesis.id("textures/gui/container/assembly_table.png");
    private static final class_2960 SLOT_TEXTURE = Genesis.id("container/assembly/slots");
    private static final class_2960 DISABLED_SLOT_TEXTURE = Genesis.id("container/assembly/locked_slots");
    private static final class_2561 CAST_SLOT_TOOLTIP = class_2561.method_43471((String)"container.genesis.assembly_table.cast_tooltip");
    private static final int SLOTS_PER_ROW = 3;
    private static final int SLOTS_TEXTURE_SIZE = 54;
    private static final int SLOT_SIZE = 18;
    private final AssemblyRecipeBookWidget assemblyRecipeBookWidget;
    @Nullable
    private class_1792 previousPattern = class_1802.field_8162;

    public AssemblyScreen(AssemblyScreenHandler handler, class_1661 inventory, class_2561 title) {
        this(new AssemblyRecipeBookWidget(handler), handler, inventory, title);
    }

    private AssemblyScreen(AssemblyRecipeBookWidget assemblyRecipeBookWidget, AssemblyScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1729)handler, (class_507)assemblyRecipeBookWidget, inventory, title);
        this.assemblyRecipeBookWidget = assemblyRecipeBookWidget;
    }

    protected void method_25426() {
        super.method_25426();
        this.field_25267 = 29;
        this.previousPattern = class_1802.field_8162;
        ((AssemblyScreenHandler)this.field_2797).onAssemblyPatternChange(inventory -> this.updateRecipeBookState());
        this.updateRecipeBookState();
    }

    private void updateRecipeBookState() {
        this.getRecipeBook().ifPresent(toggleableRecipeBookWidget -> {
            Optional<AssemblyPatternItem> optionalAssemblyPatternItem = ((AssemblyScreenHandler)this.field_2797).getAssemblyPatternItem();
            boolean enabled = optionalAssemblyPatternItem.isPresent();
            toggleableRecipeBookWidget.setEnabled(enabled);
            class_1792 pattern = optionalAssemblyPatternItem.map(class_1792::method_8389).orElse(class_1802.field_8162);
            if (pattern != this.previousPattern) {
                ((RecipeBookWidgetAccessor)((Object)this.assemblyRecipeBookWidget)).genesis$ghostRecipe().method_62029();
                this.previousPattern = pattern;
            }
            if (!enabled && this.assemblyRecipeBookWidget.method_2605()) {
                this.assemblyRecipeBookWidget.close();
                this.field_2776 = this.assemblyRecipeBookWidget.method_2595(this.field_22789, this.field_2792);
                class_8029 buttonPos = this.method_64509();
                toggleableRecipeBookWidget.method_48229(buttonPos.comp_1193(), buttonPos.comp_1194());
                this.method_64510();
            }
        });
    }

    private Optional<ToggleableRecipeBookWidget> getRecipeBook() {
        for (class_4068 drawable : ((ScreenAccessor)((Object)this)).genesis$drawables()) {
            if (!(drawable instanceof ToggleableRecipeBookWidget)) continue;
            ToggleableRecipeBookWidget toggleableRecipeBookWidget = (ToggleableRecipeBookWidget)drawable;
            return Optional.of(toggleableRecipeBookWidget);
        }
        return Optional.empty();
    }

    protected class_8029 method_64509() {
        return new class_8029(this.field_2776 + 5, this.field_22790 / 2 - 49);
    }

    protected void method_2389(class_332 context, float deltaTicks, int mouseX, int mouseY) {
        int y = (this.field_22790 - this.field_2779) / 2;
        context.method_25290(class_10799.field_56883, TEXTURE, this.field_2776, y, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        super.method_25394(context, mouseX, mouseY, deltaTicks);
        this.renderSlotTooltip(context, mouseX, mouseY);
    }

    private void renderSlotTooltip(class_332 context, int mouseX, int mouseY) {
        AssemblyPatternSlot assemblyPatternSlot;
        class_1735 class_17352 = this.field_2787;
        if (class_17352 instanceof AssemblyPatternSlot && (assemblyPatternSlot = (AssemblyPatternSlot)class_17352).isEmpty()) {
            context.method_51447(this.field_22793, this.field_22793.method_1728((class_5348)CAST_SLOT_TOOLTIP, 115), mouseX, mouseY);
        }
    }

    public void method_2385(class_332 context, class_1735 slot) {
        boolean shouldDraw = true;
        if (slot instanceof AssemblyInputSlot) {
            AssemblyInputSlot assemblyInputSlot = (AssemblyInputSlot)slot;
            boolean canInsert = assemblyInputSlot.canInsert();
            if (((AssemblyScreenHandler)this.field_2797).getAssemblyPatternItem().isPresent()) {
                this.drawBackground(context, assemblyInputSlot, canInsert);
            }
            if (!canInsert) {
                shouldDraw = false;
            }
        }
        if (shouldDraw) {
            super.method_2385(context, slot);
        }
    }

    private void drawBackground(class_332 context, AssemblyInputSlot slot, boolean enabled) {
        class_2960 texture = enabled ? SLOT_TEXTURE : DISABLED_SLOT_TEXTURE;
        int index = slot.method_34266();
        int u = index % 3 * 18;
        int v = index / 3 * 18;
        context.method_70846(class_10799.field_56883, texture, 54, 54, u, v, slot.field_7873 - 1, slot.field_7872 - 1, 18, 18);
    }
}

