/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.genesis.compat.rei.client.categories.crafting;

import com.google.common.collect.HashMultiset;
import dev.mariany.genesis.block.GenesisBlocks;
import dev.mariany.genesis.compat.rei.REICategoryIdentifiers;
import dev.mariany.genesis.compat.rei.display.AssemblyDisplay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.DisplayMerger;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class AssemblyCategory
implements DisplayCategory<AssemblyDisplay> {
    public CategoryIdentifier<? extends AssemblyDisplay> getCategoryIdentifier() {
        return REICategoryIdentifiers.ASSEMBLY;
    }

    public Renderer getIcon() {
        return EntryStacks.of((class_1935)GenesisBlocks.ASSEMBLY_TABLE);
    }

    public class_2561 getTitle() {
        return class_2561.method_43471((String)"category.rei.genesis.assembly");
    }

    public int getDisplayWidth(AssemblyDisplay display) {
        return 175;
    }

    public List<Widget> setupDisplay(AssemblyDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add((Widget)Widgets.createArrow((Point)new Point(bounds.x + 102, bounds.y + 24)));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(bounds.x + 137, bounds.y + 25)));
        widgets.add((Widget)this.createPatternSlot(display, bounds));
        widgets.addAll(this.addInputSlots(display, bounds));
        widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.x + 137, bounds.y + 25)).entries((Collection)display.getOutputEntries().getFirst()).disableBackground().markOutput());
        return widgets;
    }

    private Slot createPatternSlot(AssemblyDisplay display, Rectangle bounds) {
        Slot patternSlot = Widgets.createSlot((Point)new Point(bounds.x + 18, bounds.y + 25)).markInput();
        patternSlot.entries((Collection)display.getPatterns());
        return patternSlot;
    }

    private List<Slot> addInputSlots(AssemblyDisplay display, Rectangle bounds) {
        List<InputIngredient<EntryStack<?>>> ingredients = display.getInputIngredients(3, 3);
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int slotX = bounds.x + 43 + x * 18;
                int slotY = bounds.y + 7 + y * 18;
                slots.add(Widgets.createSlot((Point)new Point(slotX, slotY)).markInput());
            }
        }
        for (InputIngredient<EntryStack<?>> ingredient : ingredients) {
            ((Slot)slots.get(ingredient.getIndex())).entries((Collection)ingredient.get());
        }
        return slots;
    }

    @Nullable
    public DisplayMerger<AssemblyDisplay> getDisplayMerger() {
        return new DisplayMerger<AssemblyDisplay>(this){

            public boolean canMerge(AssemblyDisplay displayA, AssemblyDisplay displayB) {
                List<EntryIngredient> displayBInputs;
                if (displayA.getWidth() != displayB.getWidth()) {
                    return false;
                }
                if (displayA.getHeight() != displayB.getHeight()) {
                    return false;
                }
                if (!displayA.getCategoryIdentifier().equals(displayB.getCategoryIdentifier())) {
                    return false;
                }
                List<EntryIngredient> displayAInputs = displayA.getOrganisedInputEntries(3, 3);
                if (!this.equals(displayAInputs, displayBInputs = displayB.getOrganisedInputEntries(3, 3))) {
                    return false;
                }
                return this.equals(displayA.getOutputEntries(), displayB.getOutputEntries());
            }

            public int hashOf(AssemblyDisplay display) {
                return Objects.hash(display.getCategoryIdentifier(), display.getOrganisedInputEntries(3, 3), display.getOutputEntries());
            }

            private <T> boolean equals(List<T> inputsA, List<T> inputsB) {
                HashMultiset multisetA = HashMultiset.create(inputsA);
                HashMultiset multisetB = HashMultiset.create(inputsB);
                return multisetA.equals((Object)multisetB);
            }
        };
    }
}

