/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.genesis.compat.rei.display;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.mariany.genesis.compat.rei.REICategoryIdentifiers;
import dev.mariany.genesis.recipe.AssemblyRecipe;
import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.displays.crafting.CraftingDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class AssemblyDisplay
extends BasicDisplay
implements CraftingDisplay {
    public static final DisplaySerializer<AssemblyDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(AssemblyDisplay::getInputEntriesWithoutPattern), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BasicDisplay::getOutputEntries), (App)class_2960.field_25139.optionalFieldOf("location").forGetter(BasicDisplay::getDisplayLocation), (App)EntryIngredient.codec().fieldOf("patterns").forGetter(AssemblyDisplay::getPatterns), (App)Codec.INT.fieldOf("width").forGetter(AssemblyDisplay::getWidth), (App)Codec.INT.fieldOf("height").forGetter(AssemblyDisplay::getHeight)).apply((Applicative)instance, AssemblyDisplay::new)), (class_9139)class_9139.method_58025((class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), AssemblyDisplay::getInputEntriesWithoutPattern, (class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), BasicDisplay::getOutputEntries, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), BasicDisplay::getDisplayLocation, (class_9139)EntryIngredient.streamCodec(), AssemblyDisplay::getPatterns, (class_9139)class_9135.field_49675, AssemblyDisplay::getWidth, (class_9139)class_9135.field_49675, AssemblyDisplay::getHeight, AssemblyDisplay::new));
    protected EntryIngredient patterns;
    private final int width;
    private final int height;

    public AssemblyDisplay(class_8786<AssemblyRecipe> recipe) {
        this(CollectionUtils.map((Collection)((AssemblyRecipe)recipe.comp_1933()).method_61693(), opt -> opt.map(EntryIngredients::ofIngredient).orElse(EntryIngredient.empty())), List.of(EntryIngredients.of((class_1799)((AssemblyRecipe)recipe.comp_1933()).craft())), Optional.of(recipe.comp_1932().method_29177()), EntryIngredients.ofItems(((AssemblyRecipe)recipe.comp_1933()).getPatterns().stream().map(assemblyPatternItem -> assemblyPatternItem).toList()), ((AssemblyRecipe)recipe.comp_1933()).method_8150(), ((AssemblyRecipe)recipe.comp_1933()).method_8158());
    }

    public AssemblyDisplay(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_2960> location, EntryIngredient patterns, int width, int height) {
        super(inputs, outputs, location);
        this.patterns = patterns;
        this.width = width;
        this.height = height;
    }

    public EntryIngredient getPatterns() {
        return this.patterns;
    }

    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return REICategoryIdentifiers.ASSEMBLY;
    }

    public boolean isShapeless() {
        return false;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public List<EntryIngredient> getInputEntries() {
        ArrayList<EntryIngredient> inputs = new ArrayList<EntryIngredient>(this.inputs);
        inputs.add(this.patterns);
        return inputs;
    }

    public List<EntryIngredient> getInputEntriesWithoutPattern() {
        return this.inputs;
    }

    public List<InputIngredient<EntryStack<?>>> getInputIngredients(int craftingWidth, int craftingHeight) {
        int inputWidth = this.getInputWidth(craftingWidth, craftingHeight);
        HashMap<IntIntImmutablePair, InputIngredient> grid = new HashMap<IntIntImmutablePair, InputIngredient>();
        for (int i = 0; i < this.inputs.size(); ++i) {
            EntryIngredient stacks = (EntryIngredient)this.inputs.get(i);
            if (stacks.isEmpty()) continue;
            int index = CraftingDisplay.getSlotWithSize((int)inputWidth, (int)i, (int)craftingWidth);
            int x = i % inputWidth;
            int y = i / inputWidth;
            grid.put(new IntIntImmutablePair(x, y), InputIngredient.of((int)index, (int)(3 * y + x), (List)stacks));
        }
        ArrayList ingredients = new ArrayList(craftingWidth * craftingHeight);
        int n = craftingWidth * craftingHeight;
        for (int i = 0; i < n; ++i) {
            ingredients.add(InputIngredient.empty((int)i));
        }
        for (int x = 0; x < craftingWidth; ++x) {
            for (int y = 0; y < craftingHeight; ++y) {
                InputIngredient ingredient = (InputIngredient)grid.get(new IntIntImmutablePair(x, y));
                if (ingredient == null) continue;
                int index = craftingWidth * y + x;
                ingredients.set(index, ingredient);
            }
        }
        return ingredients;
    }

    public List<EntryIngredient> getOrganisedInputEntries(int menuWidth, int menuHeight) {
        int i;
        ArrayList<EntryIngredient> entries = new ArrayList<EntryIngredient>(menuWidth * menuHeight + 1);
        for (i = 0; i < menuWidth * menuHeight; ++i) {
            entries.add(EntryIngredient.empty());
        }
        for (i = 0; i < this.inputs.size(); ++i) {
            entries.set(CraftingDisplay.getSlotWithSize((CraftingDisplay)this, (int)i, (int)menuWidth), (EntryIngredient)this.inputs.get(i));
        }
        entries.set(entries.size() - 1, this.patterns);
        return entries;
    }
}

