/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.genesis.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.mariany.genesis.Genesis;
import dev.mariany.genesis.config.GenesisConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigHandler {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/genesis.json5");
    private static GenesisConfig config = new GenesisConfig();

    public static GenesisConfig getConfig() {
        return config;
    }

    public static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                config = (GenesisConfig)GSON.fromJson((Reader)reader, GenesisConfig.class);
            }
            catch (IOException error) {
                Genesis.LOGGER.error("Failed to load config: {}", (Object)error.getMessage());
            }
        }
        ConfigHandler.saveConfig();
    }

    private static void saveConfig() {
        try {
            if (CONFIG_FILE.getParentFile().mkdirs()) {
                Genesis.LOGGER.info("Creating parent directory for {} config", (Object)"genesis");
            }
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)config, (Appendable)writer);
            }
        }
        catch (IOException error) {
            Genesis.LOGGER.error("Failed to save config: {}", (Object)error.getMessage());
        }
    }
}

