/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.genesis.datagen;

import dev.mariany.genesis.Genesis;
import dev.mariany.genesis.advancement.criterion.GenesisCriteria;
import dev.mariany.genesis.advancement.criterion.ItemBrokenCriterion;
import dev.mariany.genesis.block.GenesisBlocks;
import dev.mariany.genesis.item.GenesisItems;
import dev.mariany.genesis.tag.GenesisTags;
import dev.mariany.genesisframework.age.Age;
import dev.mariany.genesisframework.age.AgeEntry;
import dev.mariany.genesisframework.datagen.AgeProvider;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1299;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2030;
import net.minecraft.class_2048;
import net.minecraft.class_2080;
import net.minecraft.class_2135;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3542;
import net.minecraft.class_39;
import net.minecraft.class_5282;
import net.minecraft.class_5321;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8782;

public class GenesisAgeProvider
extends AgeProvider {
    private static final class_2960 ARMOR_LEATHER = GenesisAgeProvider.of(AgeCategory.ARMOR, "leather");
    private static final class_2960 ARMOR_COPPER = GenesisAgeProvider.of(AgeCategory.ARMOR, "copper");
    private static final class_2960 ARMOR_IRON = GenesisAgeProvider.of(AgeCategory.ARMOR, "iron");
    private static final class_2960 ARMOR_DIAMOND = GenesisAgeProvider.of(AgeCategory.ARMOR, "diamond");
    private static final class_2960 ARMOR_NETHERITE = GenesisAgeProvider.of(AgeCategory.ARMOR, "netherite");
    private static final class_2960 TOOLS_WOOD = GenesisAgeProvider.of(AgeCategory.TOOLS, "wood");
    private static final class_2960 TOOLS_STONE = GenesisAgeProvider.of(AgeCategory.TOOLS, "stone");
    private static final class_2960 TOOLS_COPPER = GenesisAgeProvider.of(AgeCategory.TOOLS, "copper");
    private static final class_2960 TOOLS_IRON = GenesisAgeProvider.of(AgeCategory.TOOLS, "iron");
    private static final class_2960 TOOLS_DIAMOND = GenesisAgeProvider.of(AgeCategory.TOOLS, "diamond");
    private static final class_2960 TOOLS_NETHERITE = GenesisAgeProvider.of(AgeCategory.TOOLS, "netherite");
    private static final class_2960 BLOCKS_CLAY = GenesisAgeProvider.of(AgeCategory.BLOCKS, "clay");
    private static final class_2960 BLOCKS_FURNACE = GenesisAgeProvider.of(AgeCategory.BLOCKS, "furnace");
    private static final class_2960 BLOCKS_BED = GenesisAgeProvider.of(AgeCategory.BLOCKS, "bed");
    private static final class_2960 STORY_SURVIVAL = GenesisAgeProvider.of(AgeCategory.STORY, "survival");
    private static final class_2960 STORY_GARDEN = GenesisAgeProvider.of(AgeCategory.STORY, "garden");
    private static final class_2960 STORY_NETHER = GenesisAgeProvider.of(AgeCategory.STORY, "nether");
    private static final class_2960 STORY_OCEAN = GenesisAgeProvider.of(AgeCategory.STORY, "ocean");
    private static final class_2960 STORY_SCULK = GenesisAgeProvider.of(AgeCategory.STORY, "sculk");
    private static final class_2960 STORY_WITHER = GenesisAgeProvider.of(AgeCategory.STORY, "wither");
    private static final class_2960 STORY_END = GenesisAgeProvider.of(AgeCategory.STORY, "end");
    private static final String LOOT_ANCIENT_CITY_REQUIREMENT = "loot_ancient_city";
    private static final String LOOT_ANCIENT_CITY_ICE_BOX_REQUIREMENT = "loot_ancient_city_ice_box";
    private static final List<String> ANCIENT_CITY_REQUIREMENTS = List.of("loot_ancient_city", "loot_ancient_city_ice_box");
    private static final int TICKS_PER_SECOND = 20;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_DAY = 20;
    private static final int TICKS_PER_DAY = 24000;
    private static final int BED_AGE_SURVIVE_DAYS = 5;
    private static final int BED_AGE_SURVIVE_TICKS = 120000;

    private static class_2960 of(AgeCategory category, String key) {
        return Genesis.id(category.method_15434() + "/" + key);
    }

    public GenesisAgeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(output, registryLookup);
    }

    public void generateAges(class_7225.class_7874 registries, Consumer<AgeEntry> consumer) {
        class_7225.class_7226 itemLookup = registries.method_46762(class_7924.field_41197);
        class_7225.class_7226 entityLookup = registries.method_46762(class_7924.field_41266);
        this.generateArmorAges((class_7225.class_7226<class_1792>)itemLookup, consumer);
        this.generateToolAges((class_7225.class_7226<class_1792>)itemLookup, consumer);
        this.generateBlockAges((class_7225.class_7226<class_1792>)itemLookup, consumer);
        this.generateStoryAges(entityLookup, consumer);
    }

    private void generateArmorAges(class_7225.class_7226<class_1792> itemLookup, Consumer<AgeEntry> consumer) {
        Age.Builder.create().display(class_1802.field_8577, (class_2561)class_2561.method_43471((String)"age.genesis.leather"), (class_2561)class_2561.method_43473()).build(consumer, ARMOR_LEATHER);
        Age.Builder.create().display(class_1802.field_61344, (class_2561)class_2561.method_43471((String)"age.genesis.copper"), (class_2561)class_2561.method_43471((String)"age.genesis.armor.copper.description")).requireKillHostiles(50).itemUnlocks(class_1856.method_8106((class_6885)itemLookup.method_46735(GenesisTags.Items.COPPER_ARMOR))).parent(ARMOR_LEATHER).build(consumer, ARMOR_COPPER);
        Age.Builder.create().display(class_1802.field_8523, (class_2561)class_2561.method_43471((String)"age.genesis.iron"), (class_2561)class_2561.method_43471((String)"age.genesis.armor.iron.description")).requireTrialWearing(itemLookup, false, class_1802.field_61343, class_1802.field_61344, class_1802.field_61345, class_1802.field_61346).itemUnlocks(class_1856.method_8106((class_6885)itemLookup.method_46735(GenesisTags.Items.IRON_ARMOR))).itemUnlocks(class_1856.method_8106((class_6885)itemLookup.method_46735(GenesisTags.Items.GOLDEN_ARMOR))).parent(ARMOR_COPPER).build(consumer, ARMOR_IRON);
        Age.Builder.create().display(class_1802.field_8058, (class_2561)class_2561.method_43471((String)"age.genesis.diamond"), (class_2561)class_2561.method_43471((String)"age.genesis.armor.diamond.description")).requireTrialWearing(itemLookup, true, class_1802.field_8743, class_1802.field_8523, class_1802.field_8396, class_1802.field_8660).itemUnlocks(class_1856.method_8106((class_6885)itemLookup.method_46735(GenesisTags.Items.DIAMOND_ARMOR))).parent(ARMOR_IRON).build(consumer, ARMOR_DIAMOND);
        Age.Builder.create().display(class_1802.field_22028, (class_2561)class_2561.method_43471((String)"age.genesis.netherite"), (class_2561)class_2561.method_43471((String)"age.genesis.armor.netherite.description")).criterion("completed_raid", class_174.field_19250.method_53699((class_184)new class_2135.class_2137(Optional.empty()))).itemUnlocks(class_1856.method_8106((class_6885)itemLookup.method_46735(GenesisTags.Items.NETHERITE_ARMOR))).parent(ARMOR_DIAMOND).build(consumer, ARMOR_NETHERITE);
    }

    private void generateToolAges(class_7225.class_7226<class_1792> itemLookup, Consumer<AgeEntry> consumer) {
        Age.Builder.create().display(class_1802.field_8647, (class_2561)class_2561.method_43471((String)"age.genesis.wood"), (class_2561)class_2561.method_43473()).build(consumer, TOOLS_WOOD);
        Age.Builder.create().display(class_1802.field_8387, (class_2561)class_2561.method_43471((String)"age.genesis.stone"), (class_2561)class_2561.method_43471((String)"age.genesis.tools.stone.description")).criterion("broken_wood", ItemBrokenCriterion.Conditions.create((class_6885<class_1792>)itemLookup.method_46735(GenesisTags.Items.WOODEN_TOOLS))).itemUnlocks(class_1856.method_8106((class_6885)itemLookup.method_46735(GenesisTags.Items.STONE_TOOLS))).parent(TOOLS_WOOD).build(consumer, TOOLS_STONE);
        Age.Builder.create().display(class_1802.field_61340, (class_2561)class_2561.method_43471((String)"age.genesis.copper"), (class_2561)class_2561.method_43471((String)"age.genesis.tools.copper.description")).criterion("broken_stone", ItemBrokenCriterion.Conditions.create((class_6885<class_1792>)itemLookup.method_46735(GenesisTags.Items.STONE_TOOLS))).itemUnlocks(class_1856.method_8106((class_6885)itemLookup.method_46735(GenesisTags.Items.COPPER_TOOLS))).parent(TOOLS_STONE).build(consumer, TOOLS_COPPER);
        Age.Builder.create().display(class_1802.field_8403, (class_2561)class_2561.method_43471((String)"age.genesis.iron"), (class_2561)class_2561.method_43471((String)"age.genesis.tools.iron.description")).criterion("broken_copper", ItemBrokenCriterion.Conditions.create((class_6885<class_1792>)itemLookup.method_46735(GenesisTags.Items.COPPER_TOOLS))).itemUnlocks(class_1856.method_8106((class_6885)itemLookup.method_46735(GenesisTags.Items.IRON_TOOLS))).itemUnlocks(class_1856.method_8106((class_6885)itemLookup.method_46735(GenesisTags.Items.GOLDEN_TOOLS))).parent(TOOLS_COPPER).build(consumer, TOOLS_IRON);
        Age.Builder.create().display(class_1802.field_8377, (class_2561)class_2561.method_43471((String)"age.genesis.diamond"), (class_2561)class_2561.method_43471((String)"age.genesis.tools.diamond.description")).criterion("broken_iron", ItemBrokenCriterion.Conditions.create((class_6885<class_1792>)itemLookup.method_46735(GenesisTags.Items.IRON_TOOLS))).itemUnlocks(class_1856.method_8106((class_6885)itemLookup.method_46735(GenesisTags.Items.DIAMOND_TOOLS))).parent(TOOLS_IRON).build(consumer, TOOLS_DIAMOND);
        Age.Builder.create().display(class_1802.field_22024, (class_2561)class_2561.method_43471((String)"age.genesis.netherite"), (class_2561)class_2561.method_43471((String)"age.genesis.tools.netherite.description")).criterion("broken_diamond", ItemBrokenCriterion.Conditions.create((class_6885<class_1792>)itemLookup.method_46735(GenesisTags.Items.DIAMOND_TOOLS))).itemUnlocks(class_1856.method_8106((class_6885)itemLookup.method_46735(GenesisTags.Items.NETHERITE_TOOLS))).parent(TOOLS_DIAMOND).build(consumer, TOOLS_NETHERITE);
    }

    private void generateBlockAges(class_7225.class_7226<class_1792> itemLookup, Consumer<AgeEntry> consumer) {
        Age.Builder.create().display(GenesisBlocks.KILN.method_8389(), (class_2561)class_2561.method_43471((String)"age.genesis.clay"), (class_2561)class_2561.method_43473()).build(consumer, BLOCKS_CLAY);
        Age.Builder.create().display(class_1802.field_8732, (class_2561)class_2561.method_43471((String)"age.genesis.furnace"), (class_2561)class_2561.method_43471((String)"age.genesis.blocks.furnace.description")).parent(BLOCKS_CLAY).parentOptional().requireAge(TOOLS_IRON).requireAge(ARMOR_IRON).itemUnlocks(class_1856.method_8106((class_6885)itemLookup.method_46735(GenesisTags.Items.FURNACES))).build(consumer, BLOCKS_FURNACE);
        Age.Builder.create().display(class_1802.field_8789, (class_2561)class_2561.method_43471((String)"age.genesis.bed"), (class_2561)class_2561.method_43471((String)"age.genesis.blocks.bed.description")).parent(BLOCKS_FURNACE).parentOptional().requireTimePlayed(120000).itemUnlocks(class_1856.method_8106((class_6885)itemLookup.method_46735(class_3489.field_16444))).build(consumer, BLOCKS_BED);
    }

    private void generateStoryAges(class_7225.class_7226<class_1299<?>> entityLookup, Consumer<AgeEntry> consumer) {
        Age.Builder.create().display(class_1802.field_8503, (class_2561)class_2561.method_43471((String)"age.genesis.survival"), (class_2561)class_2561.method_43473()).build(consumer, STORY_SURVIVAL);
        Age.Builder.create().itemUnlocks(class_1856.method_8101((class_1935)GenesisItems.CLAY_SHIELD_CAST)).parent(STORY_SURVIVAL).parentOptional().criterion("killed_creaking", class_2080.class_2083.method_8997((class_2048.class_2049)class_2048.class_2049.method_8916().method_8921(entityLookup, class_1299.field_54560))).display(class_1802.field_54624, (class_2561)class_2561.method_43471((String)"age.genesis.garden"), (class_2561)class_2561.method_43471((String)"age.genesis.story.garden.description")).build(consumer, STORY_GARDEN);
        Age.Builder.create().dimensionUnlocks(class_1937.field_25180).parent(STORY_GARDEN).parentOptional().criterion("has_enchanted", class_2030.class_2032.method_8877()).display(class_1802.field_8093, (class_2561)class_2561.method_43471((String)"age.genesis.nether"), (class_2561)class_2561.method_43471((String)"age.genesis.story.nether.description")).build(consumer, STORY_NETHER);
        Age.Builder.create().itemUnlocks(class_1856.method_8101((class_1935)class_1802.field_8547)).parent(STORY_NETHER).parentOptional().criterion("complete_monument", GenesisCriteria.COMPLETE_MONUMENT.method_53699((class_184)new class_2135.class_2137(Optional.empty()))).display(class_1802.field_8769, (class_2561)class_2561.method_43471((String)"age.genesis.ocean"), (class_2561)class_2561.method_43471((String)"age.genesis.story.ocean.description")).build(consumer, STORY_OCEAN);
        Age.Builder.create().itemUnlocks(class_1856.method_8101((class_1935)GenesisItems.CLAY_ANVIL_CAST)).parent(STORY_OCEAN).parentOptional().criterion(LOOT_ANCIENT_CITY_REQUIREMENT, class_5282.class_5283.method_27995((class_5321)class_39.field_38438)).criterion(LOOT_ANCIENT_CITY_ICE_BOX_REQUIREMENT, class_5282.class_5283.method_27995((class_5321)class_39.field_38439)).requirements(class_8782.method_53674(ANCIENT_CITY_REQUIREMENTS)).display(class_1802.field_38219, (class_2561)class_2561.method_43471((String)"age.genesis.sculk"), (class_2561)class_2561.method_43471((String)"age.genesis.story.sculk.description")).build(consumer, STORY_SCULK);
        Age.Builder.create().parent(STORY_SCULK).parentOptional().itemUnlocks(class_1856.method_8101((class_1935)class_1802.field_8367)).criterion("killed_wither", class_2080.class_2083.method_8997((class_2048.class_2049)class_2048.class_2049.method_8916().method_8921(entityLookup, class_1299.field_6119))).display(class_1802.field_40867, (class_2561)class_2561.method_43471((String)"age.genesis.wither"), (class_2561)class_2561.method_43471((String)"age.genesis.story.wither.description")).build(consumer, STORY_WITHER);
        Age.Builder.create().parent(STORY_WITHER).dimensionUnlocks(class_1937.field_25181).itemUnlocks(class_1856.method_8101((class_1935)class_1802.field_8449)).requireAge(STORY_NETHER).requireAge(STORY_GARDEN).requireAge(STORY_OCEAN).requireAge(STORY_SCULK).requireAge(STORY_WITHER).display(class_1802.field_40865, (class_2561)class_2561.method_43471((String)"age.genesis.end"), (class_2561)class_2561.method_43471((String)"age.genesis.story.end.description")).build(consumer, STORY_END);
    }

    public String method_10321() {
        return "Genesis Ages";
    }

    static enum AgeCategory implements class_3542
    {
        ARMOR("armor"),
        BLOCKS("blocks"),
        TOOLS("tools"),
        STORY("story");

        private final String name;

        private AgeCategory(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

