/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.genesis.recipe;

import org.jetbrains.annotations.NotNull;

public record CraftingPattern(int patternBits) {
    public static final CraftingPattern ALL = CraftingPattern.fromGrid(new boolean[]{true, true, true, true, true, true, true, true, true});
    public static final CraftingPattern SWORD = CraftingPattern.fromGrid(new boolean[]{false, true, false, false, true, false, false, true, false});
    public static final CraftingPattern SHOVEL = CraftingPattern.fromGrid(new boolean[]{false, true, false, false, true, false, false, true, false});
    public static final CraftingPattern PICKAXE = CraftingPattern.fromGrid(new boolean[]{true, true, true, false, true, false, false, true, false});
    public static final CraftingPattern AXE = CraftingPattern.fromGrid(new boolean[]{true, true, false, true, true, false, false, true, false});
    public static final CraftingPattern HOE = CraftingPattern.fromGrid(new boolean[]{true, true, false, false, true, false, false, true, false});
    public static final CraftingPattern SHIELD = CraftingPattern.fromGrid(new boolean[]{true, true, true, true, true, true, false, true, false});
    public static final CraftingPattern ANVIL = CraftingPattern.fromGrid(new boolean[]{true, true, true, false, true, false, true, true, true});

    public CraftingPattern(int patternBits) {
        this.patternBits = patternBits & 0x1FF;
    }

    public boolean isSlotDisabled(int index) {
        if (index < 0 || index >= 9) {
            return false;
        }
        return (this.patternBits >> index & 1) == 0;
    }

    public static CraftingPattern fromGrid(boolean[] grid) {
        if (grid.length != 9) {
            throw new IllegalArgumentException("Grid must have a length 9");
        }
        int bits = 0;
        for (int i = 0; i < 9; ++i) {
            if (!grid[i]) continue;
            bits |= 1 << i;
        }
        return new CraftingPattern(bits);
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder(11);
        for (int i = 0; i < 9; ++i) {
            sb.append(this.isSlotDisabled(i) ? "0" : "1");
            if (i % 3 != 2) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

