/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.genesis.recipe;

import dev.mariany.genesis.Genesis;
import dev.mariany.genesis.item.GenesisItems;
import dev.mariany.genesis.tag.GenesisTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_10289;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;

public class DynamicHealthyStewRecipeProvider {
    private final class_7225.class_7874 wrapperLookup;

    public DynamicHealthyStewRecipeProvider(class_7225.class_7874 wrapperLookup) {
        this.wrapperLookup = wrapperLookup;
    }

    public static List<class_2960> getRecipesInvolving(class_1792 item) {
        return DynamicHealthyStewRecipeProvider.getRecipesInvolving(item, DynamicHealthyStewRecipeProvider.getItemsInTag(GenesisTags.Items.HEALTHY_STEW_CONTENTS));
    }

    private static List<class_2960> getRecipesInvolving(class_1792 item, List<class_1792> possibleIngredients) {
        return DynamicHealthyStewRecipeProvider.generate(possibleIngredients).stream().filter(data -> data.ingredients().contains(item)).map(HealthyStewRecipeData::id).toList();
    }

    private static List<class_1792> getItemsInTag(class_6862<class_1792> tag) {
        return class_7923.field_41178.method_46733(tag).map(registryEntries -> registryEntries.method_40239().map(class_6880::comp_349).toList()).orElseGet(List::of);
    }

    private static List<HealthyStewRecipeData> generate(List<class_1792> possibleIngredients) {
        ArrayList<HealthyStewRecipeData> results = new ArrayList<HealthyStewRecipeData>();
        int ingredientCount = possibleIngredients.size();
        for (int i = 0; i < ingredientCount; ++i) {
            class_1792 primaryItem = possibleIngredients.get(i);
            for (int j = i + 1; j < ingredientCount; ++j) {
                class_1792 secondaryItem = possibleIngredients.get(j);
                class_2960 idA = DynamicHealthyStewRecipeProvider.createStewRecipeId(primaryItem, secondaryItem);
                List<class_1792> ingredientsA = List.of(primaryItem, primaryItem, secondaryItem);
                results.add(new HealthyStewRecipeData(idA, primaryItem, ingredientsA));
                class_2960 idB = DynamicHealthyStewRecipeProvider.createStewRecipeId(secondaryItem, primaryItem);
                List<class_1792> ingredientsB = List.of(primaryItem, secondaryItem, secondaryItem);
                results.add(new HealthyStewRecipeData(idB, secondaryItem, ingredientsB));
            }
        }
        return results;
    }

    public class_10289 provide(Collection<class_8786<?>> recipes) {
        ArrayList newRecipes = new ArrayList(recipes);
        this.wrapperLookup.method_46759(class_7924.field_41197).flatMap(itemRegistry -> itemRegistry.method_46733(GenesisTags.Items.HEALTHY_STEW_CONTENTS)).ifPresent(entryList -> {
            List<class_1792> itemsInTag = entryList.method_40239().map(class_6880::comp_349).toList();
            List<HealthyStewRecipeData> recipeDataList = DynamicHealthyStewRecipeProvider.generate(itemsInTag);
            for (HealthyStewRecipeData data : recipeDataList) {
                newRecipes.add(new class_8786(class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)data.id()), (class_1860)this.createStewRecipe(data)));
            }
            Genesis.LOGGER.info("Added {} healthy stew recipes!", (Object)recipeDataList.size());
        });
        return class_10289.method_64700(newRecipes);
    }

    private class_1867 createStewRecipe(HealthyStewRecipeData data) {
        ArrayList<class_1792> ingredients = new ArrayList<class_1792>(data.ingredients());
        ingredients.add(class_1802.field_8428);
        List<class_1856> ingredientList = ingredients.stream().map(class_1856::method_8101).toList();
        Object group = "healthy_stew_";
        group = (String)group + data.primaryItem().method_40131().method_40237().method_29177().method_12832();
        return new class_1867((String)group, class_7710.field_40251, GenesisItems.HEALTHY_STEW.method_7854(), ingredientList);
    }

    private static class_2960 createStewRecipeId(class_1792 twoItem, class_1792 oneItem) {
        String twoName = twoItem.method_40131().method_40237().method_29177().method_12832();
        String oneName = oneItem.method_40131().method_40237().method_29177().method_12832();
        String pattern = "2_" + twoName + "_1_" + oneName;
        return Genesis.id("healthy_stew/" + pattern);
    }

    private record HealthyStewRecipeData(class_2960 id, class_1792 primaryItem, List<class_1792> ingredients) {
    }
}

