/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.genesis.screen;

import dev.mariany.genesis.block.GenesisBlocks;
import dev.mariany.genesis.item.custom.AssemblyPatternItem;
import dev.mariany.genesis.recipe.CraftingPattern;
import dev.mariany.genesis.recipe.GenesisRecipeTypes;
import dev.mariany.genesis.screen.GenesisScreenHandlers;
import dev.mariany.genesis.screen.slot.AssemblyInputSlot;
import dev.mariany.genesis.screen.slot.AssemblyPatternSlot;
import dev.mariany.genesis.sound.GenesisSoundEvents;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2765;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3914;
import net.minecraft.class_3955;
import net.minecraft.class_5421;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import net.minecraft.class_9884;
import org.jetbrains.annotations.Nullable;

public class AssemblyScreenHandler
extends class_9884 {
    private static final int SIZE = 3;
    private final class_3914 context;
    private final class_1657 player;
    private final class_1277 assemblyPatternInventory = new class_1277(1);
    private final AssemblyPatternSlot assemblyPatternSlot;
    private final class_1734 resultSlot;
    private boolean filling;

    public AssemblyScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public AssemblyScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        super(GenesisScreenHandlers.ASSEMBLY, syncId, 3, 3);
        this.context = context;
        this.player = playerInventory.field_7546;
        this.onAssemblyPatternChange(inventory -> {
            this.dropLockedInputs();
            this.method_7609(inventory);
            playerInventory.method_5431();
        });
        this.method_61626(53, 17);
        this.assemblyPatternSlot = this.addAssemblyPatternSlot();
        this.resultSlot = this.addResultSlot(this.player, 147, 35);
        this.method_61624((class_1263)playerInventory, 8, 84);
    }

    public void onAssemblyPatternChange(class_1265 listener) {
        this.assemblyPatternInventory.method_5489(listener);
    }

    private static void offerOrDropStack(class_1657 player, class_1799 stack) {
        class_3222 serverPlayerEntity;
        boolean bl2;
        boolean bl = player.method_31481() && player.method_35049() != class_1297.class_5529.field_27002;
        boolean bl3 = bl2 = player instanceof class_3222 && (serverPlayerEntity = (class_3222)player).method_14239();
        if (bl || bl2) {
            player.method_7328(stack, false);
        } else if (player instanceof class_3222) {
            player.method_31548().method_7398(stack);
        }
    }

    protected void updateResult(class_3218 world, @Nullable class_8786<class_3955> recipe) {
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            class_9694 craftingRecipeInput = this.field_52559.method_59961();
            class_1799 result = class_1799.field_8037;
            Optional optionalRecipeEntry = world.method_8503().method_3772().method_59993(GenesisRecipeTypes.ASSEMBLY, (class_9695)craftingRecipeInput, (class_1937)world, recipe);
            if (optionalRecipeEntry.isPresent()) {
                class_8786 recipeEntry = (class_8786)optionalRecipeEntry.get();
                class_3955 craftingRecipe = (class_3955)recipeEntry.comp_1933();
                if (this.field_52560.method_7665(serverPlayer, recipeEntry)) {
                    class_1799 stack = craftingRecipe.method_8116((class_9695)craftingRecipeInput, (class_7225.class_7874)world.method_30349());
                    boolean stackEnabled = stack.method_45435(world.method_45162());
                    boolean assemblyCanCraft = this.getCrafts().map(arg_0 -> ((class_1799)stack).method_31573(arg_0)).orElse(false);
                    if (stackEnabled && assemblyCanCraft) {
                        result = stack;
                    }
                }
            }
            this.field_52560.method_5447(0, result);
            this.method_34245(10, result);
            serverPlayer.field_13987.method_14364((class_2596)new class_2653(this.field_7763, this.method_37422(), 10, result));
        }
    }

    private void dropLockedInputs() {
        for (int i = 0; i < this.field_52559.method_5439(); ++i) {
            if (!this.isInputSlotDisabled(i)) continue;
            AssemblyScreenHandler.offerOrDropStack(this.player, this.field_52559.method_5441(i));
        }
        this.method_61628().forEach(class_1735::method_7668);
    }

    protected void method_61626(int x, int y) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.method_7621(new AssemblyInputSlot(this, (class_1263)this.field_52559, j + i * 3, x + j * 18, y + i * 18));
            }
        }
    }

    protected AssemblyPatternSlot addAssemblyPatternSlot() {
        AssemblyPatternSlot assemblyPatternSlot = new AssemblyPatternSlot((class_1263)this.assemblyPatternInventory, 0, 28, 35);
        this.method_7621(assemblyPatternSlot);
        return assemblyPatternSlot;
    }

    protected class_1734 addResultSlot(class_1657 player, int x, int y) {
        class_1734 craftingResultSlot = new class_1734(player, this.field_52559, (class_1263)this.field_52560, 0, x, y){

            public void method_7667(class_1657 player, class_1799 stack) {
                super.method_7667(player, stack);
                AssemblyScreenHandler.this.assemblyPatternInventory.method_5438(0).method_7934(1);
                AssemblyScreenHandler.this.assemblyPatternInventory.method_5431();
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    AssemblyScreenHandler.this.context.method_17393((world, pos) -> serverPlayer.field_13987.method_14364((class_2596)new class_2765(GenesisSoundEvents.BLOCK_ASSEMBLY_TABLE_USE, class_3419.field_15245, (class_1297)serverPlayer, 1.0f, class_3532.method_32750((class_5819)world.method_8409(), (float)1.4f, (float)0.9f), world.method_8409().method_43055())));
                }
            }
        };
        this.method_7621((class_1735)craftingResultSlot);
        return craftingResultSlot;
    }

    public Optional<AssemblyPatternItem> getAssemblyPatternItem() {
        class_1792 class_17922 = this.assemblyPatternSlot.method_7677().method_7909();
        if (class_17922 instanceof AssemblyPatternItem) {
            AssemblyPatternItem assemblyPatternItem = (AssemblyPatternItem)class_17922;
            return Optional.of(assemblyPatternItem);
        }
        return Optional.empty();
    }

    public Optional<CraftingPattern> getCraftingPattern() {
        return this.getAssemblyPatternItem().map(AssemblyPatternItem::getCraftingPattern);
    }

    public Optional<class_6862<class_1792>> getCrafts() {
        return this.getAssemblyPatternItem().map(AssemblyPatternItem::getCrafts);
    }

    public boolean isInputSlotDisabled(int slot) {
        return this.getCraftingPattern().map(craftingPattern -> craftingPattern.isSlotDisabled(slot)).orElse(true);
    }

    public class_1735 method_61627() {
        return this.resultSlot;
    }

    public List<class_1735> method_61628() {
        return this.field_7761.subList(0, 9);
    }

    protected class_1657 method_61631() {
        return this.player;
    }

    public class_5421 method_30264() {
        return class_5421.field_25763;
    }

    public void method_7609(class_1263 inventory) {
        if (!this.filling) {
            this.context.method_17393((world, pos) -> {
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    this.updateResult(serverWorld, null);
                }
            });
        }
    }

    public void method_59963() {
        this.filling = true;
    }

    public void method_59964(class_3218 world, class_8786<class_3955> recipe) {
        this.filling = false;
        this.updateResult(world, recipe);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> {
            this.method_7607(player, (class_1263)this.field_52559);
            this.method_7607(player, (class_1263)this.assemblyPatternInventory);
        });
    }

    public boolean method_7597(class_1657 player) {
        return AssemblyScreenHandler.method_17695((class_3914)this.context, (class_1657)player, (class_2248)GenesisBlocks.ASSEMBLY_TABLE);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1735 selectedSlot = (class_1735)this.field_7761.get(index);
        if (!selectedSlot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 stackInSlot = selectedSlot.method_7677();
        class_1799 originalStack = stackInSlot.method_7972();
        if (index == 10) {
            stackInSlot.method_7909().method_54465(stackInSlot, player);
            if (!this.method_7616(stackInSlot, 11, 47, true)) {
                return class_1799.field_8037;
            }
            selectedSlot.method_7670(stackInSlot, originalStack);
        } else if (index >= 11 && index < 47) {
            if (!this.method_7616(stackInSlot, 0, 9, false)) {
                class_1735 specialSlot = (class_1735)this.field_7761.get(9);
                if (specialSlot.method_7680(stackInSlot) && !this.method_7616(stackInSlot, 9, 10, false)) {
                    return class_1799.field_8037;
                }
                return class_1799.field_8037;
            }
        } else if (index >= 0 && index <= 9 && !this.method_7616(stackInSlot, 11, 47, false)) {
            return class_1799.field_8037;
        }
        if (stackInSlot.method_7960()) {
            selectedSlot.method_53512(class_1799.field_8037);
        } else {
            selectedSlot.method_7668();
        }
        if (stackInSlot.method_7947() == originalStack.method_7947()) {
            return class_1799.field_8037;
        }
        selectedSlot.method_7667(player, stackInSlot);
        if (index == 10) {
            player.method_7328(stackInSlot, false);
        }
        return originalStack;
    }
}

