/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked;

import dev.moonaticks.customGuiReworked.api.CustomGuiAPI;
import dev.moonaticks.customGuiReworked.commands.GuiTableCommand;
import dev.moonaticks.customGuiReworked.commands.TableTabCompleter;
import dev.moonaticks.customGuiReworked.listeners.BlockBreakListener;
import dev.moonaticks.customGuiReworked.listeners.BlockClickListener;
import dev.moonaticks.customGuiReworked.listeners.CustomTablesListener;
import dev.moonaticks.customGuiReworked.listeners.TableEditorListener;
import dev.moonaticks.customGuiReworked.managers.DatabaseManager;
import dev.moonaticks.customGuiReworked.managers.EditorGUIs;
import dev.moonaticks.customGuiReworked.managers.LanguageManager;
import dev.moonaticks.customGuiReworked.managers.TableEditorManager;
import dev.moonaticks.customGuiReworked.tools.ItemDrops;
import dev.moonaticks.customGuiReworked.tools.TableGUI;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class CustomGuiReworked
extends JavaPlugin {
    public DatabaseManager databaseManager;
    File pluginFolder = this.getDataFolder();
    ItemDrops itemDrops;
    public TableEditorManager manager;
    public EditorGUIs editorGUIs;
    public TableGUI tableGUI;
    public TableEditorListener tableEditorListener;
    public BlockBreakListener blockBreakListener;
    public GuiTableCommand guiTableCommand;
    public TableTabCompleter tableTabCompleter;
    public BlockClickListener blockClickListener;
    public CustomTablesListener customTablesListener;
    public LanguageManager languageManager;
    public static Map<String, String> languageMap = new ConcurrentHashMap<String, String>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.saveDefaultLanguageFiles();
        this.languageManager = new LanguageManager(this);
        this.languageManager.loadLanguage();
        this.itemDrops = new ItemDrops(this);
        this.databaseManager = new DatabaseManager(this.pluginFolder, this.itemDrops, this);
        this.manager = new TableEditorManager(this, this.pluginFolder);
        this.editorGUIs = new EditorGUIs(this.manager);
        this.tableGUI = new TableGUI(this, this.manager, this.databaseManager);
        this.tableEditorListener = new TableEditorListener(this.manager, this.editorGUIs, this.tableGUI, this);
        this.getServer().getPluginManager().registerEvents((Listener)this.tableEditorListener, (Plugin)this);
        this.guiTableCommand = new GuiTableCommand(this, this.manager, this.editorGUIs, this.tableGUI, this.pluginFolder);
        this.tableTabCompleter = new TableTabCompleter(this.pluginFolder);
        Objects.requireNonNull(this.getCommand("gui")).setExecutor((CommandExecutor)this.guiTableCommand);
        Objects.requireNonNull(this.getCommand("gui")).setTabCompleter((TabCompleter)this.tableTabCompleter);
        if (this.isItemsAdderAvailable() && this.areItemsAdderClassesAvailable()) {
            try {
                this.blockBreakListener = new BlockBreakListener(this.databaseManager, this.tableGUI);
                this.getServer().getPluginManager().registerEvents((Listener)this.blockBreakListener, (Plugin)this);
                this.blockClickListener = new BlockClickListener(this.tableGUI, this, this.manager, this.blockBreakListener);
                this.getServer().getPluginManager().registerEvents((Listener)this.blockClickListener, (Plugin)this);
                this.getLogger().info("ItemsAdder \u043d\u0430\u0439\u0434\u0435\u043d, \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u0438 ItemsAdder \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u044b");
            }
            catch (Exception | NoClassDefFoundError e) {
                this.getLogger().warning("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u0438 ItemsAdder: " + e.getMessage());
                this.blockBreakListener = null;
            }
        } else {
            this.getLogger().info("ItemsAdder \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d, \u0441\u043b\u0443\u0448\u0430\u0442\u0435\u043b\u0438 ItemsAdder \u043d\u0435 \u0431\u0443\u0434\u0443\u0442 \u0437\u0430\u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u044b");
            this.blockBreakListener = null;
        }
        this.customTablesListener = new CustomTablesListener(this, this.tableGUI, this.manager, this.databaseManager, this.itemDrops, this.pluginFolder, this.blockBreakListener);
        this.getServer().getPluginManager().registerEvents((Listener)this.customTablesListener, (Plugin)this);
        CustomGuiAPI.initialize(this);
        this.functional();
        this.hello();
    }

    public void onDisable() {
        this.shutDown();
    }

    void hello() {
        this.getLogger().info("---------------------------------------------------------------");
        this.getLogger().info("  \u2588\u2588\u2588\u2588\u2588 \u2588   \u2588 \u2588\u2588\u2588\u2588\u2588 \u2588\u2588\u2588\u2588\u2588 \u2588\u2588\u2588\u2588\u2588 \u2588\u2588   \u2588\u2588       \u2588\u2588\u2588\u2588\u2588 \u2588   \u2588 \u2588\u2588\u2588  ");
        this.getLogger().info("  \u2588     \u2588   \u2588 \u2588       \u2588   \u2588   \u2588 \u2588 \u2588 \u2588 \u2588       \u2588     \u2588   \u2588  \u2588   ");
        this.getLogger().info("  \u2588     \u2588   \u2588 \u2588\u2588\u2588\u2588\u2588   \u2588   \u2588   \u2588 \u2588  \u2588  \u2588       \u2588 \u2588\u2588\u2588 \u2588   \u2588  \u2588   ");
        this.getLogger().info("  \u2588     \u2588   \u2588     \u2588   \u2588   \u2588   \u2588 \u2588     \u2588       \u2588   \u2588 \u2588   \u2588  \u2588   ");
        this.getLogger().info("  \u2588\u2588\u2588\u2588\u2588 \u2588\u2588\u2588\u2588\u2588 \u2588\u2588\u2588\u2588\u2588   \u2588   \u2588\u2588\u2588\u2588\u2588 \u2588     \u2588       \u2588\u2588\u2588\u2588\u2588 \u2588\u2588\u2588\u2588\u2588 \u2588\u2588\u2588  ");
        this.getLogger().info("---------------------------------------------------------------");
        this.getLogger().info("plugin is enabled");
    }

    void functional() {
        this.manager.loadAllGuis();
        this.manager.loadAllBlocks();
    }

    void shutDown() {
        this.tableGUI.closeAllInventories();
    }

    private boolean isItemsAdderAvailable() {
        return this.getServer().getPluginManager().getPlugin("ItemsAdder") != null && this.getServer().getPluginManager().getPlugin("ItemsAdder").isEnabled();
    }

    private boolean areItemsAdderClassesAvailable() {
        try {
            Class.forName("dev.lone.itemsadder.api.Events.CustomBlockBreakEvent");
            Class.forName("dev.lone.itemsadder.api.Events.CustomBlockInteractEvent");
            Class.forName("dev.lone.itemsadder.api.CustomBlock");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void saveDefaultLanguageFiles() {
        String[] languageFiles;
        File langDir = new File(this.getDataFolder(), "lang");
        if (!langDir.exists()) {
            langDir.mkdirs();
            this.getLogger().info("\u0421\u043e\u0437\u0434\u0430\u043d\u0430 \u043f\u0430\u043f\u043a\u0430 lang");
        }
        for (String fileName : languageFiles = new String[]{"en.yml", "ru.yml"}) {
            File langFile = new File(langDir, fileName);
            if (langFile.exists()) continue;
            this.saveResource("lang/" + fileName, false);
            this.getLogger().info("\u0421\u043e\u0437\u0434\u0430\u043d \u0444\u0430\u0439\u043b \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u0430: " + fileName);
        }
    }
}

