/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.api;

import com.google.gson.JsonArray;
import dev.moonaticks.customGuiReworked.CustomGuiReworked;
import dev.moonaticks.customGuiReworked.managers.DatabaseManager;
import dev.moonaticks.customGuiReworked.managers.TableEditorManager;
import dev.moonaticks.customGuiReworked.tools.Gui;
import dev.moonaticks.customGuiReworked.tools.TableGUI;
import java.io.File;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class CustomGuiAPI {
    private static CustomGuiReworked plugin;
    private static TableEditorManager manager;
    private static DatabaseManager databaseManager;
    private static TableGUI tableGUI;
    private static boolean initialized;

    public static void initialize(CustomGuiReworked pluginInstance) {
        if (initialized) {
            return;
        }
        plugin = pluginInstance;
        manager = pluginInstance.manager;
        databaseManager = pluginInstance.databaseManager;
        tableGUI = pluginInstance.tableGUI;
        initialized = true;
    }

    public static boolean isInitialized() {
        return initialized && plugin != null && manager != null && databaseManager != null && tableGUI != null;
    }

    public static Gui createGui(String fileName) {
        if (!CustomGuiAPI.isInitialized()) {
            return null;
        }
        if (!((String)fileName).endsWith(".yml")) {
            fileName = (String)fileName + ".yml";
        }
        Gui gui = manager.createFile((String)fileName);
        manager.saveToFile(gui);
        return gui;
    }

    public static Gui createGui(String fileName, String title, int slots, int saveDataMethode) {
        if (!CustomGuiAPI.isInitialized()) {
            return null;
        }
        if (!((String)fileName).endsWith(".yml")) {
            fileName = (String)fileName + ".yml";
        }
        if (slots != 9 && slots != 18 && slots != 27 && slots != 36 && slots != 45 && slots != 54) {
            plugin.getLogger().warning("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u043b\u043e\u0442\u043e\u0432: " + slots + ". \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e: 27");
            slots = 27;
        }
        if (saveDataMethode < 1 || saveDataMethode > 5) {
            plugin.getLogger().warning("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043c\u0435\u0442\u043e\u0434 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f: " + saveDataMethode + ". \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e: 5");
            saveDataMethode = 5;
        }
        Gui gui = manager.createFile((String)fileName);
        gui.setTitle(title);
        gui.setSlots(slots);
        gui.setSaveDataMethode(saveDataMethode);
        gui.resetSkeleton();
        gui.resetDesign();
        manager.saveToFile(gui);
        return gui;
    }

    public static Gui getGui(String fileName) {
        if (!CustomGuiAPI.isInitialized()) {
            return null;
        }
        if (!((String)fileName).endsWith(".yml")) {
            fileName = (String)fileName + ".yml";
        }
        return manager.getGuiByFile((String)fileName);
    }

    public static boolean saveGui(Gui gui) {
        if (!CustomGuiAPI.isInitialized() || gui == null) {
            return false;
        }
        manager.saveToFile(gui);
        return true;
    }

    public static boolean deleteGui(Gui gui) {
        if (!CustomGuiAPI.isInitialized() || gui == null) {
            return false;
        }
        manager.removeGui(gui);
        File file = new File(CustomGuiAPI.manager.dir, gui.getFile());
        if (file.exists()) {
            return file.delete();
        }
        return true;
    }

    public static JsonArray getBlockInventory(Location location, String guiName) {
        if (!CustomGuiAPI.isInitialized() || location == null || guiName == null) {
            return null;
        }
        if (!((String)guiName).endsWith(".yml")) {
            guiName = (String)guiName + ".yml";
        }
        return databaseManager.loadFromBlock(location, (String)guiName);
    }

    public static JsonArray getPlayerInventory(Player player, String guiName) {
        if (!CustomGuiAPI.isInitialized() || player == null || guiName == null) {
            return null;
        }
        if (!((String)guiName).endsWith(".yml")) {
            guiName = (String)guiName + ".yml";
        }
        return databaseManager.loadFromPlayer(player, (String)guiName);
    }

    public static JsonArray getGlobalInventory(String guiName) {
        if (!CustomGuiAPI.isInitialized() || guiName == null) {
            return null;
        }
        if (!((String)guiName).endsWith(".yml")) {
            guiName = (String)guiName + ".yml";
        }
        return databaseManager.loadGlobally((String)guiName);
    }

    public static JsonArray getTeamInventory(Player player, String guiName) {
        if (!CustomGuiAPI.isInitialized() || player == null || guiName == null) {
            return null;
        }
        if (!((String)guiName).endsWith(".yml")) {
            guiName = (String)guiName + ".yml";
        }
        return databaseManager.loadFromTeam(player, (String)guiName);
    }

    public static boolean openGui(Player player, String guiName) {
        Gui gui;
        if (!CustomGuiAPI.isInitialized() || player == null || guiName == null) {
            return false;
        }
        if (!((String)guiName).endsWith(".yml")) {
            guiName = (String)guiName + ".yml";
        }
        if ((gui = manager.getGuiByFile((String)guiName)) == null) {
            return false;
        }
        tableGUI.getCustomInventory(player, gui);
        return true;
    }

    public static boolean openBlockGui(Player player, String guiName, Location location) {
        Gui gui;
        if (!CustomGuiAPI.isInitialized() || player == null || guiName == null || location == null) {
            return false;
        }
        if (!((String)guiName).endsWith(".yml")) {
            guiName = (String)guiName + ".yml";
        }
        if ((gui = manager.getGuiByFile((String)guiName)) == null) {
            return false;
        }
        tableGUI.getCustomInventory(player, gui, location);
        return true;
    }

    public static CustomGuiReworked getPlugin() {
        return plugin;
    }

    public static TableEditorManager getManager() {
        return manager;
    }

    public static TableGUI getTableGUI() {
        return tableGUI;
    }

    public static boolean breakBlock(Location location) {
        if (!CustomGuiAPI.isInitialized() || location == null) {
            return false;
        }
        if (CustomGuiAPI.plugin.blockBreakListener == null) {
            plugin.getLogger().warning("BlockBreakListener \u043d\u0435 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d, \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043f\u043e\u043b\u043e\u043c\u043a\u0443 \u0431\u043b\u043e\u043a\u0430");
            return false;
        }
        CustomGuiAPI.plugin.blockBreakListener.handleBlockBreak(location);
        return true;
    }

    static {
        initialized = false;
    }
}

