/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.managers;

import com.google.gson.JsonArray;
import dev.moonaticks.customGuiReworked.CustomGuiReworked;
import dev.moonaticks.customGuiReworked.managers.TableEditorManager;
import dev.moonaticks.customGuiReworked.tools.EditorInventoryHolder;
import dev.moonaticks.customGuiReworked.tools.GetItemNBT;
import dev.moonaticks.customGuiReworked.tools.Gui;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class EditorGUIs {
    public final Map<Key, Map<Integer, Inventory>> MainEditors = new HashMap<Key, Map<Integer, Inventory>>();
    TableEditorManager editorManager;

    public EditorGUIs(TableEditorManager editorManager) {
        this.editorManager = editorManager;
    }

    private Inventory mainEditor(Gui gui) {
        String title = CustomGuiReworked.languageMap.getOrDefault("mainEditorTitle", "&8[\u24bc\u24ca\u24d8 \u24ba\u24b9\u24d8\u24c9\u24c4\u24c7]: &f") + gui.getFile();
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new EditorInventoryHolder("MAIN"), (int)27, (Component)Component.text((String)title));
        ItemStack filler = this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ");
        for (int i = 0; i <= 8; ++i) {
            inventory.setItem(i, filler);
        }
        ItemStack filler2 = this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ");
        for (int i = 18; i <= 26; ++i) {
            inventory.setItem(i, filler2);
        }
        inventory.setItem(10, this.createItem(Material.CHEST, CustomGuiReworked.languageMap.getOrDefault("setSlotCount", "&e\u0417\u0430\u0434\u0430\u0442\u044c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u043b\u043e\u0442\u043e\u0432")));
        inventory.setItem(11, this.createItem(Material.BONE, CustomGuiReworked.languageMap.getOrDefault("createSkeleton", "&e\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0441\u043a\u0435\u043b\u0435\u0442 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430")));
        inventory.setItem(12, this.createItem(Material.PAINTING, CustomGuiReworked.languageMap.getOrDefault("createDesign", "&e\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u0438\u0437\u0430\u0439\u043d \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430")));
        inventory.setItem(13, this.createItem(Material.CRAFTING_TABLE, CustomGuiReworked.languageMap.getOrDefault("interfaceSettings", "&e\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430")));
        inventory.setItem(14, this.createItem(Material.APPLE, CustomGuiReworked.languageMap.getOrDefault("saveDataSettingsButton", "&e\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445")));
        inventory.setItem(15, this.createItem(Material.MAP, CustomGuiReworked.languageMap.getOrDefault("previewInterface", "&e\u041f\u0440\u0435\u0434\u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430")));
        inventory.setItem(16, this.createItem(Material.NOTE_BLOCK, CustomGuiReworked.languageMap.getOrDefault("configureItemsAdder", "&e\u041d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0431\u043b\u043e\u043a\u0438 ItemsAdder")));
        return inventory;
    }

    private Inventory DesignGUI(Gui gui) {
        int slotCount = gui.getSlots();
        List<String> skeleton = gui.getSkeleton();
        if (skeleton.isEmpty()) {
            return Bukkit.createInventory(null, (int)9, (Component)Component.text((String)CustomGuiReworked.languageMap.getOrDefault("error", "&c&lERROR")));
        }
        if (slotCount == -1) {
            return Bukkit.createInventory(null, (int)9, (Component)Component.text((String)CustomGuiReworked.languageMap.getOrDefault("error", "&c&lERROR")));
        }
        String title = CustomGuiReworked.languageMap.getOrDefault("designEditorTitle", "&a\u0414\u0438\u0437\u0430\u0439\u043d GUI: &f") + gui.getFile();
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new EditorInventoryHolder("DESIGN"), (int)slotCount, (Component)Component.text((String)title));
        JsonArray itemsDATA = gui.getDesign();
        for (int i = 0; i <= slotCount - 1; ++i) {
            if (!skeleton.get(i).contains("design")) {
                inventory.setItem(i, this.createItem(Material.BEDROCK, CustomGuiReworked.languageMap.getOrDefault("blockedSlot", "&eblocked")));
                continue;
            }
            String ItemData = "";
            if (i < itemsDATA.size() && itemsDATA.get(i) != null) {
                ItemData = itemsDATA.get(i).toString();
            }
            ItemStack item = GetItemNBT.jsonToItemStack(ItemData);
            inventory.setItem(i, item);
        }
        return inventory;
    }

    private Inventory SkeletonEditorGUI(Gui gui) {
        int slotCount = gui.getSlots();
        if (slotCount < 9 || slotCount > 54) {
            return Bukkit.createInventory((InventoryHolder)new EditorInventoryHolder("ERROR"), (int)slotCount, (Component)Component.text((String)CustomGuiReworked.languageMap.getOrDefault("error", "&c&lERROR")));
        }
        String title = CustomGuiReworked.languageMap.getOrDefault("skeletonEditorTitle", "&6\u0421\u043a\u0435\u043b\u0435\u0442 GUI: &f") + gui.getFile();
        Inventory skeletonGui = Bukkit.createInventory((InventoryHolder)new EditorInventoryHolder("SKELETON"), (int)slotCount, (Component)Component.text((String)title));
        List<String> _skeleton = gui.getSkeleton();
        for (int i = 0; i < slotCount; ++i) {
            if (_skeleton.get(i).contains("design")) {
                skeletonGui.setItem(i, this.createItem(Material.LIGHT_BLUE_STAINED_GLASS_PANE, CustomGuiReworked.languageMap.getOrDefault("designSlotLabel", "&aDesign Slot")));
            }
            if (_skeleton.get(i).contains("container")) {
                skeletonGui.setItem(i, this.createItem(Material.GREEN_STAINED_GLASS_PANE, CustomGuiReworked.languageMap.getOrDefault("containerSlotLabel", "&bContainer Slot")));
            }
            if (_skeleton.get(i).contains("result")) {
                skeletonGui.setItem(i, this.createItem(Material.BLACK_STAINED_GLASS_PANE, CustomGuiReworked.languageMap.getOrDefault("resultSlotLabel", "&eResult Slot")));
            }
            if (_skeleton.get(i).contains("craft")) {
                skeletonGui.setItem(i, this.createItem(Material.ORANGE_STAINED_GLASS_PANE, CustomGuiReworked.languageMap.getOrDefault("craftSlotLabel", "&6Craft Slot")));
            }
            if (!_skeleton.get(i).contains("fuel")) continue;
            skeletonGui.setItem(i, this.createItem(Material.RED_STAINED_GLASS_PANE, CustomGuiReworked.languageMap.getOrDefault("fuelSlotLabel", "&cFuel Slot")));
        }
        return skeletonGui;
    }

    private Inventory SaveDataGUI(Gui gui) {
        String title = CustomGuiReworked.languageMap.getOrDefault("saveDataEditorTitle", "&b\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f: &f") + gui.getFile();
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new EditorInventoryHolder("SAVE_DATA"), (int)27, (Component)Component.text((String)title));
        for (int i = 0; i < 27; ++i) {
            inventory.setItem(i, this.createItem(Material.GRAY_STAINED_GLASS_PANE, ""));
        }
        inventory.setItem(11, this.createItem(Material.CHEST, CustomGuiReworked.languageMap.getOrDefault("blockSaveLabel", "&e\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0432 \u0431\u043b\u043e\u043a\u0435")));
        inventory.setItem(12, this.createItem(Material.PLAYER_HEAD, CustomGuiReworked.languageMap.getOrDefault("playerSaveLabel", "&e\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0432 \u0438\u0433\u0440\u043e\u043a\u0435")));
        inventory.setItem(13, this.createItem(Material.ENDER_CHEST, CustomGuiReworked.languageMap.getOrDefault("globalSaveLabel", "&e\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0438\u0433\u0440\u043e\u043a\u043e\u0432")));
        inventory.setItem(14, this.createItem(Material.LIGHT_BLUE_WOOL, CustomGuiReworked.languageMap.getOrDefault("teamSaveLabel", "&e\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0432 \u043a\u043e\u043c\u0430\u043d\u0434\u0435")));
        inventory.setItem(15, this.createItem(Material.BARRIER, CustomGuiReworked.languageMap.getOrDefault("noSaveLabel", "&e\u0411\u0435\u0437 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f")));
        int dataMt = gui.getSaveDataMethode() + 10;
        ItemMeta meta = Objects.requireNonNull(inventory.getItem(dataMt)).getItemMeta();
        meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
        Objects.requireNonNull(inventory.getItem(dataMt)).setItemMeta(meta);
        return inventory;
    }

    private Inventory SizeEditorGUI(Gui gui) {
        String title = CustomGuiReworked.languageMap.getOrDefault("sizeEditorTitle", "&e\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u043b\u043e\u0442\u043e\u0432: &f") + gui.getFile();
        Inventory sizeEditor = Bukkit.createInventory((InventoryHolder)new EditorInventoryHolder("SIZE"), (int)27, (Component)Component.text((String)title));
        ItemStack filler2 = this.createItem(Material.GRAY_STAINED_GLASS_PANE, " ");
        for (int i = 0; i < 27; ++i) {
            sizeEditor.setItem(i, filler2);
        }
        sizeEditor.setItem(10, this.createSlotItem(CustomGuiReworked.languageMap.getOrDefault("slot9", "&79 \u0441\u043b\u043e\u0442\u043e\u0432"), 9));
        sizeEditor.setItem(11, this.createSlotItem(CustomGuiReworked.languageMap.getOrDefault("slot18", "&718 \u0441\u043b\u043e\u0442\u043e\u0432"), 18));
        sizeEditor.setItem(12, this.createSlotItem(CustomGuiReworked.languageMap.getOrDefault("slot27", "&727 \u0441\u043b\u043e\u0442\u043e\u0432"), 27));
        sizeEditor.setItem(14, this.createSlotItem(CustomGuiReworked.languageMap.getOrDefault("slot36", "&736 \u0441\u043b\u043e\u0442\u043e\u0432"), 36));
        sizeEditor.setItem(15, this.createSlotItem(CustomGuiReworked.languageMap.getOrDefault("slot45", "&745 \u0441\u043b\u043e\u0442\u043e\u0432"), 45));
        sizeEditor.setItem(16, this.createSlotItem(CustomGuiReworked.languageMap.getOrDefault("slot54", "&754 \u0441\u043b\u043e\u0442\u0430"), 54));
        return sizeEditor;
    }

    public void openGuiWindow(Player player, Gui gui, int window) {
        this.editorManager.lastGui.put(player.getUniqueId(), gui);
        switch (window) {
            case 1: {
                player.openInventory(this.SizeEditorGUI(gui));
                break;
            }
            case 2: {
                player.openInventory(this.SkeletonEditorGUI(gui));
                break;
            }
            case 3: {
                player.openInventory(this.DesignGUI(gui));
                break;
            }
            case 4: {
                player.openInventory(this.SaveDataGUI(gui));
                break;
            }
            default: {
                Bukkit.createInventory(null, (int)9, (Component)Component.text((String)"ERROR"));
            }
        }
    }

    public void openMain(Player player, Gui gui) {
        UUID uuid = player.getUniqueId();
        this.editorManager.lastGui.put(uuid, gui);
        Key key = new Key(uuid, gui);
        Map inventories = this.MainEditors.computeIfAbsent(key, k -> {
            HashMap<Integer, Inventory> newList = new HashMap<Integer, Inventory>();
            newList.put(0, this.mainEditor(gui));
            newList.put(1, this.DesignGUI(gui));
            newList.put(2, this.SkeletonEditorGUI(gui));
            newList.put(3, this.SaveDataGUI(gui));
            newList.put(4, this.SizeEditorGUI(gui));
            return newList;
        });
        player.openInventory((Inventory)inventories.get(0));
    }

    public ItemStack createItem(Material material, String name) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName((Component)Component.text((String)name));
            item.setItemMeta(meta);
        }
        return item;
    }

    ItemStack createSlotItem(String name, int slotCount) {
        ItemStack item = new ItemStack(Material.CHEST);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName((Component)Component.text((String)name));
            item.setItemMeta(meta);
            item.setAmount(slotCount);
        }
        return item;
    }

    public static class Key {
        UUID uuid;
        Gui gui;

        public Key(UUID uuid, Gui gui) {
            this.uuid = uuid;
            this.gui = gui;
        }
    }
}

