/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.moonaticks.customGuiReworked.CustomGuiReworked;
import dev.moonaticks.customGuiReworked.tools.GetItemNBT;
import dev.moonaticks.customGuiReworked.tools.Gui;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ItemDrops {
    CustomGuiReworked plugin;

    public ItemDrops(CustomGuiReworked plugin) {
        this.plugin = plugin;
    }

    public void dropItems(Location location, JsonArray storage) {
        if (location == null || storage == null) {
            return;
        }
        for (JsonElement element : storage) {
            ItemStack itemStacks;
            if (element == null || (itemStacks = GetItemNBT.jsonToItemStack(element.toString())) == null || itemStacks.getType().equals((Object)Material.AIR)) continue;
            location.getWorld().dropItemNaturally(location, itemStacks);
        }
    }

    public void dropItems(Location location, Inventory storage) {
        if (location == null || storage == null) {
            return;
        }
        Gui gui = this.plugin.manager.getGuiByFile(this.plugin.tableGUI.getFileNameByInventory(storage));
        List<String> skeleton = gui.getSkeleton();
        for (int i = 0; i < storage.getSize(); ++i) {
            ItemStack itemStacks = storage.getItem(i);
            if (skeleton.get(i).contains("design") || itemStacks == null || itemStacks.getType().equals((Object)Material.AIR)) continue;
            location.getWorld().dropItemNaturally(location, itemStacks);
        }
    }

    public void ReturnItems(Player player, Inventory storage, Gui gui) {
        if (player == null || storage == null) {
            return;
        }
        Vector direction = player.getLocation().getDirection();
        Random random = new Random();
        double offsetX = (random.nextDouble() - 0.5) * 0.1;
        double offsetY = (random.nextDouble() - 0.5) * 0.1;
        double offsetZ = (random.nextDouble() - 0.5) * 0.1;
        direction.add(new Vector(offsetX, offsetY, offsetZ));
        direction.multiply(0.3);
        List<String> skeleton = gui.getSkeleton();
        for (int i = 0; i < storage.getSize(); ++i) {
            ItemStack item = storage.getItem(i);
            if (item == null || item.getType() == Material.AIR || skeleton.get(i).contains("design")) continue;
            ItemStack itemCopy = item.clone();
            HashMap leftover = player.getInventory().addItem(new ItemStack[]{itemCopy});
            if (leftover.isEmpty()) continue;
            for (ItemStack remainingItem : leftover.values()) {
                if (remainingItem == null || remainingItem.getType() == Material.AIR || remainingItem.getAmount() <= 0) continue;
                Item droppedItem = player.getWorld().dropItem(player.getLocation(), remainingItem);
                droppedItem.setVelocity(direction);
            }
        }
    }
}

