/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.tools;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageFormatter {
    private static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.builder().character('\u00a7').hexColors().build();
    private static final LegacyComponentSerializer LEGACY_AMPERSAND_SERIALIZER = LegacyComponentSerializer.builder().character('&').hexColors().build();
    private static final PlainTextComponentSerializer PLAIN_SERIALIZER = PlainTextComponentSerializer.plainText();

    public static Component formatComponent(String message) {
        if (message == null) {
            return Component.empty();
        }
        return LEGACY_SERIALIZER.deserialize(message);
    }

    public static Component formatComponentFromAmpersand(String message) {
        if (message == null) {
            return Component.empty();
        }
        return LEGACY_AMPERSAND_SERIALIZER.deserialize(message);
    }

    public static Component formatComponent(String message, Object ... args) {
        if (message == null) {
            return Component.empty();
        }
        String formatted = String.format(message, args);
        return LEGACY_SERIALIZER.deserialize(formatted);
    }

    public static Component colored(String text, NamedTextColor color) {
        return Component.text((String)text, (TextColor)color);
    }

    public static Component colored(String text, String hexColor) {
        TextColor color = TextColor.fromHexString((String)hexColor);
        return Component.text((String)text, (TextColor)color);
    }

    public static Component bold(String text) {
        return Component.text((String)text, (Style)Style.style((TextDecoration)TextDecoration.BOLD));
    }

    public static Component italic(String text) {
        return Component.text((String)text, (Style)Style.style((TextDecoration)TextDecoration.ITALIC));
    }

    public static Component underlined(String text) {
        return Component.text((String)text, (Style)Style.style((TextDecoration)TextDecoration.UNDERLINED));
    }

    public static Component strikethrough(String text) {
        return Component.text((String)text, (Style)Style.style((TextDecoration)TextDecoration.STRIKETHROUGH));
    }

    public static Component obfuscated(String text) {
        return Component.text((String)text, (Style)Style.style((TextDecoration)TextDecoration.OBFUSCATED));
    }

    public static Component formatted(String text, NamedTextColor color, TextDecoration ... decorations) {
        return Component.text((String)text, (Style)Style.style((TextColor)color, (TextDecoration[])decorations));
    }

    public static Component formatted(String text, String hexColor, TextDecoration ... decorations) {
        TextColor color = TextColor.fromHexString((String)hexColor);
        return Component.text((String)text, (Style)Style.style((TextColor)color, (TextDecoration[])decorations));
    }

    public static Component gradient(String text, String startColor, String endColor) {
        TextColor start = TextColor.fromHexString((String)startColor);
        TextColor end = TextColor.fromHexString((String)endColor);
        if (text.length() <= 1) {
            return Component.text((String)text, (TextColor)start);
        }
        TextComponent.Builder builder = Component.text();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            double ratio = (double)i / (double)(length - 1);
            int r = (int)((double)start.red() + (double)(end.red() - start.red()) * ratio);
            int g = (int)((double)start.green() + (double)(end.green() - start.green()) * ratio);
            int b = (int)((double)start.blue() + (double)(end.blue() - start.blue()) * ratio);
            TextColor interpolatedColor = TextColor.color((int)r, (int)g, (int)b);
            builder.append((Component)Component.text((String)String.valueOf(c), (TextColor)interpolatedColor));
        }
        return builder.build();
    }

    public static Component rainbow(String text, String ... colors) {
        if (colors.length == 0 || text.isEmpty()) {
            return Component.text((String)text);
        }
        TextComponent.Builder builder = Component.text();
        int length = text.length();
        int colorCount = colors.length;
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            int colorIndex = i * colorCount / length;
            TextColor color = TextColor.fromHexString((String)colors[colorIndex]);
            builder.append((Component)Component.text((String)String.valueOf(c), (TextColor)color));
        }
        return builder.build();
    }

    public static Component clickableUrl(String text, String url) {
        return Component.text((String)text).clickEvent(ClickEvent.openUrl((String)url));
    }

    public static Component clickableCommand(String text, String command) {
        return Component.text((String)text).clickEvent(ClickEvent.runCommand((String)command));
    }

    public static Component withTooltip(String text, String tooltip) {
        return Component.text((String)text).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)tooltip)));
    }

    public static Component withTooltip(String text, Component tooltip) {
        return Component.text((String)text).hoverEvent((HoverEventSource)HoverEvent.showText((Component)tooltip));
    }

    public static String format(String message) {
        if (message == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)message);
    }

    public static String formatFromAmpersand(String message) {
        if (message == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static String format(String message, Object ... args) {
        if (message == null) {
            return "";
        }
        String formatted = String.format(message, args);
        return ChatColor.translateAlternateColorCodes((char)'\u00a7', (String)formatted);
    }

    public static void sendMessage(Player player, String message) {
        if (player == null || message == null) {
            return;
        }
        player.sendMessage(MessageFormatter.formatComponent(message));
    }

    public static void sendMessage(Player player, String message, Object ... args) {
        if (player == null || message == null) {
            return;
        }
        player.sendMessage(MessageFormatter.formatComponent(message, args));
    }

    public static void sendMessage(Player player, Component component) {
        if (player == null || component == null) {
            return;
        }
        player.sendMessage(component);
    }

    public static void sendMessage(CommandSender sender, String message) {
        if (sender == null || message == null) {
            return;
        }
        sender.sendMessage(MessageFormatter.formatComponent(message));
    }

    public static void sendMessage(CommandSender sender, String message, Object ... args) {
        if (sender == null || message == null) {
            return;
        }
        sender.sendMessage(MessageFormatter.formatComponent(message, args));
    }

    public static void sendMessage(CommandSender sender, Component component) {
        if (sender == null || component == null) {
            return;
        }
        sender.sendMessage(component);
    }

    public static String componentToString(Component component) {
        if (component == null) {
            return "";
        }
        return PLAIN_SERIALIZER.serialize(component);
    }

    public static Component formatComponentWithHex(String message) {
        if (message == null) {
            return Component.empty();
        }
        return LEGACY_SERIALIZER.deserialize(message);
    }

    public static Component createHeader(String title) {
        return Component.text((String)("\u00a78[\u00a76" + title + "\u00a78]\u00a7f "));
    }

    public static Component createSeparator(int length) {
        StringBuilder separator = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            separator.append("\u00a78-");
        }
        return MessageFormatter.formatComponent(separator.toString());
    }

    public static Component createBox(String text) {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(MessageFormatter.formatComponent("\u00a78\u250c\u2500"))).append(MessageFormatter.formatComponent("\u00a76" + text))).append(MessageFormatter.formatComponent("\u00a78\u2500\u2510"))).build();
    }
}

