/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.api;

import dev.moonaticks.customGuiReworked.CustomGuiReworked;
import dev.moonaticks.customGuiReworked.managers.TableEditorManager;
import dev.moonaticks.customGuiReworked.tools.Gui;
import dev.moonaticks.customGuiReworked.tools.TableGUI;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class ApiManager {
    private final CustomGuiReworked plugin;
    private final TableEditorManager tableEditorManager;
    private final TableGUI tableGUI;

    public ApiManager(CustomGuiReworked plugin) {
        this.plugin = plugin;
        this.tableEditorManager = plugin.manager;
        this.tableGUI = plugin.tableGUI;
    }

    public void initialize() {
        this.plugin.getLogger().info("CustomGuiReworked API \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d");
    }

    public CustomGuiReworked getPlugin() {
        return this.plugin;
    }

    public TableEditorManager getTableEditorManager() {
        return this.tableEditorManager;
    }

    public TableGUI getTableGUI() {
        return this.tableGUI;
    }

    public boolean guiExists(String guiName) {
        return this.tableEditorManager.getGuiByFile(guiName + ".yml") != null;
    }

    public Gui getGui(String guiName) {
        return this.tableEditorManager.getGuiByFile(guiName + ".yml");
    }

    public List<Gui> getAllGuis() {
        return this.tableEditorManager.guis;
    }

    public void openGui(Player player, String guiName) {
        Gui gui = this.getGui(guiName);
        if (gui != null) {
            this.tableGUI.getCustomInventory(player, gui);
        }
    }

    public void openGui(Player player, String guiName, Location blockLocation) {
        Gui gui = this.getGui(guiName);
        if (gui != null) {
            this.tableGUI.getCustomInventory(player, gui, blockLocation);
        }
    }

    public Gui createGui(String guiName) {
        if (this.guiExists(guiName)) {
            return this.getGui(guiName);
        }
        Gui gui = this.tableEditorManager.createFile(guiName + ".yml");
        gui.resetSkeleton();
        gui.resetDesign();
        this.tableEditorManager.saveToFile(gui);
        return gui;
    }

    public boolean deleteGui(String guiName) {
        Gui gui = this.getGui(guiName);
        if (gui != null) {
            this.tableEditorManager.removeGui(gui);
            return true;
        }
        return false;
    }

    public void saveGui(Gui gui) {
        this.tableEditorManager.saveToFile(gui);
    }

    public Gui getLastGui(Player player) {
        return this.tableEditorManager.lastGui.get(player.getUniqueId());
    }

    public Gui getLastGui(UUID playerUUID) {
        return this.tableEditorManager.lastGui.get(playerUUID);
    }

    public void setBlockGui(Location location, String guiName) {
        Gui gui = this.getGui(guiName);
        if (gui != null) {
            this.tableEditorManager.blocksToGui.put(this.locationToString(location), gui);
        }
    }

    public Gui getBlockGui(Location location) {
        return this.tableEditorManager.blocksToGui.get(this.locationToString(location));
    }

    public void removeBlockGui(Location location) {
        this.tableEditorManager.blocksToGui.remove(this.locationToString(location));
    }

    public boolean hasBlockGui(Location location) {
        return this.tableEditorManager.blocksToGui.containsKey(this.locationToString(location));
    }

    public Inventory getSharedInventory(String key) {
        return this.tableGUI.sharedInventories.get(key);
    }

    public void addSharedInventory(String key, Inventory inventory) {
        this.tableGUI.addInventory(key, inventory);
    }

    public void removeSharedInventory(String key) {
        this.tableGUI.removeInventory(key);
    }

    public String getInventoryKey(Inventory inventory) {
        return this.tableGUI.getKeyByInventory(inventory);
    }

    public void reloadAllGuis() {
        this.tableEditorManager.loadAllGuis();
    }

    private String locationToString(Location location) {
        return location.getWorld().getName() + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
    }
}

