/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.api;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.inventory.Inventory;

public class SlotTypeAPI {
    private static final Map<String, SlotInfo> slotCache = new HashMap<String, SlotInfo>();

    public static SlotType getSlotType(int slot, Inventory inventory) {
        String key = inventory.getType().name() + "_" + slot;
        if (slotCache.containsKey(key)) {
            return slotCache.get(key).getType();
        }
        SlotType type = SlotTypeAPI.determineSlotType(slot, inventory);
        SlotInfo info = new SlotInfo(slot, type, SlotTypeAPI.isSlotEditable(slot, inventory), SlotTypeAPI.isSlotClickable(slot, inventory), SlotTypeAPI.getSlotDescription(slot, inventory));
        slotCache.put(key, info);
        return type;
    }

    public static SlotInfo getSlotInfo(int slot, Inventory inventory) {
        String key = inventory.getType().name() + "_" + slot;
        if (slotCache.containsKey(key)) {
            return slotCache.get(key);
        }
        SlotType type = SlotTypeAPI.determineSlotType(slot, inventory);
        SlotInfo info = new SlotInfo(slot, type, SlotTypeAPI.isSlotEditable(slot, inventory), SlotTypeAPI.isSlotClickable(slot, inventory), SlotTypeAPI.getSlotDescription(slot, inventory));
        slotCache.put(key, info);
        return info;
    }

    public static boolean isDesignSlot(int slot, Inventory inventory) {
        return SlotTypeAPI.getSlotType(slot, inventory) == SlotType.DESIGN;
    }

    public static boolean isContainerSlot(int slot, Inventory inventory) {
        return SlotTypeAPI.getSlotType(slot, inventory) == SlotType.CONTAINER;
    }

    public static boolean isCraftSlot(int slot, Inventory inventory) {
        return SlotTypeAPI.getSlotType(slot, inventory) == SlotType.CRAFT;
    }

    public static boolean isResultSlot(int slot, Inventory inventory) {
        return SlotTypeAPI.getSlotType(slot, inventory) == SlotType.RESULT;
    }

    public static boolean isFuelSlot(int slot, Inventory inventory) {
        return SlotTypeAPI.getSlotType(slot, inventory) == SlotType.FUEL;
    }

    public static boolean isSlotEditable(int slot, Inventory inventory) {
        SlotType type = SlotTypeAPI.getSlotType(slot, inventory);
        return type == SlotType.CONTAINER || type == SlotType.CRAFT || type == SlotType.FUEL;
    }

    public static boolean isSlotClickable(int slot, Inventory inventory) {
        SlotType type = SlotTypeAPI.getSlotType(slot, inventory);
        return type != SlotType.DESIGN;
    }

    public static String getSlotDescription(int slot, Inventory inventory) {
        SlotType type = SlotTypeAPI.getSlotType(slot, inventory);
        switch (type.ordinal()) {
            case 0: {
                return "\u0421\u043b\u043e\u0442 \u0434\u0438\u0437\u0430\u0439\u043d\u0430 (\u0434\u0435\u043a\u043e\u0440\u0430\u0442\u0438\u0432\u043d\u044b\u0439)";
            }
            case 1: {
                return "\u0421\u043b\u043e\u0442 \u043a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440\u0430 (\u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435)";
            }
            case 2: {
                return "\u0421\u043b\u043e\u0442 \u043a\u0440\u0430\u0444\u0442\u0430 (\u0440\u0435\u0446\u0435\u043f\u0442)";
            }
            case 3: {
                return "\u0421\u043b\u043e\u0442 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 (\u0432\u044b\u0445\u043e\u0434 \u043a\u0440\u0430\u0444\u0442\u0430)";
            }
            case 4: {
                return "\u0421\u043b\u043e\u0442 \u0442\u043e\u043f\u043b\u0438\u0432\u0430";
            }
        }
        return "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0441\u043b\u043e\u0442";
    }

    public static void clearCache() {
        slotCache.clear();
    }

    public static int[] getSlotsByType(SlotType type, Inventory inventory) {
        int[] slots = new int[inventory.getSize()];
        int count = 0;
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (SlotTypeAPI.getSlotType(i, inventory) != type) continue;
            slots[count++] = i;
        }
        int[] result = new int[count];
        System.arraycopy(slots, 0, result, 0, count);
        return result;
    }

    public static int getSlotCountByType(SlotType type, Inventory inventory) {
        int count = 0;
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (SlotTypeAPI.getSlotType(i, inventory) != type) continue;
            ++count;
        }
        return count;
    }

    public static boolean hasSlotType(SlotType type, Inventory inventory) {
        return SlotTypeAPI.getSlotCountByType(type, inventory) > 0;
    }

    public static int getFirstSlotByType(SlotType type, Inventory inventory) {
        for (int i = 0; i < inventory.getSize(); ++i) {
            if (SlotTypeAPI.getSlotType(i, inventory) != type) continue;
            return i;
        }
        return -1;
    }

    private static SlotType determineSlotType(int slot, Inventory inventory) {
        String inventoryType;
        switch (inventoryType = inventory.getType().name()) {
            case "CRAFTING": {
                return SlotTypeAPI.determineCraftingSlotType(slot);
            }
            case "FURNACE": 
            case "BLAST_FURNACE": 
            case "SMOKER": {
                return SlotTypeAPI.determineFurnaceSlotType(slot);
            }
            case "BREWING": {
                return SlotTypeAPI.determineBrewingSlotType(slot);
            }
            case "ANVIL": {
                return SlotTypeAPI.determineAnvilSlotType(slot);
            }
            case "ENCHANTING": {
                return SlotTypeAPI.determineEnchantingSlotType(slot);
            }
            case "BEACON": {
                return SlotTypeAPI.determineBeaconSlotType(slot);
            }
            case "HOPPER": {
                return SlotType.CONTAINER;
            }
            case "DISPENSER": 
            case "DROPPER": {
                return SlotType.CONTAINER;
            }
            case "CHEST": 
            case "ENDER_CHEST": 
            case "TRAPPED_CHEST": {
                return SlotType.CONTAINER;
            }
            case "SHULKER_BOX": {
                return SlotType.CONTAINER;
            }
            case "BARREL": {
                return SlotType.CONTAINER;
            }
        }
        return SlotTypeAPI.determineCustomSlotType(slot, inventory);
    }

    private static SlotType determineCraftingSlotType(int slot) {
        if (slot == 0) {
            return SlotType.RESULT;
        }
        if (slot >= 1 && slot <= 9) {
            return SlotType.CRAFT;
        }
        return SlotType.CONTAINER;
    }

    private static SlotType determineFurnaceSlotType(int slot) {
        if (slot == 0) {
            return SlotType.CRAFT;
        }
        if (slot == 1) {
            return SlotType.FUEL;
        }
        if (slot == 2) {
            return SlotType.RESULT;
        }
        return SlotType.CONTAINER;
    }

    private static SlotType determineBrewingSlotType(int slot) {
        if (slot >= 0 && slot <= 2) {
            return SlotType.CRAFT;
        }
        if (slot == 3) {
            return SlotType.FUEL;
        }
        if (slot >= 4 && slot <= 6) {
            return SlotType.CONTAINER;
        }
        return SlotType.CONTAINER;
    }

    private static SlotType determineAnvilSlotType(int slot) {
        if (slot == 0) {
            return SlotType.CRAFT;
        }
        if (slot == 1) {
            return SlotType.CRAFT;
        }
        if (slot == 2) {
            return SlotType.RESULT;
        }
        return SlotType.CONTAINER;
    }

    private static SlotType determineEnchantingSlotType(int slot) {
        if (slot == 0) {
            return SlotType.CRAFT;
        }
        if (slot == 1) {
            return SlotType.FUEL;
        }
        return SlotType.CONTAINER;
    }

    private static SlotType determineBeaconSlotType(int slot) {
        if (slot == 0) {
            return SlotType.CRAFT;
        }
        return SlotType.CONTAINER;
    }

    private static SlotType determineCustomSlotType(int slot, Inventory inventory) {
        int size = inventory.getSize();
        if (size <= 9) {
            return SlotType.CONTAINER;
        }
        if (size == 27) {
            if (slot < 9) {
                return SlotType.DESIGN;
            }
            return SlotType.CONTAINER;
        }
        if (size == 54) {
            if (slot < 18) {
                return SlotType.DESIGN;
            }
            return SlotType.CONTAINER;
        }
        return SlotType.CONTAINER;
    }

    public static boolean isCraftingResult(int slot, Inventory inventory) {
        return SlotTypeAPI.getSlotType(slot, inventory) == SlotType.RESULT;
    }

    public static boolean isCraftingIngredient(int slot, Inventory inventory) {
        return SlotTypeAPI.getSlotType(slot, inventory) == SlotType.CRAFT;
    }

    public static boolean isFuel(int slot, Inventory inventory) {
        return SlotTypeAPI.getSlotType(slot, inventory) == SlotType.FUEL;
    }

    public static boolean isDecorative(int slot, Inventory inventory) {
        return SlotTypeAPI.getSlotType(slot, inventory) == SlotType.DESIGN;
    }

    public static boolean isStorage(int slot, Inventory inventory) {
        return SlotTypeAPI.getSlotType(slot, inventory) == SlotType.CONTAINER;
    }

    public static class SlotInfo {
        private final int slot;
        private final SlotType type;
        private final boolean isEditable;
        private final boolean isClickable;
        private final String description;

        public SlotInfo(int slot, SlotType type, boolean isEditable, boolean isClickable, String description) {
            this.slot = slot;
            this.type = type;
            this.isEditable = isEditable;
            this.isClickable = isClickable;
            this.description = description;
        }

        public int getSlot() {
            return this.slot;
        }

        public SlotType getType() {
            return this.type;
        }

        public boolean isEditable() {
            return this.isEditable;
        }

        public boolean isClickable() {
            return this.isClickable;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return String.format("Slot[%d, %s, editable=%s, clickable=%s, desc='%s']", new Object[]{this.slot, this.type, this.isEditable, this.isClickable, this.description});
        }
    }

    public static enum SlotType {
        DESIGN,
        CONTAINER,
        CRAFT,
        RESULT,
        FUEL,
        UNKNOWN;

    }
}

