/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.listeners;

import dev.lone.itemsadder.api.CustomBlock;
import dev.lone.itemsadder.api.Events.CustomBlockBreakEvent;
import dev.moonaticks.customGuiReworked.managers.DatabaseManager;
import dev.moonaticks.customGuiReworked.tools.OpenInterfaceData;
import dev.moonaticks.customGuiReworked.tools.TableGUI;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class BlockBreakListener
implements Listener {
    private final DatabaseManager databaseManager;
    private final TableGUI tableGUI;
    private final Map<UUID, OpenInterfaceData> openInterfaces = new ConcurrentHashMap<UUID, OpenInterfaceData>();

    public BlockBreakListener(DatabaseManager databaseManager, TableGUI tableGUI) {
        this.databaseManager = databaseManager;
        this.tableGUI = tableGUI;
    }

    @EventHandler
    public void onBlockBreak(CustomBlockBreakEvent event) {
        Block block = event.getBlock();
        Location blockLoc = block.getLocation();
        CustomBlock customBlock = CustomBlock.byAlreadyPlaced((Block)block);
        if (customBlock != null) {
            this.databaseManager.removeBlockData(blockLoc);
            this.closeInterfacesForBlock(blockLoc);
            this.tableGUI.removeInventoryByLocation(blockLoc);
        }
    }

    public void closeInterfacesForBlock(Location blockLocation) {
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, OpenInterfaceData> entry : this.openInterfaces.entrySet()) {
            OpenInterfaceData data = entry.getValue();
            Location dataLoc = data.blockLocation();
            if (dataLoc == null || !dataLoc.getWorld().equals((Object)blockLocation.getWorld()) || dataLoc.getBlockX() != blockLocation.getBlockX() || dataLoc.getBlockY() != blockLocation.getBlockY() || dataLoc.getBlockZ() != blockLocation.getBlockZ()) continue;
            toRemove.add(entry.getKey());
        }
        for (UUID uuid : toRemove) {
            this.openInterfaces.remove(uuid);
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || !player.isOnline()) continue;
            player.closeInventory();
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.removeOpenInterface(event.getPlayer());
    }

    public void addOpenInterface(Player player, String tableName, Location blockLocation) {
        this.openInterfaces.put(player.getUniqueId(), new OpenInterfaceData(tableName, blockLocation));
    }

    public void removeOpenInterface(Player player) {
        this.openInterfaces.remove(player.getUniqueId());
    }
}

