/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.managers;

import dev.moonaticks.customGuiReworked.CustomGuiReworked;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageManager {
    CustomGuiReworked plugin;

    public LanguageManager(CustomGuiReworked plugin) {
        this.plugin = plugin;
    }

    public Map<String, String> getLanguageMap() {
        HashMap<String, String> languageMap = new HashMap<String, String>();
        try {
            YamlConfiguration langConfig;
            File langFile;
            YamlConfiguration config;
            String language;
            File configFile = new File(this.plugin.getDataFolder(), "config.yml");
            if (!configFile.exists()) {
                this.plugin.getLogger().warning("\u0424\u0430\u0439\u043b config.yml \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d! \u0421\u043e\u0437\u0434\u0430\u0435\u043c \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439...");
                this.createDefaultConfig();
            }
            if ((language = (config = YamlConfiguration.loadConfiguration((File)configFile)).getString("language")) == null) {
                this.plugin.getLogger().warning("\u042f\u0437\u044b\u043a \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0432 config.yml, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c 'en'");
                language = "en";
            }
            if (!(langFile = new File(this.plugin.getDataFolder(), "lang/" + language + ".yml")).exists()) {
                this.plugin.getLogger().warning("\u0424\u0430\u0439\u043b \u044f\u0437\u044b\u043a\u0430 '" + language + ".yml' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d! \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439...");
                language = "en";
                langFile = new File(this.plugin.getDataFolder(), "lang/" + language + ".yml");
                if (!langFile.exists()) {
                    this.plugin.getLogger().severe("\u0424\u0430\u0439\u043b \u044f\u0437\u044b\u043a\u0430 'en.yml' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d! \u0421\u043e\u0437\u0434\u0430\u0435\u043c \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439...");
                    this.createDefaultLanguageFile();
                }
            }
            if ((langConfig = YamlConfiguration.loadConfiguration((File)langFile)).contains("language")) {
                for (String key : langConfig.getConfigurationSection("language").getKeys(false)) {
                    String value = langConfig.getString("language." + key);
                    if (value == null) continue;
                    languageMap.put(key, value);
                }
                this.plugin.getLogger().info("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e " + languageMap.size() + " \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u043e\u0432 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 " + language + ".yml");
            } else {
                this.plugin.getLogger().warning("\u0421\u0435\u043a\u0446\u0438\u044f 'language' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0444\u0430\u0439\u043b\u0435 " + language + ".yml");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u043e\u0432: " + e.getMessage());
            e.printStackTrace();
        }
        if (languageMap.isEmpty()) {
            this.plugin.getLogger().warning("\u041f\u0435\u0440\u0435\u0432\u043e\u0434\u044b \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c fallback \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
            this.addFallbackTranslations(languageMap);
        }
        return languageMap;
    }

    private void createDefaultConfig() {
        try {
            YamlConfiguration config = new YamlConfiguration();
            config.set("language", (Object)"en");
            config.save(new File(this.plugin.getDataFolder(), "config.yml"));
            this.plugin.getLogger().info("\u0421\u043e\u0437\u0434\u0430\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439 config.yml");
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c config.yml: " + e.getMessage());
        }
    }

    private void createDefaultLanguageFile() {
        try {
            File langFile;
            File langDir = new File(this.plugin.getDataFolder(), "lang");
            if (!langDir.exists()) {
                langDir.mkdirs();
            }
            if (!(langFile = new File(langDir, "en.yml")).exists()) {
                this.plugin.saveResource("lang/en.yml", false);
                this.plugin.getLogger().info("\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d \u0444\u0430\u0439\u043b \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u0430 en.yml \u0438\u0437 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432");
            } else {
                YamlConfiguration config = new YamlConfiguration();
                config.set("language.error", (Object)"\u00a7c\u00a7lERROR");
                config.set("language.mainEditorTitle", (Object)"\u00a78[\u24bc\u24ca\u24d8 \u24ba\u24b9\u24d8\u24c9\u24c4\u24c7]: \u00a7f");
                config.set("language.PlayersOnly", (Object)"\u00a7cThis command can only be run by players.");
                config.set("language.CommandError", (Object)"\u00a7cUse: \u00a7f/gui [create/open/delete/edit/reload]");
                config.set("language.NoPermission", (Object)"\u00a7cYou don't have permission to use this command");
                config.save(langFile);
                this.plugin.getLogger().info("\u0421\u043e\u0437\u0434\u0430\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0439 \u0444\u0430\u0439\u043b \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u043e\u0432 en.yml");
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u043e\u0432: " + e.getMessage());
        }
    }

    private void addFallbackTranslations(Map<String, String> languageMap) {
        languageMap.put("error", "\u00a7c\u00a7lERROR");
        languageMap.put("mainEditorTitle", "\u00a78[\u24bc\u24ca\u24d8 \u24ba\u24b9\u24d8\u24c9\u24c4\u24c7]: \u00a7f");
        languageMap.put("PlayersOnly", "\u00a7c\u042d\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0430\u043c\u0438.");
        languageMap.put("CommandError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui [create/open/delete/edit/reload]");
        languageMap.put("NoPermission", "\u00a7c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b");
        languageMap.put("InterfaceNotFound", "\u00a7c\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
        languageMap.put("SlotsError", "\u00a7c\u0421\u043b\u043e\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c!");
        languageMap.put("DelayError", "\u00a7c\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c!");
        languageMap.put("IndexError", "\u00a7c\u0418\u043d\u0434\u0435\u043a\u0441 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c!");
        languageMap.put("CommandAddSuccess", "\u00a7a\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u0432 \u0441\u043b\u043e\u0442: \u00a7f%s");
        languageMap.put("CommandAddError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui command add <\u0441\u043b\u043e\u0442> <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430> \"<\u043a\u043e\u043c\u0430\u043d\u0434\u0430>\"");
        languageMap.put("CommandDeleteSuccess", "\u00a7a\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0430 \u0438\u0437 \u0441\u043b\u043e\u0442\u0430: \u00a7f%s");
        languageMap.put("CommandDeleteError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui command delete <\u0441\u043b\u043e\u0442> <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430> <\u0438\u043d\u0434\u0435\u043a\u0441>");
        languageMap.put("CommandNotFound", "\u00a7c\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0432 \u0441\u043b\u043e\u0442\u0435 \u00a7f%s \u00a7a\u0434\u043b\u044f \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u00a7f%s \u00a7c\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!");
        languageMap.put("CommandListHeader", "\u00a7e################################");
        languageMap.put("CommandListTitle", "\u00a7a\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043c\u0430\u043d\u0434 \u0434\u043b\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u00a7f%s \u00a7a\u0434\u043b\u044f \u0441\u043b\u043e\u0442\u0430 \u00a7f%s");
        languageMap.put("CommandListFormat", "\u00a7e%s \u00a7f- %s");
        languageMap.put("Delay", "\u00a76\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430: \u00a7f%s");
        languageMap.put("CommandListFooter", "\u00a7e################################");
        languageMap.put("CommandValue", "\u00a7a\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0432 \u0441\u043b\u043e\u0442\u0435 \u00a7f%s \u00a7a\u0434\u043b\u044f \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u00a7f%s \u00a7a\u0438\u043c\u0435\u0435\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: \u00a7f%s");
        languageMap.put("CommandSetCommandError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui command [add/get/delete] <\u0441\u043b\u043e\u0442> <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430> \"<\u043a\u043e\u043c\u0430\u043d\u0434\u0430>\"");
        languageMap.put("WrongUsage", "\u00a7c\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui [create/open/delete/edit/reload/command]");
        languageMap.put("CommandCreateCommandError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui create <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430>");
        languageMap.put("CommandEditCommandError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui edit <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430>");
        languageMap.put("CommandDeleteCommandError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui delete <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430> [confirm]");
        languageMap.put("ErrorSet", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui edit <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430>");
        languageMap.put("ErrorOpen", "\u00a7c\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
        languageMap.put("DeleteSuccess", "\u00a7a\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u00a7f%s \u00a7a\u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d!");
        languageMap.put("ReloadSuccess", "\u00a7a\u041f\u0435\u0440\u0435\u0432\u043e\u0434\u044b \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e!");
        this.plugin.getLogger().info("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e " + languageMap.size() + " fallback \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u043e\u0432");
    }

    public void loadLanguage() {
        this.plugin.getLogger().info("\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u044b...");
        CustomGuiReworked.languageMap = this.getLanguageMap();
        this.plugin.getLogger().info("\u041f\u0435\u0440\u0435\u0432\u043e\u0434\u044b \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e! \u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e " + CustomGuiReworked.languageMap.size() + " \u043a\u043b\u044e\u0447\u0435\u0439");
    }

    public void reloadLanguage() {
        this.plugin.getLogger().info("\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u043f\u0435\u0440\u0435\u0432\u043e\u0434\u044b...");
        this.loadLanguage();
        this.plugin.getLogger().info("\u041f\u0435\u0440\u0435\u0432\u043e\u0434\u044b \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e!");
    }
}

