/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.managers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import dev.moonaticks.customGuiReworked.CustomGuiReworked;
import dev.moonaticks.customGuiReworked.tools.Gui;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.file.YamlConfiguration;

public class TableEditorManager {
    CustomGuiReworked plugin;
    File dir;
    public final List<Gui> guis = new ArrayList<Gui>();
    public final Map<String, Gui> blocksToGui = new ConcurrentHashMap<String, Gui>();
    public final Map<UUID, Gui> lastGui = new HashMap<UUID, Gui>();

    public TableEditorManager(CustomGuiReworked pl, File dir) {
        this.plugin = pl;
        this.dir = new File(dir, "tables");
    }

    public void loadAllGuis() {
        this.guis.clear();
        File[] files = this.dir.listFiles((dir1, name) -> name.endsWith(".yml"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            this.guis.add(this.loadFromFile(file.getName()));
        }
    }

    public void addGui(Gui gui) {
        this.guis.add(gui);
    }

    public void removeGui(Gui gui) {
        this.guis.remove(gui);
    }

    public void guisClear() {
        this.guis.clear();
    }

    public Gui getGuiByFile(String filename) {
        for (Gui gui : this.guis) {
            if (!gui.getFile().equals(filename)) continue;
            return gui;
        }
        return null;
    }

    public void saveToFile(Gui gui) {
        if (gui == null) {
            return;
        }
        File file = new File(this.dir, gui.getFile());
        YamlConfiguration config = new YamlConfiguration();
        boolean m = file.getParentFile().mkdirs();
        if (m) {
            this.plugin.getLogger().info(CustomGuiReworked.languageMap.getOrDefault("FolderCreated", "GUI folder created!"));
        }
        if (gui.getFile() == null || gui.getFile().isEmpty()) {
            this.plugin.getLogger().warning(CustomGuiReworked.languageMap.getOrDefault("GuiFilePathNotSet", "GUI file path is not set!"));
            return;
        }
        config.set("file", (Object)gui.getFile());
        config.set("slots", (Object)gui.getSlots());
        config.set("title", (Object)gui.getTitle());
        config.set("saveDataMethod", (Object)gui.getSaveDataMethode());
        config.set("skeleton", gui.getSkeleton());
        config.set("customBlockIDs", gui.getCustomBlockIDs());
        JsonArray design = gui.getDesign();
        ArrayList<String> designItems = new ArrayList<String>();
        for (JsonElement element : design) {
            designItems.add(element.toString());
        }
        config.set("design", designItems);
        JsonArray commands = gui.getCommandExecutor();
        ArrayList<String> commandList = new ArrayList<String>();
        for (JsonElement element : commands) {
            commandList.add(element.toString());
        }
        config.set("commandExecutor", commandList);
        try {
            config.save(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Gui createFile(String name) {
        Gui gui = new Gui(name);
        this.addGui(gui);
        return gui;
    }

    public Gui loadFromFile(String fileName) {
        File file = new File(this.dir, fileName);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        Gui gui = new Gui(fileName);
        if (!file.exists()) {
            return gui;
        }
        gui.setSlots(config.getInt("slots", 27));
        gui.setTitle(config.getString("title", "Change this"));
        gui.setSaveDataMethode(config.getInt("saveDataMethod", 5));
        if (config.contains("skeleton")) {
            gui.setSkeleton(config.getStringList("skeleton"));
        } else {
            ArrayList<String> defaultSkeleton = new ArrayList<String>();
            for (int i = 0; i < gui.getSlots(); ++i) {
                defaultSkeleton.add("design" + i);
            }
            gui.setSkeleton(defaultSkeleton);
        }
        if (config.contains("customBlockIDs")) {
            gui.setCustomBlockIDs(config.getStringList("customBlockIDs"));
        }
        if (config.contains("design")) {
            JsonArray designArray = new JsonArray();
            for (String itemJson : config.getStringList("design")) {
                designArray.add(JsonParser.parseString((String)itemJson));
            }
            gui.setDesign(designArray);
        } else {
            gui.resetDesign();
        }
        if (config.contains("commandExecutor")) {
            JsonArray commandArray = new JsonArray();
            for (String commandJson : config.getStringList("commandExecutor")) {
                commandArray.add(JsonParser.parseString((String)commandJson));
            }
            gui.setCommandExecutor(commandArray);
        }
        return gui;
    }

    public void loadAllBlocks() {
        this.blocksToGui.clear();
        this.guis.forEach(gui -> {
            List<String> array = gui.getCustomBlockIDs();
            array.forEach(id -> this.blocksToGui.put((String)id, (Gui)gui));
        });
    }
}

