/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.moonaticks.customGuiReworked.CustomGuiReworked;
import dev.moonaticks.customGuiReworked.tools.GetItemNBT;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Gui {
    private String file;
    private int slots = 27;
    private List<String> skeleton = new ArrayList<String>();
    private JsonArray design = new JsonArray();
    private String title = "Change this";
    private int saveDataMethode = 5;
    private JsonArray commandExecutor = new JsonArray();
    private List<String> customBlockIDs = new ArrayList<String>();

    public Gui(String name) {
        this.file = name;
    }

    public String getFile() {
        return this.file;
    }

    public int getSlots() {
        return this.slots;
    }

    public List<String> getSkeleton() {
        return this.skeleton;
    }

    public JsonArray getDesign() {
        return this.design;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSaveDataMethode() {
        return this.saveDataMethode;
    }

    public JsonArray getCommandExecutor() {
        return this.commandExecutor;
    }

    public List<String> getCustomBlockIDs() {
        return this.customBlockIDs;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setSlots(int slots) {
        this.slots = slots;
    }

    public void setSkeleton(List<String> skeleton) {
        this.skeleton = skeleton;
    }

    public void setDesign(JsonArray design) {
        this.design = design;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSaveDataMethode(int saveDataMethode) {
        this.saveDataMethode = saveDataMethode;
    }

    public void setCommandExecutor(JsonArray commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public void setCustomBlockIDs(List<String> customBlockIDs) {
        this.customBlockIDs = customBlockIDs;
    }

    public Inventory loadDesign(Player player, Inventory inventory) {
        int slotCount = this.slots;
        List<String> skeleton = this.skeleton;
        if (skeleton.isEmpty()) {
            player.sendMessage(CustomGuiReworked.languageMap.get("InterfaceBrokenSkeleton"));
            player.closeInventory();
            return inventory;
        }
        if (slotCount > 54 || slotCount < 0) {
            player.sendMessage(CustomGuiReworked.languageMap.get("InterfaceBrokenCount"));
            player.closeInventory();
            return inventory;
        }
        JsonArray itemsDATA = this.design;
        if (itemsDATA.isEmpty()) {
            player.sendMessage(CustomGuiReworked.languageMap.get("InterfaceBrokenDesigns"));
            player.closeInventory();
        } else {
            for (int i = 0; i < slotCount; ++i) {
                if (!skeleton.get(i).toString().contains("design")) continue;
                String ItemData = "";
                if (i < itemsDATA.size() && itemsDATA.get(i) != null) {
                    ItemData = itemsDATA.get(i).toString();
                }
                ItemStack item = GetItemNBT.jsonToItemStack(ItemData);
                int amount = item.getAmount();
                ItemMeta itemMeta = item.getItemMeta();
                if (itemMeta != null) {
                    itemMeta.setMaxStackSize(Integer.valueOf(amount));
                    item.setItemMeta(itemMeta);
                }
                item.setItemMeta(itemMeta);
                inventory.setItem(i, item);
            }
        }
        return inventory;
    }

    public void resetSkeleton() {
        this.skeleton.clear();
        for (int i = 0; i < this.slots; ++i) {
            this.skeleton.add("design" + i);
        }
    }

    public void resetDesign() {
        JsonArray designArray = new JsonArray();
        while (designArray.size() < this.slots) {
            designArray.add(GetItemNBT.itemStackToJson(new ItemStack(Material.AIR)));
        }
        Inventory inventory_copy = Bukkit.createInventory(null, (int)this.slots, (Component)Component.text((String)"temp"));
        for (int i = 0; i < this.slots; ++i) {
            ItemStack item = inventory_copy.getItem(i);
            String itemData = GetItemNBT.itemStackToJson(item);
            Object element = itemData != null && !itemData.isEmpty() && !itemData.equals("{}") ? JsonParser.parseString((String)itemData) : new JsonObject();
            designArray.set(i, (JsonElement)element);
        }
        this.setDesign(designArray);
    }
}

