/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.api;

import dev.moonaticks.customGuiReworked.CustomGuiReworked;
import dev.moonaticks.customGuiReworked.api.ApiManager;
import dev.moonaticks.customGuiReworked.tools.Gui;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class CustomGuiAPI {
    private static CustomGuiReworked plugin;
    private static ApiManager apiManager;

    public static void initialize(CustomGuiReworked mainPlugin) {
        plugin = mainPlugin;
        apiManager = mainPlugin.apiManager;
    }

    public static boolean isInitialized() {
        return plugin != null && apiManager != null;
    }

    public static CustomGuiReworked getPlugin() {
        return plugin;
    }

    public static ApiManager getApiManager() {
        return apiManager;
    }

    public static boolean guiExists(String guiName) {
        CustomGuiAPI.checkInitialization();
        return apiManager.guiExists(guiName);
    }

    public static Gui getGui(String guiName) {
        CustomGuiAPI.checkInitialization();
        return apiManager.getGui(guiName);
    }

    public static List<Gui> getAllGuis() {
        CustomGuiAPI.checkInitialization();
        return apiManager.getAllGuis();
    }

    public static Gui createGui(String guiName) {
        CustomGuiAPI.checkInitialization();
        return apiManager.createGui(guiName);
    }

    public static boolean deleteGui(String guiName) {
        CustomGuiAPI.checkInitialization();
        return apiManager.deleteGui(guiName);
    }

    public static void saveGui(Gui gui) {
        CustomGuiAPI.checkInitialization();
        apiManager.saveGui(gui);
    }

    public static void openGui(Player player, String guiName) {
        CustomGuiAPI.checkInitialization();
        apiManager.openGui(player, guiName);
    }

    public static void openGui(Player player, String guiName, Location blockLocation) {
        CustomGuiAPI.checkInitialization();
        apiManager.openGui(player, guiName, blockLocation);
    }

    public static Gui getLastGui(Player player) {
        CustomGuiAPI.checkInitialization();
        return apiManager.getLastGui(player);
    }

    public static Gui getLastGui(UUID playerUUID) {
        CustomGuiAPI.checkInitialization();
        return apiManager.getLastGui(playerUUID);
    }

    public static void setBlockGui(Location location, String guiName) {
        CustomGuiAPI.checkInitialization();
        apiManager.setBlockGui(location, guiName);
    }

    public static Gui getBlockGui(Location location) {
        CustomGuiAPI.checkInitialization();
        return apiManager.getBlockGui(location);
    }

    public static void removeBlockGui(Location location) {
        CustomGuiAPI.checkInitialization();
        apiManager.removeBlockGui(location);
    }

    public static boolean hasBlockGui(Location location) {
        CustomGuiAPI.checkInitialization();
        return apiManager.hasBlockGui(location);
    }

    public static Inventory getSharedInventory(String key) {
        CustomGuiAPI.checkInitialization();
        return apiManager.getSharedInventory(key);
    }

    public static void addSharedInventory(String key, Inventory inventory) {
        CustomGuiAPI.checkInitialization();
        apiManager.addSharedInventory(key, inventory);
    }

    public static void removeSharedInventory(String key) {
        CustomGuiAPI.checkInitialization();
        apiManager.removeSharedInventory(key);
    }

    public static String getInventoryKey(Inventory inventory) {
        CustomGuiAPI.checkInitialization();
        return apiManager.getInventoryKey(inventory);
    }

    public static void reloadAllGuis() {
        CustomGuiAPI.checkInitialization();
        apiManager.reloadAllGuis();
    }

    private static void checkInitialization() {
        if (!CustomGuiAPI.isInitialized()) {
            throw new IllegalStateException("CustomGuiAPI \u043d\u0435 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d! \u0423\u0431\u0435\u0434\u0438\u0442\u0435\u0441\u044c, \u0447\u0442\u043e \u043f\u043b\u0430\u0433\u0438\u043d CustomGuiReworked \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d.");
        }
    }

    public static void createAndOpenGui(Player player, String guiName) {
        CustomGuiAPI.checkInitialization();
        Gui gui = CustomGuiAPI.createGui(guiName);
        if (gui != null) {
            CustomGuiAPI.openGui(player, guiName);
        }
    }

    public static void createAndOpenGui(Player player, String guiName, Location blockLocation) {
        CustomGuiAPI.checkInitialization();
        Gui gui = CustomGuiAPI.createGui(guiName);
        if (gui != null) {
            CustomGuiAPI.openGui(player, guiName, blockLocation);
        }
    }

    public static boolean hasOpenGui(Player player) {
        return player.getOpenInventory() != null && player.getOpenInventory().getTopInventory() != null;
    }

    public static int getGuiCount() {
        CustomGuiAPI.checkInitialization();
        return apiManager.getAllGuis().size();
    }

    public static List<String> getGuiNames() {
        CustomGuiAPI.checkInitialization();
        return apiManager.getAllGuis().stream().map(gui -> gui.getFile().replace(".yml", "")).toList();
    }
}

