/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.commands;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.moonaticks.customGuiReworked.CustomGuiReworked;
import dev.moonaticks.customGuiReworked.managers.EditorGUIs;
import dev.moonaticks.customGuiReworked.managers.TableEditorManager;
import dev.moonaticks.customGuiReworked.tools.Gui;
import dev.moonaticks.customGuiReworked.tools.MessageFormatter;
import dev.moonaticks.customGuiReworked.tools.TableGUI;
import java.io.File;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class GuiTableCommand
implements CommandExecutor {
    TableEditorManager manager;
    CustomGuiReworked plugin;
    EditorGUIs editorGUIs;
    TableGUI tableGUI;
    File dir;

    public GuiTableCommand(CustomGuiReworked plugin, TableEditorManager manager, EditorGUIs editorGUIs, TableGUI tableGUI, File dir) {
        this.manager = manager;
        this.plugin = plugin;
        this.editorGUIs = editorGUIs;
        this.tableGUI = tableGUI;
        this.dir = new File(dir, "tables");
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("PlayersOnly", "\u00a7c\u042d\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0430\u043c\u0438."));
            return true;
        }
        if (args.length == 0) {
            MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("CommandError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui [create/open/delete/edit/reload]"));
            return true;
        }
        block8 : switch (args[0]) {
            case "create": {
                Player player = (Player)sender;
                if (!player.hasPermission("customgui.create")) {
                    MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("NoPermission", "\u00a7c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b"));
                    return true;
                }
                if (args.length == 2) {
                    String tableName = args[1];
                    File file = new File(this.dir, (tableName = tableName.replaceAll("[^a-zA-Z0-9_-]", "_")) + ".yml");
                    if (!file.exists()) {
                        Gui gui = this.manager.createFile(tableName + ".yml");
                        gui.resetSkeleton();
                        gui.resetDesign();
                        this.manager.saveToFile(gui);
                        this.editorGUIs.openMain(player, gui);
                        break;
                    }
                    Gui gui = this.manager.getGuiByFile(tableName + ".yml");
                    this.editorGUIs.openMain(player, gui);
                    break;
                }
                MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("CommandCreateCommandError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui create <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430>"));
                break;
            }
            case "edit": {
                Player player = (Player)sender;
                if (!player.hasPermission("customgui.edit")) {
                    MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("NoPermission", "\u00a7c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b"));
                    return true;
                }
                if (args.length == 2) {
                    String tableName = args[1];
                    tableName = tableName.replaceAll("[^a-zA-Z0-9_-]", "_");
                    File file = new File(this.dir, tableName + ".yml");
                    Gui gui = this.manager.getGuiByFile(tableName + ".yml");
                    if (file.exists()) {
                        this.editorGUIs.openMain(player, gui);
                        break;
                    }
                    MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("ErrorSet", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui edit <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430>"));
                    break;
                }
                MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("CommandEditCommandError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui edit <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430>"));
                break;
            }
            case "delete": {
                Player player = (Player)sender;
                if (!player.hasPermission("customgui.delete")) {
                    MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("NoPermission", "\u00a7c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b"));
                    return true;
                }
                if (args.length == 2) {
                    String tableName = args[1];
                    File file = new File(this.dir, (tableName = tableName.replaceAll("[^a-zA-Z0-9_-]", "_")) + ".yml");
                    if (file.exists()) {
                        file.delete();
                        MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("DeleteSuccess", "\u00a7a\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u00a7f%s \u00a7a\u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d!"), tableName);
                        break;
                    }
                    MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("InterfaceNotFound", "\u00a7c\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"));
                    break;
                }
                if (args.length == 3 && args[2].equals("confirm")) {
                    String tableName = args[1];
                    File file = new File(this.dir, (tableName = tableName.replaceAll("[^a-zA-Z0-9_-]", "_")) + ".yml");
                    if (file.exists()) {
                        file.delete();
                        MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("DeleteSuccess", "\u00a7a\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u00a7f%s \u00a7a\u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d!"), tableName);
                        break;
                    }
                    MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("InterfaceNotFound", "\u00a7c\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"));
                    break;
                }
                MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("CommandDeleteCommandError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui delete <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430> [confirm]"));
                break;
            }
            case "open": {
                Player player = (Player)sender;
                if (!player.hasPermission("customgui.open")) {
                    MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("NoPermission", "\u00a7c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b"));
                    return true;
                }
                if (args.length != 2) break;
                String tableName = args[1].replaceAll("[^a-zA-Z0-9_-]", "_");
                File file = new File(this.dir, tableName + ".yml");
                if (file.exists()) {
                    Gui gui = this.manager.getGuiByFile(tableName + ".yml");
                    this.manager.lastGui.put(player.getUniqueId(), gui);
                    this.tableGUI.getCustomInventory(player, gui);
                    break;
                }
                MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("ErrorOpen", "\u00a7c\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"));
                break;
            }
            case "command": {
                Player player = (Player)sender;
                if (!player.hasPermission("customgui.command")) {
                    MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("NoPermission", "\u00a7c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b"));
                    return true;
                }
                if (args.length >= 2) {
                    switch (args[1]) {
                        case "add": {
                            if (args.length >= 3) {
                                if (!GuiTableCommand.isInteger(args[2])) {
                                    MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("SlotsError", "\u00a7c\u0421\u043b\u043e\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c!"));
                                    return true;
                                }
                                int slot = Integer.parseInt(args[2]);
                                if (args.length >= 4) {
                                    String tableName = args[3];
                                    tableName = tableName.replaceAll("[^a-zA-Z0-9_-]", "_");
                                    Gui gui = this.manager.getGuiByFile(tableName + ".yml");
                                    File file = new File(this.dir, tableName + ".yml");
                                    if (file.exists()) {
                                        JsonArray array = gui.getCommandExecutor();
                                        int index = 0;
                                        for (JsonElement element : array) {
                                            if (element.getAsJsonObject().get("slot").getAsInt() != slot) continue;
                                            ++index;
                                        }
                                        if (args.length >= 5) {
                                            if (!GuiTableCommand.isInteger(args[4])) {
                                                MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("DelayError", "\u00a7c\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c!"));
                                                return true;
                                            }
                                            int delay = Integer.parseInt(args[4]);
                                            if (args.length >= 6) {
                                                StringBuilder commandBuilder = new StringBuilder(args[5]);
                                                if (args.length >= 7) {
                                                    for (int i = 6; i < args.length; ++i) {
                                                        commandBuilder.append(" ").append(args[i]);
                                                    }
                                                }
                                                JsonObject object = new JsonObject();
                                                object.addProperty("command", commandBuilder.toString());
                                                object.addProperty("slot", (Number)slot);
                                                object.addProperty("index", (Number)index);
                                                object.addProperty("delay", (Number)delay);
                                                array.add((JsonElement)object);
                                                gui.setCommandExecutor(array);
                                                this.manager.saveToFile(gui);
                                                MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("CommandAddSuccess", "\u00a7a\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u0432 \u0441\u043b\u043e\u0442: \u00a7f%s"), String.valueOf(slot));
                                                break;
                                            }
                                            MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("CommandAddError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui command add <\u0441\u043b\u043e\u0442> <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430> \"<\u043a\u043e\u043c\u0430\u043d\u0434\u0430>\""));
                                            break;
                                        }
                                        MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("CommandAddError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui command add <\u0441\u043b\u043e\u0442> <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430> \"<\u043a\u043e\u043c\u0430\u043d\u0434\u0430>\""));
                                        break;
                                    }
                                    MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("InterfaceNotFound", "\u00a7c\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"));
                                    break;
                                }
                                MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("CommandAddError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui command add <\u0441\u043b\u043e\u0442> <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430> \"<\u043a\u043e\u043c\u0430\u043d\u0434\u0430>\""));
                                break;
                            }
                            MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("CommandAddError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui command add <\u0441\u043b\u043e\u0442> <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430> \"<\u043a\u043e\u043c\u0430\u043d\u0434\u0430>\""));
                            break;
                        }
                        case "delete": {
                            if (args.length >= 3) {
                                if (!GuiTableCommand.isInteger(args[2])) {
                                    MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("SlotsError", "\u00a7c\u0421\u043b\u043e\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c!"));
                                    return true;
                                }
                                int slot = Integer.parseInt(args[2]);
                                if (args.length >= 4) {
                                    String tableName = args[3];
                                    tableName = tableName.replaceAll("[^a-zA-Z0-9_-]", "_");
                                    Gui gui = this.manager.getGuiByFile(tableName + ".yml");
                                    File file = new File(this.dir, tableName + ".yml");
                                    if (file.exists()) {
                                        if (args.length >= 5) {
                                            if (!GuiTableCommand.isInteger(args[4])) {
                                                MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("IndexError", "\u00a7c\u0418\u043d\u0434\u0435\u043a\u0441 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c!"));
                                                return true;
                                            }
                                            int index = Integer.parseInt(args[4]);
                                            JsonArray array = gui.getCommandExecutor();
                                            boolean found = false;
                                            for (int i = 0; i < array.size(); ++i) {
                                                JsonObject o = array.get(i).getAsJsonObject();
                                                if (o.get("slot").getAsInt() != slot || o.get("index").getAsInt() != index) continue;
                                                array.remove(i);
                                                found = true;
                                                break;
                                            }
                                            if (found) {
                                                gui.setCommandExecutor(array);
                                                this.manager.saveToFile(gui);
                                                MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("CommandDeleteSuccess", "\u00a7a\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0430 \u0438\u0437 \u0441\u043b\u043e\u0442\u0430: \u00a7f%s"), String.valueOf(slot));
                                                break;
                                            }
                                            MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("CommandNotFound", "\u00a7c\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0432 \u0441\u043b\u043e\u0442\u0435 \u00a7f%s \u00a7a\u0434\u043b\u044f \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u00a7f%s \u00a7c\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!"), String.valueOf(slot), tableName);
                                            break;
                                        }
                                        MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("CommandDeleteError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui command delete <\u0441\u043b\u043e\u0442> <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430> <\u0438\u043d\u0434\u0435\u043a\u0441>"));
                                        break;
                                    }
                                    MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("InterfaceNotFound", "\u00a7c\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"));
                                    break;
                                }
                                MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("CommandDeleteError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui command delete <\u0441\u043b\u043e\u0442> <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430> <\u0438\u043d\u0434\u0435\u043a\u0441>"));
                                break;
                            }
                            MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("CommandDeleteError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui command delete <\u0441\u043b\u043e\u0442> <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430> <\u0438\u043d\u0434\u0435\u043a\u0441>"));
                            break;
                        }
                        case "get": {
                            if (args.length >= 3) {
                                if (!GuiTableCommand.isInteger(args[2])) {
                                    MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("SlotsError", "\u00a7c\u0421\u043b\u043e\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c!"));
                                    return true;
                                }
                                int slot = Integer.parseInt(args[2]);
                                if (args.length >= 4) {
                                    String tableName = args[3];
                                    tableName = tableName.replaceAll("[^a-zA-Z0-9_-]", "_");
                                    Gui gui = this.manager.getGuiByFile(tableName + ".yml");
                                    File file = new File(this.dir, tableName + ".yml");
                                    if (file.exists()) {
                                        if (args.length == 4) {
                                            MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("CommandListHeader", "\u00a7e################################"));
                                            MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("CommandListTitle", "\u00a7a\u0421\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043c\u0430\u043d\u0434 \u0434\u043b\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u00a7f%s \u00a7a\u0434\u043b\u044f \u0441\u043b\u043e\u0442\u0430 \u00a7f%s"), tableName, String.valueOf(slot));
                                            JsonArray array = gui.getCommandExecutor();
                                            for (JsonElement e : array) {
                                                JsonObject o = e.getAsJsonObject();
                                                if (o.get("slot").getAsInt() != slot) continue;
                                                MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("CommandListFormat", "\u00a7e%s \u00a7f- %s"), o.get("index").getAsString(), o.get("command").getAsString());
                                                MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("Delay", "\u00a76\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430: \u00a7f%s"), o.get("delay").getAsString());
                                            }
                                            MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("CommandListFooter", "\u00a7e################################"));
                                            return true;
                                        }
                                        if (args.length < 5) break block8;
                                        if (!GuiTableCommand.isInteger(args[4])) {
                                            MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("IndexError", "\u00a7c\u0418\u043d\u0434\u0435\u043a\u0441 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u043c!"));
                                            return true;
                                        }
                                        int index = Integer.parseInt(args[4]);
                                        JsonArray array = gui.getCommandExecutor();
                                        for (JsonElement e : array) {
                                            JsonObject o = e.getAsJsonObject();
                                            if (o.get("slot").getAsInt() != slot || o.get("index").getAsInt() != index) continue;
                                            MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("CommandValue", "\u00a7a\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0432 \u0441\u043b\u043e\u0442\u0435 \u00a7f%s \u00a7a\u0434\u043b\u044f \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u00a7f%s \u00a7a\u0438\u043c\u0435\u0435\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: \u00a7f%s"), String.valueOf(slot), tableName, o.get("command").getAsString());
                                            return true;
                                        }
                                        MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("CommandNotFound", "\u00a7c\u041a\u043e\u043c\u0430\u043d\u0434\u0430 \u0432 \u0441\u043b\u043e\u0442\u0435 \u00a7f%s \u00a7a\u0434\u043b\u044f \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430 \u00a7f%s \u00a7c\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!"), String.valueOf(slot), tableName);
                                        break;
                                    }
                                    MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("InterfaceNotFound", "\u00a7c\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"));
                                    break;
                                }
                                MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("CommandGetError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui command get <\u0441\u043b\u043e\u0442> <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430>"));
                                break;
                            }
                            MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("CommandGetError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui command get <\u0441\u043b\u043e\u0442> <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430>"));
                            break;
                        }
                        default: {
                            MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("CommandSetCommandError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui command [add/get/delete] <\u0441\u043b\u043e\u0442> <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430> \"<\u043a\u043e\u043c\u0430\u043d\u0434\u0430>\""));
                            break;
                        }
                    }
                    break;
                }
                MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("CommandSetCommandError", "\u00a7c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui command [add/get/delete] <\u0441\u043b\u043e\u0442> <\u0438\u043c\u044f_\u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430> \"<\u043a\u043e\u043c\u0430\u043d\u0434\u0430>\""));
                break;
            }
            case "reload": {
                Player player = (Player)sender;
                if (!player.hasPermission("customgui.reload")) {
                    MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("NoPermission", "\u00a7c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b"));
                    return true;
                }
                this.plugin.languageManager.reloadLanguage();
                MessageFormatter.sendMessage(player, CustomGuiReworked.languageMap.getOrDefault("ReloadSuccess", "\u00a7a\u041f\u0435\u0440\u0435\u0432\u043e\u0434\u044b \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b \u0443\u0441\u043f\u0435\u0448\u043d\u043e!"));
                break;
            }
            default: {
                MessageFormatter.sendMessage(sender, CustomGuiReworked.languageMap.getOrDefault("WrongUsage", "\u00a7c\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: \u00a7f/gui [create/open/delete/edit/reload/command]"));
            }
        }
        return true;
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

