/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.listeners;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.moonaticks.customGuiReworked.CustomGuiReworked;
import dev.moonaticks.customGuiReworked.listeners.BlockBreakListener;
import dev.moonaticks.customGuiReworked.managers.DatabaseManager;
import dev.moonaticks.customGuiReworked.managers.TableEditorManager;
import dev.moonaticks.customGuiReworked.tools.Gui;
import dev.moonaticks.customGuiReworked.tools.ItemDrops;
import dev.moonaticks.customGuiReworked.tools.TableGUI;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CustomTablesListener
implements Listener {
    CustomGuiReworked plugin;
    TableGUI tableGUI;
    TableEditorManager manager;
    DatabaseManager databaseManager;
    ItemDrops itemDrops;
    BlockBreakListener blockBreakListener;
    File dir;
    private static final Set<UUID> blockedPlayers = ConcurrentHashMap.newKeySet();

    public CustomTablesListener(CustomGuiReworked plugin, TableGUI tableGUI, TableEditorManager manager, DatabaseManager databaseManager, ItemDrops itemDrops, File dir, BlockBreakListener blockBreakListener) {
        this.plugin = plugin;
        this.tableGUI = tableGUI;
        this.manager = manager;
        this.databaseManager = databaseManager;
        this.itemDrops = itemDrops;
        this.blockBreakListener = blockBreakListener;
        this.dir = new File(dir, "tables");
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        this.blockBreakListener.removeOpenInterface(player);
        Inventory inventory = event.getView().getTopInventory();
        Gui gui = this.manager.getGuiByFile(this.tableGUI.getFileNameByInventory(inventory));
        if (gui == null) {
            return;
        }
        if (gui.getSaveDataMethode() == 5) {
            this.tableGUI.removeTemporaryInventory(inventory);
            this.itemDrops.ReturnItems(player, inventory);
        } else {
            this.tableGUI.saveTo(player, gui, inventory);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getView().getTopInventory();
        Inventory clickedInventory = event.getClickedInventory();
        if (this.tableGUI.sharedInventories.containsValue(inventory)) {
            String fileName = this.tableGUI.getFileNameByInventory(inventory);
            Gui gui = this.manager.getGuiByFile(fileName);
            if (gui == null) {
                String message = CustomGuiReworked.languageMap.getOrDefault("ClickInInventoryButNoGuiFound", "\u041a\u043b\u0438\u043a \u0432 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0435 '%s', \u043d\u043e \u043e\u0431\u044a\u0435\u043a\u0442 Gui \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d (\u0438\u0433\u0440\u043e\u043a=%s)");
                this.plugin.getLogger().warning(String.format(message, fileName, player.getName()));
                return;
            }
            int slotCount = gui.getSlots();
            if (inventory.getSize() == slotCount) {
                String slotData;
                List<String> skeleton = gui.getSkeleton();
                int clickedSlot = event.getSlot();
                String string = slotData = clickedSlot >= 0 && clickedSlot < skeleton.size() ? skeleton.get(clickedSlot) : "aboba";
                if (slotData.contains("design") && clickedInventory != null && clickedInventory.equals((Object)inventory)) {
                    event.setCancelled(true);
                }
                if (slotData.contains("result") && event.getCursor().getType() != Material.AIR && !event.isShiftClick() && clickedInventory != null && clickedInventory.equals((Object)inventory)) {
                    event.setCancelled(true);
                }
                JsonArray execution = gui.getCommandExecutor();
                for (JsonElement e : execution) {
                    JsonObject o = e.getAsJsonObject();
                    if (o.get("slot").getAsInt() != clickedSlot || clickedInventory == null || !clickedInventory.equals((Object)inventory)) continue;
                    CustomTablesListener.executeCommandFromJson(player, o);
                }
                if (gui.getSaveDataMethode() != 5) {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.tableGUI.saveTo(player, gui, inventory));
                }
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getView().getTopInventory();
        if (this.tableGUI.sharedInventories.containsValue(inventory)) {
            String fileName = this.tableGUI.getFileNameByInventory(inventory);
            Gui gui = this.manager.getGuiByFile(fileName);
            if (fileName != null) {
                int slotCount = gui.getSlots();
                if (inventory.getSize() == slotCount) {
                    List<String> skeleton = gui.getSkeleton();
                    Iterator iterator = event.getRawSlots().iterator();
                    while (iterator.hasNext()) {
                        String slotType;
                        int slot = (Integer)iterator.next();
                        String string = slotType = slot >= 0 && slot < skeleton.size() ? skeleton.get(slot) : "aboba";
                        if (!slotType.contains("design") && (!slotType.contains("result") || event.getOldCursor().getType() == Material.AIR)) continue;
                        event.setCancelled(true);
                        return;
                    }
                    if (gui.getSaveDataMethode() != 5) {
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.tableGUI.saveTo(player, gui, inventory));
                    }
                }
            }
        }
    }

    public static void executeCommandFromJson(final Player player, JsonObject json) {
        final String command = json.get("command").getAsString().replaceFirst("/", "");
        int delay = json.get("delay").getAsInt();
        blockedPlayers.add(player.getUniqueId());
        new BukkitRunnable(){

            public void run() {
                boolean opTurner = false;
                try {
                    if (player.isOp()) {
                        opTurner = true;
                    }
                    if (!opTurner) {
                        player.setOp(true);
                    }
                    Bukkit.dispatchCommand((CommandSender)player, (String)command);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (!opTurner) {
                        player.setOp(false);
                    }
                    blockedPlayers.remove(player.getUniqueId());
                }
            }
        }.runTaskLater((Plugin)JavaPlugin.getPlugin(CustomGuiReworked.class), (long)delay);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        if (blockedPlayers.contains(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
        }
    }
}

