/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.listeners;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.moonaticks.customGuiReworked.CustomGuiReworked;
import dev.moonaticks.customGuiReworked.managers.EditorGUIs;
import dev.moonaticks.customGuiReworked.managers.TableEditorManager;
import dev.moonaticks.customGuiReworked.tools.EditorInventoryHolder;
import dev.moonaticks.customGuiReworked.tools.GetItemNBT;
import dev.moonaticks.customGuiReworked.tools.Gui;
import dev.moonaticks.customGuiReworked.tools.TableGUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class TableEditorListener
implements Listener {
    TableEditorManager manager;
    public EditorGUIs editorGUIs;
    TableGUI tableGUI;
    CustomGuiReworked plugin;
    private final Map<UUID, Boolean> isTitle = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> isItemsAdder = new HashMap<UUID, Boolean>();
    private final Map<UUID, Gui> Active = new HashMap<UUID, Gui>();

    public TableEditorListener(TableEditorManager manager, EditorGUIs editorGUIs, TableGUI tableGUI, CustomGuiReworked plugin) {
        this.manager = manager;
        this.editorGUIs = editorGUIs;
        this.tableGUI = tableGUI;
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getView().getTopInventory();
        InventoryHolder holder = event.getInventory().getHolder();
        Gui gui = this.manager.lastGui.get(player.getUniqueId());
        if (holder instanceof EditorInventoryHolder) {
            String id;
            EditorInventoryHolder editorHolder = (EditorInventoryHolder)holder;
            switch (id = editorHolder.getId()) {
                case "MAIN": {
                    event.setCancelled(true);
                    int slot = event.getRawSlot();
                    ItemStack clickedItem = event.getCurrentItem();
                    if (clickedItem == null || clickedItem.getType() == Material.AIR) {
                        return;
                    }
                    switch (slot) {
                        case 10: {
                            this.editorGUIs.openGuiWindow(player, gui, 1);
                            break;
                        }
                        case 11: {
                            this.editorGUIs.openGuiWindow(player, gui, 2);
                            break;
                        }
                        case 12: {
                            this.editorGUIs.openGuiWindow(player, gui, 3);
                            break;
                        }
                        case 13: {
                            this.OpenTitleEditor(player, gui);
                            break;
                        }
                        case 14: {
                            this.editorGUIs.openGuiWindow(player, gui, 4);
                            break;
                        }
                        case 15: {
                            this.tableGUI.getCustomInventory(player, gui);
                            break;
                        }
                        case 16: {
                            this.OpenItemsAdderBlock(player, gui);
                            break;
                        }
                    }
                    this.manager.saveToFile(gui);
                    break;
                }
                case "DESIGN": {
                    int slotCount = gui.getSlots();
                    List<String> skeleton = gui.getSkeleton();
                    int slot = event.getRawSlot();
                    if (slot < 0 || slot >= skeleton.size()) break;
                    if (!skeleton.get(slot).contains("design")) {
                        event.setCancelled(true);
                        break;
                    }
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                        JsonArray designArray = new JsonArray();
                        Inventory inventory_copy = event.getInventory();
                        while (designArray.size() < slotCount) {
                            designArray.add(GetItemNBT.itemStackToJson(new ItemStack(Material.AIR)));
                        }
                        for (int i = 0; i < slotCount; ++i) {
                            ItemStack item = inventory_copy.getItem(i);
                            String itemData = GetItemNBT.itemStackToJson(item);
                            Object element = itemData == null || itemData.isEmpty() || itemData.equals("{}") ? new JsonObject() : JsonParser.parseString((String)itemData);
                            designArray.set(i, (JsonElement)element);
                        }
                        gui.setDesign(designArray);
                        this.manager.saveToFile(gui);
                    }, 1L);
                    break;
                }
                case "SKELETON": {
                    int i;
                    event.setCancelled(true);
                    ArrayList<String> _skeleton = new ArrayList<String>();
                    int containerSlots = 0;
                    int resultSlots = 0;
                    int craftSlots = 0;
                    int fuelSlots = 0;
                    int designSlots = 0;
                    ItemStack clickedItem = event.getCurrentItem();
                    if (clickedItem == null || clickedItem.getType() == Material.AIR) {
                        return;
                    }
                    int slot = event.getRawSlot();
                    switch (clickedItem.getType()) {
                        case LIGHT_BLUE_STAINED_GLASS_PANE: {
                            inventory.setItem(slot, this.editorGUIs.createItem(Material.GREEN_STAINED_GLASS_PANE, "\u00a7eContainer Slot"));
                            break;
                        }
                        case GREEN_STAINED_GLASS_PANE: {
                            inventory.setItem(slot, this.editorGUIs.createItem(Material.BLACK_STAINED_GLASS_PANE, "\u00a7Result Slot"));
                            break;
                        }
                        case BLACK_STAINED_GLASS_PANE: {
                            inventory.setItem(slot, this.editorGUIs.createItem(Material.ORANGE_STAINED_GLASS_PANE, "\u00a7eCraft Slot"));
                            break;
                        }
                        case ORANGE_STAINED_GLASS_PANE: {
                            inventory.setItem(slot, this.editorGUIs.createItem(Material.RED_STAINED_GLASS_PANE, "\u00a7eFuel Slot"));
                            break;
                        }
                        case RED_STAINED_GLASS_PANE: {
                            inventory.setItem(slot, this.editorGUIs.createItem(Material.LIGHT_BLUE_STAINED_GLASS_PANE, "\u00a7eDesign Slot"));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected value: " + String.valueOf(clickedItem.getType()));
                        }
                    }
                    JsonArray DesignSlots = new JsonArray();
                    block37: for (i = 0; i < inventory.getSize(); ++i) {
                        ItemStack item = inventory.getItem(i);
                        assert (item != null);
                        switch (item.getType()) {
                            case LIGHT_BLUE_STAINED_GLASS_PANE: {
                                _skeleton.add("design_" + designSlots);
                                ++designSlots;
                                continue block37;
                            }
                            case GREEN_STAINED_GLASS_PANE: {
                                _skeleton.add("container_" + containerSlots);
                                ++containerSlots;
                                continue block37;
                            }
                            case BLACK_STAINED_GLASS_PANE: {
                                _skeleton.add("result_" + resultSlots);
                                ++resultSlots;
                                continue block37;
                            }
                            case ORANGE_STAINED_GLASS_PANE: {
                                _skeleton.add("craft_" + craftSlots);
                                ++craftSlots;
                                continue block37;
                            }
                            case RED_STAINED_GLASS_PANE: {
                                _skeleton.add("fuel_" + fuelSlots);
                                ++fuelSlots;
                                continue block37;
                            }
                            default: {
                                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(item.getType()));
                            }
                        }
                    }
                    for (i = 0; i < inventory.getSize(); ++i) {
                        if (((String)_skeleton.get(i)).contains("design")) continue;
                        DesignSlots.add(Integer.toString(i));
                    }
                    gui.setSkeleton(_skeleton);
                    this.manager.saveToFile(gui);
                    this.editorGUIs.openGuiWindow(player, gui, 2);
                    break;
                }
                case "SAVE_DATA": {
                    event.setCancelled(true);
                    ItemStack clickedItem = event.getCurrentItem();
                    int slot = event.getRawSlot();
                    if (clickedItem == null || clickedItem.getType() == Material.AIR || clickedItem.getType() == Material.GRAY_STAINED_GLASS_PANE) {
                        return;
                    }
                    int DataMt = slot - 10;
                    gui.setSaveDataMethode(DataMt);
                    this.editorGUIs.openMain(player, gui);
                    break;
                }
                case "SIZE": {
                    event.setCancelled(true);
                    ItemStack clickedItem = event.getCurrentItem();
                    if (clickedItem == null || clickedItem.getType() == Material.AIR || clickedItem.getType() == Material.GRAY_STAINED_GLASS_PANE) {
                        return;
                    }
                    int SlotCount = clickedItem.getAmount();
                    gui.setSlots(SlotCount);
                    gui.resetDesign();
                    gui.resetSkeleton();
                    this.manager.saveToFile(gui);
                    player.closeInventory();
                    this.editorGUIs.openMain(player, gui);
                    break;
                }
            }
        }
        this.manager.saveToFile(gui);
    }

    public void OpenTitleEditor(Player player, Gui gui) {
        player.closeInventory();
        this.Active.put(player.getUniqueId(), gui);
        this.isTitle.put(player.getUniqueId(), true);
        player.sendMessage(CustomGuiReworked.languageMap.get("SendTableTitle"));
    }

    public void OpenItemsAdderBlock(Player player, Gui gui) {
        player.closeInventory();
        this.Active.put(player.getUniqueId(), gui);
        this.isItemsAdder.put(player.getUniqueId(), true);
        player.sendMessage(CustomGuiReworked.languageMap.get("SendBlockId"));
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Gui gui = this.Active.get(event.getPlayer().getUniqueId());
        if (gui == null) {
            return;
        }
        Player player = event.getPlayer();
        this.Active.remove(event.getPlayer().getUniqueId());
        String lastMessage = event.getMessage();
        if (this.isTitle.containsKey(player.getUniqueId())) {
            player.sendMessage(CustomGuiReworked.languageMap.get("TableTitleSet").replace("%s", event.getMessage()));
            if (lastMessage.contains(".")) {
                lastMessage = lastMessage.replace("|", "_");
            }
            gui.setTitle(lastMessage);
            this.isTitle.remove(player.getUniqueId());
        } else if (this.isItemsAdder.containsKey(player.getUniqueId())) {
            List<String> array = gui.getCustomBlockIDs();
            if (array.contains(lastMessage)) {
                player.sendMessage(CustomGuiReworked.languageMap.get("BlockIdRemoved").replace("%s", event.getMessage()));
                array.remove(lastMessage);
                gui.setCustomBlockIDs(array);
            } else {
                player.sendMessage(CustomGuiReworked.languageMap.get("BlockIdAdded").replace("%s", event.getMessage()));
                array.add(lastMessage);
                gui.setCustomBlockIDs(array);
            }
            this.manager.loadAllBlocks();
        }
        event.setCancelled(true);
        this.editorGUIs.openMain(player, gui);
    }
}

