/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.managers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import dev.moonaticks.customGuiReworked.CustomGuiReworked;
import dev.moonaticks.customGuiReworked.tools.ItemDrops;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class DatabaseManager {
    private final File playersFolder;
    private final File globalsFolder;
    private final File teamsFolder;
    private final ItemDrops itemDrops;
    CustomGuiReworked plugin;

    public DatabaseManager(File pluginDataFolder, ItemDrops itemDrops, CustomGuiReworked plugin) {
        this.itemDrops = itemDrops;
        this.plugin = plugin;
        File dataFolder = new File(pluginDataFolder, "data");
        this.playersFolder = new File(dataFolder, "players");
        this.globalsFolder = new File(dataFolder, "globals");
        this.teamsFolder = new File(dataFolder, "teams");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        if (!this.playersFolder.exists()) {
            this.playersFolder.mkdirs();
        }
        if (!this.globalsFolder.exists()) {
            this.globalsFolder.mkdirs();
        }
        if (!this.teamsFolder.exists()) {
            this.teamsFolder.mkdirs();
        }
    }

    public void saveToBlock(Location loc, String tableName, JsonArray storage) {
        if (storage == null) {
            this.plugin.getLogger().warning(CustomGuiReworked.languageMap.getOrDefault("FailedToSaveNullStorage", "Failed to save null storage to block!"));
            return;
        }
        if (loc == null) {
            this.plugin.getLogger().warning(CustomGuiReworked.languageMap.getOrDefault("PlayerDidNotClickBlock", "\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u043a\u043b\u0438\u043a\u043d\u0443\u043b \u043f\u043e \u0431\u043b\u043e\u043a\u0443!"));
            return;
        }
        World world = loc.getWorld();
        if (world == null) {
            this.plugin.getLogger().warning(CustomGuiReworked.languageMap.getOrDefault("WorldNotFoundForBlock", "\u041c\u0438\u0440 \u0434\u043b\u044f \u0431\u043b\u043e\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"));
            return;
        }
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        int xRegion = x >> 4;
        int zRegion = z >> 4;
        File blocksFolder = this.getWorldBlocksFolder(world);
        File regionFolder = new File(blocksFolder, xRegion + "_" + zRegion + ".json");
        JsonObject regionData = this.loadRegionData(regionFolder);
        JsonObject blockData = new JsonObject();
        blockData.addProperty("table", tableName);
        blockData.add("storage", (JsonElement)storage);
        String key = world.getName() + ":" + x + "," + y + "," + z;
        regionData.add(key, (JsonElement)blockData);
        try {
            this.saveRegionData(regionFolder, regionData);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(CustomGuiReworked.languageMap.getOrDefault("ErrorSavingDataToBlock", "Error saving data to block: ") + e.getMessage());
            e.printStackTrace();
        }
    }

    public void saveToPlayer(Player player, String tableName, JsonArray storage) {
        if (storage == null) {
            this.plugin.getLogger().warning(CustomGuiReworked.languageMap.getOrDefault("AttemptToSaveNullStorageForPlayer", "\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c null storage \u0434\u043b\u044f \u0438\u0433\u0440\u043e\u043a\u0430!"));
            return;
        }
        File playerFile = new File(this.playersFolder, player.getName() + "_" + tableName);
        try {
            this.saveDataToFile(playerFile, storage);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(CustomGuiReworked.languageMap.getOrDefault("ErrorSavingPlayerData", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0433\u0440\u043e\u043a\u0430: ") + e.getMessage());
            e.printStackTrace();
        }
    }

    public void saveGlobally(String tableName, JsonArray storage) {
        if (storage == null) {
            this.plugin.getLogger().warning(CustomGuiReworked.languageMap.getOrDefault("AttemptToSaveNullStorageGlobally", "\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c null storage \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e!"));
            return;
        }
        File globalFile = new File(this.globalsFolder, tableName);
        try {
            this.saveDataToFile(globalFile, storage);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(CustomGuiReworked.languageMap.getOrDefault("ErrorSavingGlobalData", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u043c \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445: ") + e.getMessage());
            e.printStackTrace();
        }
    }

    public void saveToTeam(Player player, String tableName, JsonArray storage) {
        if (storage == null) {
            this.plugin.getLogger().warning(CustomGuiReworked.languageMap.getOrDefault("AttemptToSaveNullStorageForTeam", "\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c null storage \u0434\u043b\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u044b!"));
            return;
        }
        String team = player.getScoreboard().getPlayerTeam((OfflinePlayer)player) != null ? Objects.requireNonNull(player.getScoreboard().getPlayerTeam((OfflinePlayer)player)).getName() : "defaultTeam_GUARD265";
        File teamFile = new File(this.teamsFolder, team + "_" + tableName);
        try {
            this.saveDataToFile(teamFile, storage);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(CustomGuiReworked.languageMap.getOrDefault("ErrorSavingTeamData", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: ") + e.getMessage());
            e.printStackTrace();
        }
    }

    public JsonArray loadFromBlock(Location loc, String tableName) {
        try {
            JsonObject blockData;
            String key;
            if (loc == null) {
                this.plugin.getLogger().warning(CustomGuiReworked.languageMap.getOrDefault("PlayerDidNotClickBlock", "\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u043a\u043b\u0438\u043a\u043d\u0443\u043b \u043f\u043e \u0431\u043b\u043e\u043a\u0443!"));
                return new JsonArray();
            }
            World world = loc.getWorld();
            if (world == null) {
                this.plugin.getLogger().warning(CustomGuiReworked.languageMap.getOrDefault("WorldNotFoundForBlock", "\u041c\u0438\u0440 \u0434\u043b\u044f \u0431\u043b\u043e\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"));
                return new JsonArray();
            }
            int x = loc.getBlockX();
            int y = loc.getBlockY();
            int z = loc.getBlockZ();
            int xRegion = x >> 4;
            int zRegion = z >> 4;
            File blocksFolder = this.getWorldBlocksFolder(world);
            File regionFile = new File(blocksFolder, xRegion + "_" + zRegion + ".json");
            JsonObject regionData = this.loadRegionData(regionFile);
            if (regionData.has(key = world.getName() + ":" + x + "," + y + "," + z) && (blockData = regionData.getAsJsonObject(key)).get("table").getAsString().equals(tableName)) {
                return blockData.getAsJsonArray("storage");
            }
            return new JsonArray();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(CustomGuiReworked.languageMap.getOrDefault("ErrorLoadingBlockData", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0431\u043b\u043e\u043a\u0430: ") + e.getMessage());
            e.printStackTrace();
            return new JsonArray();
        }
    }

    public JsonArray loadFromPlayer(Player player, String tableName) {
        try {
            File playerFile = new File(this.playersFolder, player.getName() + "_" + tableName);
            return this.loadDataFromFile(playerFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(CustomGuiReworked.languageMap.getOrDefault("ErrorLoadingPlayerData", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0433\u0440\u043e\u043a\u0430: ") + e.getMessage());
            e.printStackTrace();
            return new JsonArray();
        }
    }

    public JsonArray loadGlobally(String tableName) {
        try {
            File globalFile = new File(this.globalsFolder, tableName);
            return this.loadDataFromFile(globalFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(CustomGuiReworked.languageMap.getOrDefault("ErrorLoadingGlobalData", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445: ") + e.getMessage());
            e.printStackTrace();
            return new JsonArray();
        }
    }

    public JsonArray loadFromTeam(Player player, String tableName) {
        try {
            String team = player.getScoreboard().getPlayerTeam((OfflinePlayer)player) != null ? Objects.requireNonNull(player.getScoreboard().getPlayerTeam((OfflinePlayer)player)).getName() : "defaultTeam_GUARD265";
            File teamFile = new File(this.teamsFolder, team + "_" + tableName);
            return this.loadDataFromFile(teamFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(CustomGuiReworked.languageMap.getOrDefault("ErrorLoadingTeamData", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u043c\u0430\u043d\u0434\u044b: ") + e.getMessage());
            e.printStackTrace();
            return new JsonArray();
        }
    }

    private void saveDataToFile(File file, JsonArray data) {
        try {
            if (data == null || data.size() == 0) {
                if (file.exists()) {
                    file.delete();
                }
                return;
            }
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                writer.write(data.toString());
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe(CustomGuiReworked.languageMap.getOrDefault("ErrorSavingDataToFile", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0444\u0430\u0439\u043b: ") + e.getMessage());
            e.printStackTrace();
        }
    }

    private JsonArray loadDataFromFile(File file) {
        try {
            if (!file.exists()) {
                return new JsonArray();
            }
            String content = Files.readString(file.toPath());
            if (content == null || content.trim().isEmpty()) {
                return new JsonArray();
            }
            JsonElement jsonElement = JsonParser.parseString((String)content);
            if (jsonElement.isJsonArray()) {
                return jsonElement.getAsJsonArray();
            }
            throw new IllegalArgumentException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0444\u0430\u0439\u043b\u0435: " + file.getName());
        }
        catch (JsonSyntaxException | IOException e) {
            this.plugin.getLogger().severe(CustomGuiReworked.languageMap.getOrDefault("ErrorLoadingDataFromFile", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430: ") + e.getMessage());
            e.printStackTrace();
            return new JsonArray();
        }
    }

    private JsonObject loadRegionData(File regionFile) {
        try {
            if (!regionFile.exists()) {
                return new JsonObject();
            }
            String content = Files.readString(regionFile.toPath());
            if (content == null || content.trim().isEmpty()) {
                return new JsonObject();
            }
            JsonElement jsonElement = JsonParser.parseString((String)content);
            if (!jsonElement.isJsonObject()) {
                this.plugin.getLogger().warning(CustomGuiReworked.languageMap.getOrDefault("ExpectedJsonObjectButGotOtherType", "\u041e\u0448\u0438\u0431\u043a\u0430: \u041e\u0436\u0438\u0434\u0430\u043b\u0441\u044f JSON-\u043e\u0431\u044a\u0435\u043a\u0442, \u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u0434\u0440\u0443\u0433\u043e\u0439 \u0442\u0438\u043f \u0432 \u0444\u0430\u0439\u043b\u0435 ") + regionFile.getName());
                return new JsonObject();
            }
            return jsonElement.getAsJsonObject();
        }
        catch (JsonSyntaxException | IOException e) {
            this.plugin.getLogger().severe(CustomGuiReworked.languageMap.getOrDefault("ErrorLoadingRegionData", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0440\u0435\u0433\u0438\u043e\u043d\u0430: ") + e.getMessage());
            e.printStackTrace();
            return new JsonObject();
        }
    }

    private File getWorldBlocksFolder(World world) {
        File worldDataFolder = new File(world.getWorldFolder(), "CustomGuiReworked");
        File blocksFolder = new File(worldDataFolder, "blocks");
        if (!blocksFolder.exists()) {
            blocksFolder.mkdirs();
        }
        return blocksFolder;
    }

    private void saveRegionData(File regionFile, JsonObject data) {
        try {
            if (data == null || data.size() == 0) {
                if (regionFile.exists()) {
                    regionFile.delete();
                }
                return;
            }
            File parentFolder = regionFile.getParentFile();
            if (parentFolder != null && !parentFolder.exists()) {
                parentFolder.mkdirs();
            }
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(regionFile), StandardCharsets.UTF_8));){
                Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                writer.write("{\n");
                int count = 0;
                int total = data.size();
                for (Map.Entry entry : data.entrySet()) {
                    writer.write("  \"" + (String)entry.getKey() + "\": " + gson.toJson((JsonElement)entry.getValue()));
                    if (++count < total) {
                        writer.write(",");
                    }
                    writer.write("\n");
                }
                writer.write("}");
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe(CustomGuiReworked.languageMap.getOrDefault("ErrorSavingRegionData", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0440\u0435\u0433\u0438\u043e\u043d\u0430: ") + e.getMessage());
            e.printStackTrace();
        }
    }

    public void removeBlockData(Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            this.plugin.getLogger().warning(CustomGuiReworked.languageMap.getOrDefault("WorldNotFoundForBlock", "\u041c\u0438\u0440 \u0434\u043b\u044f \u0431\u043b\u043e\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!"));
            return;
        }
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        int xRegion = x >> 4;
        int zRegion = z >> 4;
        File blocksFolder = this.getWorldBlocksFolder(world);
        File regionFile = new File(blocksFolder, xRegion + "_" + zRegion + ".json");
        JsonObject regionData = this.loadRegionData(regionFile);
        String key = world.getName() + ":" + x + "," + y + "," + z;
        try {
            if (regionData.has(key)) {
                JsonArray storage = regionData.getAsJsonObject(key).getAsJsonArray("storage");
                this.itemDrops.dropItems(loc, storage);
                regionData.remove(key);
                this.saveRegionData(regionFile, regionData);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(CustomGuiReworked.languageMap.getOrDefault("ErrorDeletingBlockData", "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0431\u043b\u043e\u043a\u0430: ") + e.getMessage());
            e.printStackTrace();
        }
    }
}

