/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.tools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.tr7zw.nbtapi.NBTContainer;
import de.tr7zw.nbtapi.NBTItem;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GetItemNBT {
    public static String itemStackToJson(ItemStack item) {
        if (item == null || item.getType() == Material.AIR || item.getAmount() == 0) {
            return null;
        }
        NBTItem nbtItem = new NBTItem(item);
        nbtItem.setItemStack("itemStack", item);
        return nbtItem.toString();
    }

    public static ItemStack jsonToItemStack(String json) {
        if (json == null || json.isEmpty() || json.equals("{}")) {
            return new ItemStack(Material.AIR);
        }
        try {
            if (!json.trim().startsWith("{")) {
                throw new IllegalArgumentException("Invalid JSON: Expected '{' at position 0");
            }
            NBTContainer container = new NBTContainer(json = GetItemNBT.fixJsonNumbers(json));
            ItemStack item = container.getItemStack("itemStack");
            if (item == null) {
                throw new IllegalArgumentException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c ItemStack \u0438\u0437 JSON: " + json);
            }
            return item;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new ItemStack(Material.AIR);
        }
    }

    public static String fixJsonNumbers(String json) {
        json = json.replaceAll("\"(-?\\d+)b\"", "$1");
        json = json.replaceAll("\"(-?\\d+\\.\\d+)f\"", "$1");
        json = json.replaceAll("\"(-?\\d+\\.\\d+)d\"", "$1");
        return json;
    }

    public static JsonArray inventoryItemsToJsonArray(Inventory inventory, List<String> skeleton) {
        JsonArray array = new JsonArray();
        for (int slot = 0; slot < inventory.getSize(); ++slot) {
            if (!skeleton.get(slot).contains("design")) {
                ItemStack item = inventory.getItem(slot);
                String itemData = GetItemNBT.itemStackToJson(item);
                Object element = itemData == null || itemData.isEmpty() || itemData.equals("{}") ? new JsonObject() : JsonParser.parseString((String)itemData);
                array.add((JsonElement)element);
                continue;
            }
            array.add((JsonElement)new JsonObject());
        }
        return array;
    }

    public static Inventory jsonArrayToInventory(JsonArray array, Inventory inventory, List<String> skeleton) {
        if (array == null || skeleton == null || inventory == null) {
            return inventory;
        }
        for (int slot = 0; slot < array.size(); ++slot) {
            JsonElement itemJson;
            if (skeleton.get(slot).contains("design") || (itemJson = array.get(slot)) == null || itemJson.isJsonNull()) continue;
            ItemStack item = GetItemNBT.jsonToItemStack(itemJson.toString());
            if (item != null) {
                inventory.setItem(slot, item);
                continue;
            }
            System.out.println("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0438\u0437 JSON: " + String.valueOf(itemJson));
        }
        return inventory;
    }
}

