/*
 * Decompiled with CFR 0.152.
 */
package dev.moonaticks.customGuiReworked.tools;

import com.google.gson.JsonArray;
import dev.moonaticks.customGuiReworked.CustomGuiReworked;
import dev.moonaticks.customGuiReworked.managers.DatabaseManager;
import dev.moonaticks.customGuiReworked.managers.TableEditorManager;
import dev.moonaticks.customGuiReworked.tools.GetItemNBT;
import dev.moonaticks.customGuiReworked.tools.Gui;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class TableGUI {
    TableEditorManager manager;
    CustomGuiReworked plugin;
    DatabaseManager databaseManager;
    public final Map<String, Inventory> sharedInventories = new HashMap<String, Inventory>();
    private final Map<Inventory, String> reverseLookupMap = new HashMap<Inventory, String>();

    public void addInventory(String key, Inventory inventory) {
        this.sharedInventories.put(key, inventory);
        this.reverseLookupMap.put(inventory, key);
    }

    public void removeInventory(String key) {
        Inventory inventory = this.sharedInventories.remove(key);
        this.reverseLookupMap.remove(inventory);
    }

    public String getKeyByInventory(Inventory inventory) {
        return this.reverseLookupMap.get(inventory);
    }

    public TableGUI(CustomGuiReworked plugin, TableEditorManager manager, DatabaseManager databaseManager) {
        this.plugin = plugin;
        this.manager = manager;
        this.databaseManager = databaseManager;
    }

    public void getCustomInventory(Player player, Gui gui, Location blockLocation) {
        int saveDataMethod = gui.getSaveDataMethode();
        switch (saveDataMethod) {
            case 1: {
                this.openBlockInventory(player, gui.getFile(), blockLocation);
                break;
            }
            case 2: {
                this.openPersonalInventory(player, gui.getFile());
                break;
            }
            case 3: {
                this.openGlobalInventory(player, gui.getFile());
                break;
            }
            case 4: {
                this.openTeamInventory(player, gui.getFile());
                break;
            }
            case 5: {
                this.openTemporaryInventory(player, gui.getFile());
                break;
            }
            default: {
                String message = CustomGuiReworked.languageMap.getOrDefault("InvalidSaveDataMethod", "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043c\u0435\u0442\u043e\u0434 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445: %s");
                throw new IllegalArgumentException(String.format(message, saveDataMethod));
            }
        }
    }

    public void getCustomInventory(Player player, Gui gui) {
        int saveDataMethod = gui.getSaveDataMethode();
        switch (saveDataMethod) {
            case 1: {
                player.sendMessage(CustomGuiReworked.languageMap.getOrDefault("BlockInventoryError", "&c\u0418\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u044c \u0431\u043b\u043e\u043a\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u043a\u0440\u044b\u0442 \u043a\u043e\u043c\u0430\u043d\u0434\u043e\u0439"));
                break;
            }
            case 2: {
                this.openPersonalInventory(player, gui.getFile());
                break;
            }
            case 3: {
                this.openGlobalInventory(player, gui.getFile());
                break;
            }
            case 4: {
                this.openTeamInventory(player, gui.getFile());
                break;
            }
            case 5: {
                this.openTemporaryInventory(player, gui.getFile());
                break;
            }
            default: {
                String message = CustomGuiReworked.languageMap.getOrDefault("InvalidSaveDataMethod", "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u043c\u0435\u0442\u043e\u0434 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445: %s");
                throw new IllegalArgumentException(String.format(message, saveDataMethod));
            }
        }
    }

    public Inventory openBlockInventory(Player player, String tableName, Location blockLocation) {
        if (blockLocation == null) {
            player.sendMessage(CustomGuiReworked.languageMap.getOrDefault("NoBlockSelected", "&c\u0412\u044b \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043b\u0438 \u0431\u043b\u043e\u043a!"));
            return null;
        }
        String key = "block|" + blockLocation.getWorld().getName() + "|" + blockLocation.getBlockX() + "|" + blockLocation.getBlockY() + "|" + blockLocation.getBlockZ() + "|" + tableName;
        Inventory inventory = this.sharedInventories.computeIfAbsent(key, k -> {
            JsonArray storage = this.databaseManager.loadFromBlock(blockLocation, tableName);
            Inventory inventory1 = this.createInventory(player, storage, tableName);
            this.reverseLookupMap.put(inventory1, key);
            return inventory1;
        });
        player.openInventory(inventory);
        return inventory;
    }

    public Inventory openPersonalInventory(Player player, String tableName) {
        String key = "personal|" + String.valueOf(player.getUniqueId()) + "|" + tableName;
        Inventory inventory = this.sharedInventories.computeIfAbsent(key, k -> {
            JsonArray storage = this.databaseManager.loadFromPlayer(player, tableName);
            Inventory inventory1 = this.createInventory(player, storage, tableName);
            this.reverseLookupMap.put(inventory1, key);
            return inventory1;
        });
        player.openInventory(inventory);
        return inventory;
    }

    public Inventory openPersonalInventory(Player player, String tableName, Player target) {
        String key = "personal|" + String.valueOf(target.getUniqueId()) + "|" + tableName;
        Inventory inventory = this.sharedInventories.computeIfAbsent(key, k -> {
            JsonArray storage = this.databaseManager.loadFromPlayer(player, tableName);
            Inventory inventory1 = this.createInventory(target, storage, tableName);
            this.reverseLookupMap.put(inventory1, key);
            return inventory1;
        });
        player.openInventory(inventory);
        return inventory;
    }

    public Inventory openGlobalInventory(Player player, String tableName) {
        String key = "global|" + tableName;
        Inventory inventory = this.sharedInventories.computeIfAbsent(key, k -> {
            JsonArray storage = this.databaseManager.loadGlobally(tableName);
            Inventory inventory1 = this.createInventory(player, storage, tableName);
            this.reverseLookupMap.put(inventory1, key);
            return inventory1;
        });
        player.openInventory(inventory);
        return inventory;
    }

    public Inventory openTeamInventory(Player player, String tableName) {
        String team = player.getScoreboard().getPlayerTeam((OfflinePlayer)player) != null ? Objects.requireNonNull(player.getScoreboard().getPlayerTeam((OfflinePlayer)player)).getName() : "defaultTeam_GUARD265";
        String key = "team|" + team + "|" + tableName;
        Inventory inventory = this.sharedInventories.computeIfAbsent(key, k -> {
            JsonArray storage = this.databaseManager.loadFromTeam(player, tableName);
            Inventory inventory1 = this.createInventory(player, storage, tableName);
            this.reverseLookupMap.put(inventory1, key);
            return inventory1;
        });
        player.openInventory(inventory);
        return inventory;
    }

    public Inventory openTeamInventory(Player player, String tableName, String team) {
        String key = "team|" + team + "|" + tableName;
        Inventory inventory = this.sharedInventories.computeIfAbsent(key, k -> {
            JsonArray storage = this.databaseManager.loadFromTeam(player, team);
            Inventory inventory1 = this.createInventory(player, storage, tableName);
            this.reverseLookupMap.put(inventory1, key);
            return inventory1;
        });
        player.openInventory(inventory);
        return inventory;
    }

    public Inventory openTemporaryInventory(Player player, String tableName) {
        Inventory inventory = this.createInventory(player, new JsonArray(), tableName);
        String key = "temporary|" + String.valueOf(player.getUniqueId()) + "|" + System.currentTimeMillis() + "|" + tableName;
        this.sharedInventories.put(key, inventory);
        this.reverseLookupMap.put(inventory, key);
        player.openInventory(inventory);
        return inventory;
    }

    public Inventory createOrGetBlockInventory(String tableName, Location blockLocation) {
        if (blockLocation == null) {
            return null;
        }
        String key = "block|" + blockLocation.getWorld().getName() + "|" + blockLocation.getBlockX() + "|" + blockLocation.getBlockY() + "|" + blockLocation.getBlockZ() + "|" + tableName;
        return this.sharedInventories.computeIfAbsent(key, k -> {
            JsonArray storage = this.databaseManager.loadFromBlock(blockLocation, tableName);
            Inventory inventory1 = this.createInventory(null, storage, tableName);
            this.reverseLookupMap.put(inventory1, key);
            return inventory1;
        });
    }

    public Inventory createOrGetPersonalInventory(Player player, String tableName) {
        String key = "personal|" + String.valueOf(player.getUniqueId()) + "|" + tableName;
        return this.sharedInventories.computeIfAbsent(key, k -> {
            JsonArray storage = this.databaseManager.loadFromPlayer(player, tableName);
            Inventory inventory1 = this.createInventory(player, storage, tableName);
            this.reverseLookupMap.put(inventory1, key);
            return inventory1;
        });
    }

    public Inventory createOrGetGlobalInventory(String tableName) {
        String key = "global|" + tableName;
        return this.sharedInventories.computeIfAbsent(key, k -> {
            JsonArray storage = this.databaseManager.loadGlobally(tableName);
            Inventory inventory1 = this.createInventory(null, storage, tableName);
            this.reverseLookupMap.put(inventory1, key);
            return inventory1;
        });
    }

    public Inventory createOrGetTeamInventory(Player player, String tableName) {
        String team = player.getScoreboard().getPlayerTeam((OfflinePlayer)player) != null ? Objects.requireNonNull(player.getScoreboard().getPlayerTeam((OfflinePlayer)player)).getName() : "defaultTeam_GUARD265";
        String key = "team|" + team + "|" + tableName;
        return this.sharedInventories.computeIfAbsent(key, k -> {
            JsonArray storage = this.databaseManager.loadFromTeam(player, tableName);
            Inventory inventory1 = this.createInventory(player, storage, tableName);
            this.reverseLookupMap.put(inventory1, key);
            return inventory1;
        });
    }

    public Inventory createOrGetTeamInventory(String tableName, String team) {
        String key = "team|" + team + "|" + tableName;
        return this.sharedInventories.computeIfAbsent(key, k -> {
            JsonArray storage = this.databaseManager.loadFromTeam(null, tableName);
            Inventory inventory1 = this.createInventory(null, storage, tableName);
            this.reverseLookupMap.put(inventory1, key);
            return inventory1;
        });
    }

    public void removeTemporaryInventory(Inventory inventory) {
        if (inventory == null) {
            return;
        }
        this.sharedInventories.entrySet().removeIf(entry -> ((Inventory)entry.getValue()).equals((Object)inventory));
        this.reverseLookupMap.remove(inventory);
    }

    private Inventory createInventory(Player player, JsonArray storage, String tableName) {
        Gui gui = this.manager.getGuiByFile(tableName);
        int slotCount = gui.getSlots();
        String title = gui.getTitle();
        List<String> skeleton = gui.getSkeleton();
        Inventory inventory = Bukkit.createInventory((InventoryHolder)player, (int)slotCount, (Component)Component.text((String)title));
        inventory = gui.loadDesign(player, inventory);
        return GetItemNBT.jsonArrayToInventory(storage, inventory, skeleton);
    }

    public void removeInventoryByLocation(Location location) {
        if (location == null) {
            this.plugin.getLogger().warning(CustomGuiReworked.languageMap.getOrDefault("LocationCannotBeNull", "\u041b\u043e\u043a\u0430\u0446\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null!"));
            return;
        }
        String locationKeyPart = "block|" + location.getWorld().getName() + "|" + location.getBlockX() + "|" + location.getBlockY() + "|" + location.getBlockZ() + "|";
        this.sharedInventories.keySet().removeIf(key -> key.startsWith(locationKeyPart));
    }

    public void closeAllInventories() {
        for (Inventory inventory : this.sharedInventories.values()) {
            for (HumanEntity viewer : inventory.getViewers()) {
                viewer.closeInventory();
            }
        }
    }

    public void saveTo(Player player, Gui gui, Inventory inventory) {
        int saveType = gui.getSaveDataMethode();
        JsonArray array = GetItemNBT.inventoryItemsToJsonArray(inventory, gui.getSkeleton());
        switch (saveType) {
            case 1: {
                String key = this.reverseLookupMap.get(inventory);
                Location loc = TableGUI.parseBlockKey(key);
                this.databaseManager.saveToBlock(loc, gui.getFile(), array);
                break;
            }
            case 2: {
                this.databaseManager.saveToPlayer(player, gui.getFile(), array);
                break;
            }
            case 3: {
                this.databaseManager.saveGlobally(gui.getFile(), array);
                break;
            }
            case 4: {
                this.databaseManager.saveToTeam(player, gui.getFile(), array);
            }
        }
    }

    public static Location parseBlockKey(String key) {
        if (key == null || !key.startsWith("block|")) {
            String message = CustomGuiReworked.languageMap.getOrDefault("InvalidBlockKey", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0431\u043b\u043e\u043a\u0430: %s");
            throw new IllegalArgumentException(String.format(message, key));
        }
        String[] parts = key.split("|");
        if (parts.length != 6) {
            String message = CustomGuiReworked.languageMap.getOrDefault("BlockKeyMustHave6Parts", "\u041a\u043b\u044e\u0447 \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c 6 \u0447\u0430\u0441\u0442\u0435\u0439: %s");
            throw new IllegalArgumentException(String.format(message, key));
        }
        try {
            String worldName = parts[1];
            int x = Integer.parseInt(parts[2]);
            int y = Integer.parseInt(parts[3]);
            int z = Integer.parseInt(parts[4]);
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                String message = CustomGuiReworked.languageMap.getOrDefault("WorldNotLoaded", "\u041c\u0438\u0440 '%s' \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d");
                throw new IllegalArgumentException(String.format(message, worldName));
            }
            return new Location(world, (double)x, (double)y, (double)z);
        }
        catch (NumberFormatException e) {
            String message = CustomGuiReworked.languageMap.getOrDefault("CoordinatesMustBeNumbers", "\u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u0432 \u043a\u043b\u044e\u0447\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u0430\u043c\u0438: %s");
            throw new IllegalArgumentException(String.format(message, key), e);
        }
    }

    public String getFileNameByInventory(Inventory inventory) {
        for (Map.Entry<String, Inventory> entry : this.sharedInventories.entrySet()) {
            String key;
            int lastPipeIndex;
            if (!entry.getValue().equals((Object)inventory) || (lastPipeIndex = (key = entry.getKey()).lastIndexOf(124)) == -1) continue;
            return key.substring(lastPipeIndex + 1);
        }
        return null;
    }

    public Gui getGuiByInventory(Inventory inventory) {
        String fileName = this.getFileNameByInventory(inventory);
        return this.manager.getGuiByFile(fileName);
    }
}

