/*
 * Decompiled with CFR 0.152.
 */
package boatcam;

import boatcam.AngleUtil;
import boatcam.config.BoatCamConfig;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_10255;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5498;
import net.minecraft.class_638;
import net.minecraft.class_746;

public final class BoatCamMod
implements ClientModInitializer {
    private static BoatCamMod INSTANCE;
    private final class_304 MENU = new class_304("key.boatcam.menu", class_3675.class_307.field_1668, 66, "BoatCam");
    private final class_304 TOGGLE = new class_304("key.boatcam.toggle", class_3675.class_307.field_1668, -1, "BoatCam");
    private final class_304 LOOK_BEHIND = new class_304("key.boatcam.lookbehind", class_3675.class_307.field_1668, -1, "BoatCam");
    private final class_304 LOOK_LEFT = new class_304("key.boatcam.lookleft", class_3675.class_307.field_1668, -1, "BoatCam");
    private final class_304 LOOK_RIGHT = new class_304("key.boatcam.lookright", class_3675.class_307.field_1668, -1, "BoatCam");
    private class_5498 perspective = null;
    private class_5498 previousPerspective = null;
    private class_243 boatPos = class_243.field_1353;
    private float previousYaw;
    private boolean unfixedCameraActive = false;
    private boolean lookingBehind = false;

    public BoatCamMod() {
        INSTANCE = this;
    }

    public void onInitializeClient() {
        AutoConfig.register(BoatCamConfig.class, JanksonConfigSerializer::new);
        BoatCamConfig.registerPerspectiveConfiguration();
        KeyBindingHelper.registerKeyBinding((class_304)this.MENU);
        KeyBindingHelper.registerKeyBinding((class_304)this.TOGGLE);
        KeyBindingHelper.registerKeyBinding((class_304)this.LOOK_BEHIND);
        KeyBindingHelper.registerKeyBinding((class_304)this.LOOK_LEFT);
        KeyBindingHelper.registerKeyBinding((class_304)this.LOOK_RIGHT);
        ClientTickEvents.START_WORLD_TICK.register(this::onClientStartWorldTick);
    }

    private void onClientStartWorldTick(class_638 world) {
        class_1297 class_12972;
        class_310 client = class_310.method_1551();
        if (this.MENU.method_1436()) {
            client.method_1507((class_437)AutoConfig.getConfigScreen(BoatCamConfig.class, (class_437)client.field_1755).get());
            return;
        }
        if (this.TOGGLE.method_1436()) {
            BoatCamConfig.getConfig().toggleBoatMode();
            client.field_1705.method_1758((class_2561)class_2561.method_43470((String)(BoatCamConfig.getConfig().isBoatMode() ? "Boat mode" : "Normal mode")).method_27694(s -> s.method_10977(class_124.field_1060)), false);
        }
        if (BoatCamConfig.getConfig().isBoatMode() && (class_12972 = client.field_1724.method_5854()) instanceof class_10255) {
            class_10255 boat = (class_10255)class_12972;
            this.calculateYaw(client.field_1724, boat);
            if (this.unfixedCameraActive != this.shouldOverrideCamera(boat)) {
                boolean bl = this.unfixedCameraActive = !this.unfixedCameraActive;
                if (BoatCamConfig.getConfig().shouldFixPitch()) {
                    client.field_1724.method_36457((float)BoatCamConfig.getConfig().getPitch());
                }
            }
            if (this.perspective == null) {
                if (BoatCamConfig.getConfig().shouldFixPitch()) {
                    client.field_1724.method_36457((float)BoatCamConfig.getConfig().getPitch());
                }
                this.lookingBehind = false;
                this.perspective = client.field_1690.method_31044();
                switch (BoatCamConfig.getConfig().getPerspective()) {
                    case FIRST_PERSON: {
                        client.field_1690.method_31043(class_5498.field_26664);
                        break;
                    }
                    case THIRD_PERSON: {
                        client.field_1690.method_31043(class_5498.field_26665);
                    }
                }
            }
        } else if (this.perspective != null) {
            this.resetPerspective();
            if (this.lookingBehind) {
                this.invertPitch();
                this.lookingBehind = false;
            }
        }
        if (this.LOOK_BEHIND.method_1434() != this.lookingBehind) {
            this.lookingBehind = this.LOOK_BEHIND.method_1434();
            this.invertPitch();
            if (this.lookingBehind) {
                this.previousPerspective = client.field_1690.method_31044();
                client.field_1690.method_31043(class_5498.field_26666);
            } else {
                client.field_1690.method_31043(this.previousPerspective);
                this.perspective = null;
            }
        }
    }

    private void invertPitch() {
        class_746 player = class_310.method_1551().field_1724;
        player.method_36457(-player.method_36455());
    }

    private void resetPerspective() {
        class_310.method_1551().field_1690.method_31043(this.perspective);
        this.perspective = null;
    }

    private void calculateYaw(class_746 player, class_10255 boat) {
        float yaw = boat.method_36454();
        if (!this.shouldOverrideCamera(boat)) {
            this.previousYaw = yaw;
            this.boatPos = boat.method_19538();
            return;
        }
        float directionOffset = 0.0f;
        if (this.LOOK_LEFT.method_1434()) {
            yaw -= 90.0f;
            directionOffset = -90.0f;
        } else if (this.LOOK_RIGHT.method_1434()) {
            yaw += 90.0f;
            directionOffset = 90.0f;
        }
        double dx = boat.method_23317() - this.boatPos.field_1352;
        double dz = boat.method_23321() - this.boatPos.field_1350;
        if (dx != 0.0 || dz != 0.0) {
            float vel = (float)Math.hypot(dz, dx);
            float direction = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
            float t = Math.min(1.0f, vel / 3.0f);
            yaw = AngleUtil.lerp(t, yaw, direction + directionOffset);
        }
        yaw = AngleUtil.lerp(BoatCamConfig.getConfig().getSmoothness(), this.previousYaw, yaw);
        player.method_36456(yaw);
        this.previousYaw = yaw;
        this.boatPos = boat.method_19538();
    }

    public boolean onLookDirectionChanging(double dx, double dy) {
        class_746 player = class_310.method_1551().field_1724;
        class_1297 class_12972 = player.method_5854();
        if (!(class_12972 instanceof class_10255)) {
            return false;
        }
        class_10255 b = (class_10255)class_12972;
        if (BoatCamConfig.getConfig().isBoatMode() && this.shouldOverrideCamera(b) && (dx != 0.0 || BoatCamConfig.getConfig().shouldFixPitch() && dy != 0.0)) {
            player.method_5872(0.0, BoatCamConfig.getConfig().shouldFixPitch() ? 0.0 : dy);
            return true;
        }
        return false;
    }

    boolean shouldOverrideCamera(class_10255 boat) {
        return !BoatCamConfig.getConfig().isStationaryLookAround() || this.LOOK_LEFT.method_1434() || this.LOOK_RIGHT.method_1434() || boat.method_18798().method_1027() >= 4.0E-4;
    }

    public static BoatCamMod instance() {
        return INSTANCE;
    }
}

